// â”Œâ”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”� \\
// â”‚ CFProcessFlow 1.0.0 - JavaScript Process Flow Display Library      â”‚ \\
// â”œâ”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”¤ \\
// â”‚ Copyright Â© 2009-2012 Century Software                             â”‚ \\
// â”‚ http://www.centurysoftware.com.my                                  â”‚ \\
// â”œâ”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”¤ \\
// â”‚ Licensed under the MIT license.                                    â”‚ \\
// â””â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”€â”˜ \\

var actionArray = [];
var ai = 0;
launch = function(action, title) {
	if (action['actionType'] === "P") {
		window.open(action['run_url'], '_self', title);
	}
};
infocus = function() {
	this.animate({
		"50%" : {
			scale : '1.1,1.1'
		},
		"100%" : {
			scale : '1.0,1.0'
		}
	}, 500);
};
highlight = function() {
	this.attr({
		"fill" : "blue"
	});
};
unhighlight = function() {
	this.attr({
		"fill" : "black"
	});
};
drawArrowHead = function(obj, x1, y1, x2, y2) {
	var size = 3;
	var angle = Math.atan2(x1 - x2, y2 - y1);
	angle = (angle / (2 * Math.PI)) * 360;
	var a = obj.path(
			"M" + x2 + " " + y2 + " L" + (x2 - size) + " " + (y2 - size) + " L"
					+ (x2 - size) + " " + (y2 + size) + " L" + x2 + " " + y2)
			.attr("fill", "black").rotate((90 + angle), x2, y2);
	return a;
};
Raphael.fn.processReport = function(x, y, title, action, image) {
	var bg = "#fee498";
	if (image == undefined) {
		var p = [ "M", x, " ", y, "L", x + 60, " ", y, "L", x + 60, " ",
				y + 70, "L", x + 50, " ", y + 80, "L", x, " ", y + 80, "L", x,
				" ", y ];
		p1 = [ "M", x + 60, " ", y + 70, "L", x + 50, " ", y + 70, "L", x + 50,
				" ", y + 80 ];
		actionArray[ai++] = action;
		return [ this.path(p.join("")).attr({
			fill : bg,
			href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
		}).mouseover(infocus), this.path(p1.join("")).attr({
			fill : bg
		}), this.text(x + 30, y + 40, title) ]
	} else {
		return [ this.image(image.src, x, y, image.width, image.height).attr({
			href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
		}).mouseover(infocus),
				this.text(x + (image.width / 2), y + (image.height / 2), title) ]
	}
	;
};
Raphael.fn.processProcess = function(x, y, title, action, image) {
	var w = 70;
	var h = 70;
	var bg = "#6a8a4f";
	actionArray[ai++] = action;
	if (image == undefined) {
		var set = this.set();
		set.push(this.rect(x, y, w, h).attr({
			fill : bg,
			href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
		}).mouseover(infocus));
		set.push(this.text(x + 35, y + 35, title));
		return set;
		return [ this.rect(x, y, w, h).attr({
			fill : bg,
			href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
		}).mouseover(infocus), this.text(x + 35, y + 35, title) ];
	} else {
		return [ this.image(image.src, x, y, image.width, image.height).attr({
			href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
		}).mouseover(infocus),
				this.text(x + (image.width / 2), y + (image.height / 2), title) ];
	}
};
Raphael.fn.processProgram = function(x, y, title, action, image) {
	var r = 35;
	var bg = "#9fc5e8";
	actionArray[ai++] = action;
	if (image == undefined) {
		return [ this.circle(x, y, r).attr({
			fill : bg,
			href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
		}).mouseover(infocus), this.text(x, y, title) ];
	} else {
		return [ this.image(image.src, x, y, image.width, image.height).attr({
			href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
		}).mouseover(infocus),
				this.text(x + (image.width / 2), y + (image.height / 2), title) ];
	}
	;
};
Raphael.fn.processExtProgram = function(x, y, title, action) {
	var r = 35;
	var bg = "#6a8a4f";
	actionArray[ai++] = action;
	return [ this.circle(x, y, r).attr({
		fill : bg,
		href : "javascript:launch(actionArray[" + (ai - 1) + "]);"
	}).mouseover(infocus), this.text(x, y, title) ];
};
Raphael.fn.processLabel = function(x, y, text, size, anchor, href) {
	this.getFont("Arial", 800);
	return this.text(x, y, text).attr({
		"font-size" : size,
		"font-weight" : "normal",
		"font-family" : "Lucida Grande, Verdana, Arial, Tahoma, sans-serif",
		"text-anchor" : anchor,
		"href" : href
	}).mouseover(highlight).mouseout(unhighlight);
};
Raphael.fn.processLabelOnly = function(x, y, text, size, anchor) {
	this.getFont("Arial", 800);
	return this.text(x, y, text).attr({
		"font-size" : size,
		"font-weight" : "normal",
		"font-family" : "Lucida Grande, Verdana, Arial, Tahoma, sans-serif",
		"text-anchor" : anchor,
		"fill" : "8b9dc3"
	});
};
Raphael.fn.processLine = function(x, y, x1, y1) {
	var p = [ "M", x, " ", y, "L", x1, " ", y1 ];
	return this.path(p.join(""));
};
Raphael.fn.processRectangle = function(x, y, width, height, r) {
	return this.rect(x, y, width, height, r).attr({
		"fill" : "#ffffff",
		"fill-opacity" : 0.4,
		"stroke" : "#8b9dc3"
	});
};
Raphael.fn.processDirectConnector = function(x1, y1, x2, y2, e) {
	var path = "M" + x1 + " " + y1 + " L" + x2 + " " + y2;
	if (e === '>') {
		var ptr = drawArrowHead(this, x1, y1, x2, y2);
		return [ this.path(path), ptr ];
	} else {
		return this.path(path);
	}
	;
};
Raphael.fn.processInDirectConnector = function(xy, e) {
	var size = 3;
	var i;
	var path = '';
	var cmd = 'M';
	var x1, x2, y1, y2;
	for (i = 0; i < xy.length; i++) {
		x1 = x2;
		y1 = y2;
		x2 = xy[i][0];
		y2 = xy[i][1];
		path = path + cmd + x2 + " " + y2;
		cmd = " L";
		if (i === (xy.length - 1) && (e === '>')) {
			var ptr = drawArrowHead(this, x1, y1, x2, y2, e);
			return [ this.path(path), ptr ];
		}
	}
	;
	return this.path(path);
};

function drawProcessFlow(data, anchor, grid) {
	c = data.canvas;
	var canvas = Raphael(anchor, c.width, c.height);
	if (grid === true) {
		var grid = canvas.drawGrid(0, 0, c.width, c.height, 60, 40, "#e3e3e3");
	}
	;
	$.each(data.elements, function(i, e) {
		switch (e.obj_type) {
		case "processLabel":
			canvas.processLabel(e.x, e.y, e.text, e.size, e.anchor, e.href);
			break;
		case "processLabelOnly":
			canvas.processLabelOnly(e.x, e.y, e.text, e.size, e.anchor);
			break;
		case "processProcess":
			canvas.processProcess(e.x, e.y, e.title, e.action, e.image);
			break;
		case "processExtProgram":
			canvas.processExtProgram(e.x, e.y, e.title, e.action);
			break;
		case "processProgram":
			canvas.processProgram(e.x, e.y, e.title, e.action, e.image);
			break;
		case "processReport":
			canvas.processReport(e.x, e.y, e.title, e.action, e.image);
			break;
		case "processDirectConnector":
			canvas.processDirectConnector(e.x1, e.y1, e.x2, e.y2, e.e);
			break;
		case "processInDirectConnector":
			canvas.processInDirectConnector(e.xy, e.e);
			break;
		case "processLine":
			canvas.processLine(e.x1, e.y1, e.x2, e.y2);
			break;
		case "processRectangle":
			canvas.processRectangle(e.x, e.y, e.width, e.height, e.r);
			break;
		}
		;
	});
};