<?php

include_once 'header.php';

$operator = $_SESSION['userid'];
$operator_name = $_SESSION['username'];
$kumpulan = $_SESSION['kumpulan'];
$terminal = $_SESSION['terminal'];

$today = date ( 'd/m/Y' );

?>
<title><?=$strReportEndDay?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnReport').attr("disabled", false);

	loadDisabledField();
});

//make enter key behave like tab key
$('input').live('keydown', function(e) {
	if (e.keyCode == 13) {
		var id = this.id;
		if ( id == "operator" ) {
			$("#kumpulan").select();
		} else if ( id == "kumpulan" ) {
			$("#terminal").select();
		} else if ( id == "terminal" ) {
			$("#tarikh").select();
		} else if ( id == "tarikh" ) {
			$("#operator").select();
		}
	}
});

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search,add,modify only
	if (action == 'report') {
		$('#operator').attr("readonly", false);
		$('#kumpulan').attr("readonly", false);
		$('#terminal').attr("readonly", false);
		$('#tarikh').attr("readonly", false);
		$("#tarikh").datepicker({dateFormat:'dd/mm/yy'});
	} else {
		$('#operator').attr("readonly", true);
		$('#kumpulan').attr("readonly", true);
		$('#terminal').attr("readonly", true);
		$('#tarikh').attr("readonly", true);
		$("#tarikh").datepicker('destroy');
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'report') {
		var operator = $('#operator').val();
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var tarikh = $('#tarikh').val();

		$.post("re_tamathari_search.php", {
			operator: operator, 
			kumpulan: kumpulan, 
			terminal: terminal, 
			tarikh: tarikh 
			}, function(data) {
				if (data.total > 0) {
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnReport').attr("disabled", false);

					$('#action').val("data");
					loadDisabledField();

					//print report pdf
					window.location.href = 're_tamathari_print.php?operator='+operator+'&kumpulan='+kumpulan+'&terminal='+terminal+'&tarikh='+tarikh;
				} else {
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnReport').attr("disabled", false);

					$('#action').val("");
					loadDisabledField();
					alert("Tiada data untuk diproses. Klik OK untuk seterusnya.");
				}
					window.location.href = 're_tamathari_print.php?operator='+operator+'&kumpulan='+kumpulan+'&terminal='+terminal+'&tarikh='+tarikh;
		}, "json");
	}
	
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnReport').attr("disabled", false);

	resetAllField();
}

//when click search
function doReport () {
	$('#action').val("report");
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnReport').attr("disabled", true);

	resetAllField();

	//default value
	$('#operator').val('<?=$operator;?>');
	$('#operator_name').val('<?=$operator_name;?>');
	$('#kumpulan').val('<?=$kumpulan;?>');
	$('#terminal').val('<?=$terminal;?>');
	$('#tarikh').val('<?=$today;?>');
	
	$('#operator').focus();
}

function resetAllField () {
	$('#operator').val("");
	$('#kumpulan').val("");
	$('#terminal').val("");
	$('#tarikh').val("");
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulan.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: 'Pusat Kutipan', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchOperator () {
	try {

		var url = 'lookup_operator.php';
		
		$("#divSearchOperator").load(url);
		$("#divSearchOperator").dialog({ width: 400, height: 400, modal: true, title: 'Juruwang', 
			buttons: {
					'Pilih': function() {
						addSearchOperator();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		$.post("refresh_kumpulan.php", {
			kumpulan: $("#kumpulan").val() 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh operator
function refreshOperator () {
	try {
		$.post("refresh_operator.php", {
			operator: $("#operator").val() 
			}, function(data) {
				$("#operator_name").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}
</script>
<br>
<input type="hidden" id="action" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strReportEndDay?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_report.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td width="10%" nowrap="nowrap"><?=$strCashierNo?></td>
				<td width="90%"><input type="text" id="operator" name="operator"
					size="10" onblur="refreshOperator();" /><img id="btnSearchOperator"
					src="image/search.gif" onclick="loadSearchOperator();"
					onmouseover="this.style.cursor='pointer';"> <input type="text"
					id="operator_name" name="operator_name" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strDepGrp?></td>
				<td><input type="text" id="kumpulan" name="kumpulan" size="10"
					onblur="refreshKumpulan();" style="text-transform: uppercase" /><img
					id="btnSearchKumpulan" src="image/search.gif"
					onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"> <input type="text"
					id="kumpulan_desc" name="kumpulan_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strTerminalNo?></td>
				<td><select id="terminal" name="terminal">
				<?=$strOptionTerminal?>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiveDate?></td>
				<td><input type="text" id="tarikh" name="tarikh" size="10" /></td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
</table>
<div id="divSearchKumpulan" title=""></div>
<div id="divSearchOperator"
	title=""></div>
				<?php include_once 'footer.php';?>