<?php

include_once 'header.php';

?>
<title><?=$sys_name?> - <?=$strManualPLMIS?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	loadDisabledField();
	$( "#progressbar" ).progressbar({ value: 0 });
});

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search only
	if (action == 'search') {
		$('#tarikh').attr("readonly", false);
		$("#tarikh").datepicker({dateFormat:'dd/mm/yy'});
	} else {
		$('#tarikh').attr("readonly", true);
		$("#tarikh").datepicker('destroy');
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	if (confirm("Adakah anda pasti?")) {
		//do search
		if (action == 'search') {
			var tarikh = $('#tarikh').val();

			$.post("manual_paytran1.php", {
				tarikh: tarikh
				}, function(data) {
					var total = data.total;
					var total_r = data.total_r;
					var total_c = data.total_c;
					var total_a = data.total_a;
					var total_d = data.total_d;
					var total_m = data.total_m;
					var total_v = data.total_v;

					$('#billtranr').html(total_r);
					$('#compoundr').html(total_c);
					$('#paytran_a').html(total_a);
					$('#paytran_d').html(total_d);
					$('#paytran_m').html(total_m);
					$('#paytran_v').html(total_v);
			}, "json");
		}
	}
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click search
function search () {
	$('#action').val("search");
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnSearch').attr("disabled", true);

	$('#tarikh').val("<?=date('d/m/Y')?>");
}

function resetAllField () {
	$('#tarikh').val("");
}

</script>
<br>
<input type="hidden"
	id="action" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strManualPLMIS?></td>
		<td></td>
	</tr>
	<tr>
		<td class="font-std">Proses ini dilakukan sekiranya data gagal disalin secara auto.</td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_process.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td nowrap="nowrap" width="10%">Tarikh Kutipan</td>
				<td><input type="text" id="tarikh" name="tarikh" size="10" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
	<tr>
		<td>
		<fieldset><legend><?=$strProgress?></legend>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			class="font-std">
			<tr>
				<td width="30%">BILLTRANR</td>
				<td><div id="billtranr"></div></td>
			</tr>
			<tr>
				<td width="30%">COMPOUNDR</td>
				<td><div id="compoundr"></div></td>
			</tr>
			<tr>
				<td>PAYTRAN_A</td>
				<td><div id="paytran_a"></div></td>
			</tr>
			<tr>
				<td>PAYTRAN_D</td>
				<td><div id="paytran_d"></div></td>
			</tr>
			<tr>
				<td>PAYTRAN_M</td>
				<td><div id="paytran_m"></div></td>
			</tr>
			<tr>
				<td>PAYTRAN_V</td>
				<td><div id="paytran_v"></div></td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
</table>
<?php include_once 'footer.php';?>