<?php

include_once 'header.php';

$kumpulan = $_SESSION ['kumpulan'];
$terminal = $_SESSION ['terminal'];

?>
<title><?=$sys_name?> - <?=$strTerminalControl?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	//navigation button
	loadNaviButton();
	loadDisabledField();
});

//make enter key behave like tab key
$('input').live('keydown', function(e) {
	if (e.keyCode == 13 || e.keyCode == 9) {
		e.preventDefault();
		var id = this.id;

		if ( id == "kumpulan" ) {
			if (validate() == true) {
				$("#terminal").focus();
			}
		} else if ( id == "terminal" ) {
			$("#tarikh").select();
		} else if ( id == "tarikh" ) {
			$("#resit_start").focus();
		} else if ( id == "resit_start" ) {
			$("#resit_end").focus();
		} else if ( id == "resit_end" ) {
			$("#salinan").focus();
		} else if ( id == "salinan" ) {
			$("#printer").select();
		} else if ( id == "printer" ) {
			$("#cb_juruwang").focus();
		} else if ( id == "cb_juruwang" ) {
			$("#cb_resit").focus();
		} else if ( id == "cb_resit" ) {
			$("#cb_status").focus();
		} else if ( id == "cb_status" ) {
			$("#kumpulan").focus();
		}
	}
});

//load navigation button
function loadNaviButton () {
	var action = $('#action').val();

	//if got data, enable navigation button
	if (action == 'data') {
		$('#btnNavi1').attr("disabled", false);
		$('#btnNavi2').attr("disabled", false);
		$('#btnNavi3').attr("disabled", false);
		$('#btnNavi4').attr("disabled", false);
		$('#btnNavi5').attr("disabled", false);
		$('#btnNavi6').attr("disabled", false);
		$('#divTotal').show();
	} else {
		$('#btnNavi1').attr("disabled", true);
		$('#btnNavi2').attr("disabled", true);
		$('#btnNavi3').attr("disabled", true);
		$('#btnNavi4').attr("disabled", true);
		$('#btnNavi5').attr("disabled", true);
		$('#btnNavi6').attr("disabled", true);
		$('#divTotal').hide();
	}
}

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search,add,modify only
	if (action == 'search' || action == 'add' || action == 'modify') {
		$('#kumpulan').attr("disabled", false);
		$('#kumpulan_desc').attr("disabled", false);
		$('#btnSearchKumpulan').attr("onclick", "loadSearchKumpulan()");
		$('#btnSearchKumpulan').click("loadSearchKumpulan()");
		$('#terminal').attr("disabled", false);
		$('#resit').attr("disabled", true);
		$('#tarikh').attr("disabled", false);
		$("#tarikh").datepicker({dateFormat:'dd/mm/yy'});
		$('#cb_juruwang').attr("disabled", false);
		$('#cb_resit').attr("disabled", false);
		$('#resit_start').attr("disabled", false);
		$('#resit_end').attr("disabled", false);
		$('#salinan').attr("disabled", false);
		$('#printer').attr("disabled", false);
		$('#printer_desc').attr("disabled", false);
		$('#cb_status').attr("disabled", true);
		$('#cashier').attr("disabled", true);
		$('#cashiername').attr("disabled", true);
	} else {
		$('#kumpulan').attr("disabled", true);
		$('#kumpulan_desc').attr("disabled", true);
		$('#btnSearchKumpulan').attr("onclick", "");
		$('#terminal').attr("disabled", true);
		$('#resit').attr("disabled", true);
		$('#tarikh').attr("disabled", true);
		$("#tarikh").datepicker('destroy');
		$('#cb_juruwang').attr("disabled", true);
		$('#cb_resit').attr("disabled", true);
		$('#resit_start').attr("disabled", true);
		$('#resit_end').attr("disabled", true);
		$('#salinan').attr("disabled", true);
		$('#printer').attr("disabled", true);
		$('#printer_desc').attr("disabled", true);
		$('#cb_status').attr("disabled", true);
		$('#cashier').attr("disabled", true);
		$('#cashiername').attr("disabled", true);
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'search') {
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var resit = $('#resit').val();
		var tarikh = $('#tarikh').val();
		var cb_juruwang = $('#cb_juruwang').is(':checked');
		var cb_resit = $('#cb_resit').is(':checked');
		var resit_start = $('#resit_start').val();
		var resit_end = $('#resit_end').val();
		var salinan = $('#salinan').val();
		var printer = $('#printer').val();
		var cb_status = $('#cb_status').is(':checked');

		$.post("kawalanterminal_search.php", {
			kumpulan: kumpulan, 
			terminal: terminal, 
			resit: resit, 
			tarikh: tarikh, 
			cb_juruwang: cb_juruwang, 
			cb_resit: cb_resit, 
			resit_start: resit_start, 
			resit_end: resit_end, 
			salinan: salinan, 
			printer: printer, 
			cb_status: cb_status 
			}, function(data) {
				if (data.total > 0) {
					$('#divTotal').val('1 dari ' + data.total);
					
					//load data
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", false);
					$('#btnDelete').attr("disabled", false);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("data");
					$('#totaldata').val(data.total);
					$('#strwhere').val(data.strwhere);
					loadNaviButton();
					loadDisabledField();

					//now load the data
					loaddata();
				} else {
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("");
					loadNaviButton();
					loadDisabledField();

					$('#divTotal').show();
					$('#divTotal').val('Tiada Rekod Dipilih');
				}
		}, "json");
	}

	//do add
	if (action == 'add') {
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var resit = $('#resit').val();
		var tarikh = $('#tarikh').val();
		var cb_juruwang = $('#cb_juruwang').is(':checked');
		var cb_resit = $('#cb_resit').is(':checked');
		var resit_start = $('#resit_start').val();
		var resit_end = $('#resit_end').val();
		var salinan = $('#salinan').val();
		var printer = $('#printer').val();
		var cb_status = $('#cb_status').is(':checked');

		var gotErr = 0;
		if (kumpulan == "") {
			alert("Sila masukkan Pusat Kutipan");
			gotErr = 1;
			$("#kumpulan").focus();
		} else if (terminal == "") {
			alert("Sila masukkan Nombor Kaunter");
			gotErr = 1;
			$("#terminal").focus();
		} else if (tarikh == "") {
			alert("Sila masukkan Tarikh Penerimaan");
			gotErr = 1;
			$("#tarikh").focus();
		} 

		if (gotErr == 0) {
			$.post("validate_pusatkutipan.php", {
				kod: kumpulan 
				}, function(data) {
					if (data == 0){
						alert("Pusat Kutipan tidak wujud.");
						gotErr = 1;
						$("#kumpulan").select();
					} else {
						$.post("kawalanterminal_add.php", {
							kumpulan: kumpulan, 
							terminal: terminal,
							resit: resit,
							tarikh: tarikh,
							cb_juruwang: cb_juruwang, 
							cb_resit: cb_resit, 
							resit_start: resit_start, 
							resit_end: resit_end, 
							salinan: salinan, 
							printer: printer, 
							cb_status: cb_status 
						}, function(data) {
							if (data > 0) {
								alert('Rekod telah wujud. Sila gunakan tarikh lain.');
							} else if (data == 'x') {
								alert('Rekod tidak wujud. Sila pastikan Tarikh Permulaan Hari telah ditambah.');
							} else {
								$('#action').val("");
								loadNaviButton();
								loadDisabledField();
					
								$('#btnOk').attr("disabled", true);
								$('#btnCancel').attr("disabled", true);
								$('#btnAdd').attr("disabled", false);
								$('#btnModify').attr("disabled", false);
								$('#btnDelete').attr("disabled", false);
								$('#btnSearch').attr("disabled", false);
							}
						});	
					} 
			});
		}
	}
	
	//do modify
	if (action == 'modify') {
		var kumpulan_ori = $('#mod_kumpulan').val();
		var terminal_ori = $('#mod_terminal').val();
		var tarikh_ori = $('#mod_tarikh').val();
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var resit = $('#resit').val();
		var tarikh = $('#tarikh').val();
		var cb_juruwang = $('#cb_juruwang').is(':checked');
		var cb_resit = $('#cb_resit').is(':checked');
		var resit_start = $('#resit_start').val();
		var resit_end = $('#resit_end').val();
		var salinan = $('#salinan').val();
		var printer = $('#printer').val();
		var cb_status = $('#cb_status').is(':checked');

		var gotErr = 0;
		if (kumpulan == "") {
			alert("Sila masukkan Pusat Kutipan");
			gotErr = 1;
			$("#kumpulan").focus();
		} else if (tarikh == "") {
			alert("Sila masukkan Tarikh Penerimaan");
			gotErr = 1;
			$("#tarikh").focus();
		}

		if (gotErr == 0) {
			$.post("kawalanterminal_modify.php", {
				kumpulan_ori: kumpulan_ori, 
				terminal_ori: terminal_ori, 
				tarikh_ori: tarikh_ori, 
				kumpulan: kumpulan, 
				terminal: terminal, 
				resit: resit, 
				tarikh: tarikh, 
				cb_juruwang: cb_juruwang, 
				cb_resit: cb_resit, 
				resit_start: resit_start, 
				resit_end: resit_end, 
				salinan: salinan, 
				printer: printer, 
				cb_status: cb_status 
				}, function(data) {
					if (data == 'x') {
						alert('Data tidak wujud.');
					} else {
						$('#btnOk').attr("disabled", true);
						$('#btnCancel').attr("disabled", true);
						$('#btnAdd').attr("disabled", false);
						$('#btnModify').attr("disabled", false);
						$('#btnDelete').attr("disabled", false);
						$('#btnSearch').attr("disabled", false);
						
						$('#action').val("data");
						loadNaviButton();
						loadDisabledField();
						loaddata();
					}
				});	
		}
	}
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadNaviButton();
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click add
function doAdd () {
	$('#action').val("add");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	$('#kumpulan').focus();
	
	resetAllField();

	//default value
	$("#kumpulan").val('<?=$kumpulan;?>');
	//if ada kumpulan, refresh nama kumpulan
	if ('<?=$kumpulan?>') {
		refreshKumpulan();
	}
	$("#terminal").val('<?=$terminal;?>');
}

//when click modify
function doModify () {
	$('#action').val("modify");
	loadNaviButton();
	loadDisabledField();

	//store current value
	$('#mod_kumpulan').val($('#kumpulan').val());
	$('#mod_terminal').val($('#terminal').val());
	$('#mod_tarikh').val($('#tarikh').val());

	//readonly fields
	$('#kumpulan').attr("readonly", true);
	$('#kumpulan_desc').attr("readonly", true);
	$('#terminal').attr("readonly", true);
	$('#resit').attr("readonly", true);
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	//$('#kumpulan').focus();
}

//when click delete
function doDelete () {
	if (confirm('Adakah anda pasti untuk hapuskan rekod ini?')) {
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var tarikh = $('#tarikh').val();
		$.post("kawalanterminal_delete.php", {
			kumpulan: kumpulan, 
			terminal: terminal, 
			tarikh: tarikh 
			}, function(data) {
				if (data.total > 0) {
					alert('<?=$strRecordLock?>');
				} else {
					$('#action').val("");
					$('#currentdata').val("1");
					
					loadNaviButton();
					loadDisabledField();
					resetAllField();

					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);
				}
		}, "json");
	} else {
	}
}

//when click search
function search () {
	$('#action').val("search");
	$('#currentdata').val("1");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	resetAllField();
	
	$('#kumpulan').focus();
}

//load data to page
function loaddata () {
	var currentdata = $('#currentdata').val();
	var strwhere = $('#strwhere').val();
	$.post("kawalanterminal_search.php?getdata=1&currentdata=" + currentdata + "&strwhere=" + strwhere, {
		}, function(data) {
			var kumpulan = data.kumpulan;
			var kumpulan_desc = data.kumpulan_desc;
			var terminal = data.terminal;
			var resit = data.resit;
			var tarikh = data.tarikh;
			var cb_juruwang = data.cb_juruwang;
			var cb_resit = data.cb_resit;
			var resit_start = data.resit_start;
			var resit_end = data.resit_end;
			var salinan = data.salinan;
			var printer = data.printer;
			var printer_desc = data.printer_desc;
			var cb_status = data.cb_status;
			var cashier = data.cashier;
			var cashiername = data.cashiername;
			var createdate = data.createdate;
			var modifydate = data.modifydate;
			var operator = data.operator;
			var operatorname = data.operatorname;

			$('#kumpulan').val(kumpulan);
			$('#kumpulan_desc').val(kumpulan_desc);
			$('#terminal').val(terminal);
			$('#resit').val(resit);
			$('#tarikh').val(tarikh);
			if (cb_juruwang == 'Y') {
				$('#cb_juruwang').attr('checked',true);
			} else {
				$('#cb_juruwang').attr('checked',false);
			}
			if (cb_resit == 'Y') {
				$('#cb_resit').attr('checked',true);
			} else {
				$('#cb_resit').attr('checked',false);
			}
			$('#resit_start').val(resit_start);
			$('#resit_end').val(resit_end);
			$('#salinan').val(salinan);
			$('#printer').val(printer);
			$('#printer').val(printer);
			$('#printer_desc').val(printer_desc);
			if (cb_status == 'Y') {
				$('#cb_status').val('B - Buka');
			} else {
				$('#cb_status').val('T - Tutup');
			}
			$('#cashier').val(cashier);
			$('#cashiername').val(cashiername);
			$('#createdate').val(createdate);
			$('#modifydate').val(modifydate);
			$('#modoperator').val(operator);
			$('#modoperatorname').val(operatorname);
		}, "json");
}

//when click next navigation
function datanavinext () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev navigation
function datanaviprev () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click next 10 navigation
function datanavinext10 () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 10;
		if (currentdata > $('#totaldata').val()) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev 10 navigation
function datanaviprev10 () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 10;
		if (currentdata < 1) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click last navigation
function datanavilast () {
	var currentdata = $('#totaldata').val();
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click first navigation
function datanavifirst () {
	var currentdata = 1;
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

function resetAllField () {
	//reset all field
	$('#kumpulan').val("");
	$('#kumpulan_desc').val("");
	$('#terminal').val("");
	$('#resit').val("");
	$('#tarikh').val("");
	$('#cb_juruwang').attr("checked",false);
	$('#cb_resit').attr("checked",false);
	$('#resit_start').val("");
	$('#resit_end').val("");
	$('#salinan').val("");
	$('#printer').val("");
	$('#printer_desc').val("");
	//$('#cb_status').attr("checked",false);
	$('#cb_status').val("");
	
	$('#createdate').val("");
	$('#modifydate').val("");
	$('#modoperator').val("");
	$('#modoperatorname').val("");
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulan.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: 'Pusat Kutipan', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchPrinter () {
	try {

		var url = 'lookup_printer.php';
		
		$("#divSearchPrinter").load(url);
		$("#divSearchPrinter").dialog({ width: 400, height: 400, modal: true, title: 'Printer', 
			buttons: {
					'Pilih': function() {
						addSearchPrinter();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		var kumpulan = $("#kumpulan").val();
		$.post("refresh_kumpulan.php", {
			kumpulan: kumpulan 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh printer
function refreshPrinter () {
	try {
		$.post("refresh_printer.php", {
			printer: $("#printer").val() 
			}, function(data) {
				$("#printer_desc").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function validate () {
	var kod = $("#kumpulan").val();
	var action = $("#action").val();

	if (action == "add" || action == "modify") {
		$.post("validate_pusatkutipan.php", {
			kod: kod 
			}, function(data) {
				if (data == 0){
					alert("Pusat Kutipan tidak wujud.");
					$("#kumpulan").select();
					return false;
				} else {
					refreshKumpulan();
					$("#terminal").focus();
					return true;
				} 
		});
	} else {
		return true; 
	}
}

function doList () {
	location.href='kawalanterminal_list.php';
}

</script>
<br />
<input type="hidden" id="action" value="">
<input type="hidden"
	id="currentdata" value="1">
<input type="hidden" id="totaldata" value="0">
<input type="hidden" id="strwhere" value="0">
<input type="hidden"
	id="mod_kumpulan" value="">
<input type="hidden"
	id="mod_terminal" value="">
<input type="hidden"
	id="mod_tarikh" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strTerminalControl?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_all.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_navi.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td width="10%" nowrap="nowrap"><?=$strDepGrp?></td>
				<td><input type="text" id="kumpulan" name="kumpulan" size="10"
					style="text-transform: uppercase" /><img id="btnSearchKumpulan"
					src="image/search.gif" onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kumpulan_desc" name="kumpulan_desc" size="50" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strTerminalNo?></td>
				<td><select id="terminal" name="terminal" class="font-std">
				<?=$strOptionTerminal?>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiveDate?></td>
				<td><input type="text" id="tarikh" name="tarikh" size="10" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strBeginningReceiptNo?></td>
				<td><input type="text" id="resit_start" name="resit_start" size="10" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strClosureReceiptNo?></td>
				<td><input type="text" id="resit_end" name="resit_end" size="10" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiptNo?></td>
				<td><input type="text" id="resit" name="resit" size="10"
					disabled="disabled" /></td>
			</tr>
			<tr style="display: none;">
				<td nowrap="nowrap"><?=$strCopyOption?></td>
				<td><select id="salinan">
					<option value=""></option>
					<option value="H">Simpan ke Fail</option>
					<option value="N">Tangguh Cetak</option>
					<option value="Y">Terus Cetak</option>
				</select></td>
			</tr>
			<tr style="display: none;">
				<td nowrap="nowrap"><?=$strDefaultPrinter?></td>
				<td><input type="text" id="printer" size="10"
					onblur="refreshPrinter();" /><img src="image/search.gif"
					onclick="loadSearchPrinter();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="printer_desc" size="50" /></td>
			</tr>
			<tr style="display: none;">
				<td nowrap="nowrap"><?=$strPermanentCashier?></td>
				<td><input type="checkbox" id="cb_juruwang" name="cb_juruwang"></td>
			</tr>
			<tr style="display: none;">
				<td nowrap="nowrap"><?=$strReceiptRateRequired?></td>
				<td><input type="checkbox" id="cb_resit" name="cb_resit"></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strCounterStatus?></td>
				<td><input type="text" id="cb_status" name="cb_status" size="10"></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strCashierName?></td>
				<td><input type="text" id="cashier" name="cashier" size="10" /> <input
					type="text" id="cashiername" name="cashiername" size="50" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_createdby.php';?></td>
		<td></td>
	</tr>
</table>
<div id="divSearchKumpulan" title=""></div>
<div id="divSearchPrinter" title=""></div>
				<?php include_once 'footer.php';?>