<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$a = 0;
$sql = "SELECT DATE_FORMAT( a.rcp_dte, '%d/%m/%Y' ) rcp_dte,e.las_nme,b.mdu_acc,b.des_ref,c.pay_typ,b.rcp_typ,d.bnk_brn,SUM(b.rcp_amt) + SUM(b.tax_amt) amt
FROM 
(aurerecp a, aureline b, aurepymt c, aumnoper e) 
LEFT JOIN aualbsbn d ON c.bnk_bsb=d.bnk_bsb
WHERE
a.rcp_num=b.rcp_num
AND a.rcp_num=c.rcp_num
AND a.opr_num=e.opr_num
AND a.dep_grp=b.dep_grp
AND a.dep_grp=c.dep_grp
AND a.tty_num=b.tty_num
AND a.tty_num=c.tty_num
AND a.rcp_dte=b.rcp_dte
AND a.rcp_dte=c.rcp_dte
$strWhere
GROUP BY a.rcp_num";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$rcp_dte = $row ['rcp_dte'];
	$las_nme = $row ['las_nme'];
	$mdu_acc = $row ['mdu_acc'];
	$des_ref = $row ['des_ref'];
	$pay_typ = $row ['pay_typ'];
	$rcp_typ = $row ['rcp_typ'];
	$bnk_brn = $row ['bnk_brn'];
	$amt = $row ['amt'];
	$arrResult [++$a]['rcp_dte'] = $rcp_dte;
	$arrResult [$a]['las_nme'] = $las_nme;
	$arrResult [$a]['mdu_acc'] = $mdu_acc;
	$arrResult [$a]['des_ref'] = $des_ref;
	$arrResult [$a]['pay_typ'] = $pay_typ;
	$arrResult [$a]['rcp_typ'] = $rcp_typ;
	$arrResult [$a]['bnk_brn'] = $bnk_brn;
	$arrResult [$a]['amt'] = $amt;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs16 = strtoupper($strCs16);
$strKumpulan = strtoupper($kumpulan);
$strFontSize = 10;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('P','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-16", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs16", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan", 0, 0, 'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER     : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI : $tarikhdari     TARIKH HINGGA : $tarikhkepada", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"BIL TARIKH       NO BIL        KOD HASIL   CARA BAYARAN             JUMLAH", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"    PENGGUNA     NO RESIT AM               JENIS BANK", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"--------------------------------------------------------------------------", 0, 0, 'L');

//each tarikh different page
$bil = 0;
foreach ($arrResult as $curResult) {
	$rcp_dte = $curResult['rcp_dte'];
	$mdu_acc = $curResult['mdu_acc'];
	$des_ref = $curResult['des_ref'];
	$pay_typ = $curResult['pay_typ'];
	$rcp_typ = $curResult['rcp_typ'];
	$bnk_brn = $curResult['bnk_brn'];
	$amt = $curResult['amt'];
	$totAmt += $amt;
	++$bil;

	switch ($pay_typ) {
		case 1 :
			$pay_typ = "TUNAI";
			break;
		case 2 :
			$pay_typ = "CEK";
			break;
		case 3 :
			$pay_typ = "KAD KREDIT";
			break;
		case 4 :
			$pay_typ = "WANG POS";
			break;
		case 5 :
			$pay_typ = "EFT";
			break;
		case 6 :
			$pay_typ = "BANK DERAF";
			break;
		case 7 :
			$pay_typ = "BANK SLIP";
			break;
	}

	$strBil = str_pad($bil, 3, " ", STR_PAD_RIGHT);
	$strTarikh = str_pad($rcp_dte, 10, " ", STR_PAD_RIGHT);
	$strPengguna = str_pad(substr($las_nme,0,10), 10, " ", STR_PAD_RIGHT);
	$strNoBil = str_pad($mdu_acc, 11, " ", STR_PAD_RIGHT);
	$strNoResitAm = str_pad($des_ref, 11, " ", STR_PAD_RIGHT);
	$strKodHasil = str_pad($rcp_typ, 9, " ", STR_PAD_RIGHT);
	$strCaraBayaran = str_pad($pay_typ, 12, " ", STR_PAD_RIGHT);
	$strJenisBank = str_pad($bnk_brn, 12, " ", STR_PAD_RIGHT);
	$strAmt = str_pad(number_format($amt,2), 18, " ", STR_PAD_LEFT);


	$pdf->Ln();
	$pdf->Cell(0,3,"$strBil $strTarikh   $strNoBil   $strKodHasil   $strCaraBayaran $strAmt", 0, 0, 'L');
	$pdf->Ln();
	$pdf->Cell(0,3,"    $strPengguna   $strNoResitAm               $strJenisBank", 0, 0, 'L');
	$pdf->Ln();
	$pdf->Cell(0,1,"", 0, 0, 'L');
}

$strTotAmt = str_pad(number_format($totAmt,2), 67, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"JUMLAH $strTotAmt", 0, 0, 'L');

$pdf->Output("CS16_$today_pdf.pdf","D");

?>
