<?php

include_once 'header.php';

?>
<title><?=$sys_name?> - <?=$strCs05;?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnReport').attr("disabled", false);

	loadDisabledField();
});

//make enter key behave like tab key
$('input').live('keydown', function(e) {
	if (e.keyCode == 13) {
		var id = this.id;
		if ( id == "kumpulan" ) {
			$("#paytypedari").select();
		} else if ( id == "paytypedari" ) {
			$("#paytypeke").select();
		} else if ( id == "paytypeke" ) {
			$("#tarikhdari").select();
		} else if ( id == "tarikhdari" ) {
			$("#tarikhkepada").select();
		} else if ( id == "tarikhkepada" ) {
			$("#kumpulan").select();
		}
	}
});

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search,add,modify only
	if (action == 'report') {
		$('#kumpulan').attr("readonly", false);
		$('#kumpulan_desc').attr("readonly", true);
		$('#tarikhdari').attr("readonly", false);
		$("#tarikhdari").datepicker({dateFormat:'dd/mm/yy'});
		$('#tarikhkepada').attr("readonly", false);
		$("#tarikhkepada").datepicker({dateFormat:'dd/mm/yy'});
		$('#paytypedari').attr("readonly", false);
		$('#paytypeke').attr("readonly", false);
	} else {
		$('#kumpulan').attr("readonly", true);
		$('#kumpulan_desc').attr("readonly", true);
		$('#tarikhdari').attr("readonly", true);
		$("#tarikhdari").datepicker('destroy');
		$('#tarikhkepada').attr("readonly", true);
		$("#tarikhkepada").datepicker('destroy');
		$('#paytypedari').attr("readonly", true);
		$('#paytypeke').attr("readonly", true);
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'report') {
		var kumpulan = $('#kumpulan').val();
		var tarikhdari = $('#tarikhdari').val();
		var tarikhkepada = $('#tarikhkepada').val();
		var paytypedari = $('#paytypedari').val();
		var paytypeke = $('#paytypeke').val();

		var gotErr = 0;
		if (kumpulan == "") {
			alert("Sila masukkan <?=$strDepGrp?>.");
			gotErr = 1;
			$("#kumpulan").focus();
		} 
		
		if (gotErr == 0) {
			$.post("cs05_search.php", {
				kumpulan: kumpulan, 
				tarikhdari: tarikhdari, 
				tarikhkepada: tarikhkepada,
				paytypedari: paytypedari, 
				paytypeke: paytypeke  
				}, function(data) {
					if (data.total > 0) {
						$('#btnOk').attr("disabled", true);
						$('#btnCancel').attr("disabled", true);
						$('#btnReport').attr("disabled", false);
	
						$('#action').val("data");
						loadDisabledField();
	
						//print report pdf
						window.location.href = 'cs05_print.php?kumpulan='+kumpulan+'&tarikhdari='+tarikhdari+'&tarikhkepada='+tarikhkepada+'&paytypedari='+paytypedari+'&paytypeke='+paytypeke;
					} else {
						$('#btnOk').attr("disabled", true);
						$('#btnCancel').attr("disabled", true);
						$('#btnReport').attr("disabled", false);
	
						$('#action').val("");
						loadDisabledField();
						alert("Tiada data untuk diproses. Klik OK untuk seterusnya.");
					}
			}, "json");
		}
	}
	
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnReport').attr("disabled", false);

	resetAllField();
}

//when click search
function doReport () {
	$('#action').val("report");
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnReport').attr("disabled", true);

	resetAllField();

	$('#kumpulan').focus();
}

function resetAllField () {
	$('#kumpulan').val("");
	$('#kumpulan_desc').val("");
	$('#tarikhdari').val("");
	$('#tarikhkepada').val("");
	$('#paytypedari').val("");
	$('#paytypedari_desc').val("");
	$('#paytypeke').val("");
	$('#paytypeke_desc').val("");
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulan.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: '<?=$strDepGrp?>', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		var kumpulan = $("#kumpulan").val();
		$.post("refresh_kumpulan.php", {
			kumpulan: kumpulan 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
		if (kumpulan) {
			$("#paytypedari").select();
		}
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchPaytypeDari () {
	try {

		var url = 'lookup_jenisbayarandari.php';
		
		$("#divSearchPaytypeDari").load(url);
		$("#divSearchPaytypeDari").dialog({ width: 400, height: 400, modal: true, title: 'Jenis Bayaran Dari', 
			buttons: {
					'Pilih': function() {
						addSearchPaytypeDari();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchPaytypeKe () {
	try {

		var url = 'lookup_jenisbayaranke.php';
		
		$("#divSearchPaytypeKe").load(url);
		$("#divSearchPaytypeKe").dialog({ width: 400, height: 400, modal: true, title: 'Jenis Bayaran Hingga', 
			buttons: {
					'Pilih': function() {
						addSearchPaytypeKe();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}
</script>
<br>
<input type="hidden" id="action" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strCs05;?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_report.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td width="10%" nowrap="nowrap"><?=$strDepGrp;?></td>
				<td><input type="text" id="kumpulan" name="kumpulan" size="10"
					onblur="refreshKumpulan();" style="text-transform: uppercase" /><img
					id="btnSearchKumpulan" src="image/search.gif"
					onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kumpulan_desc" name="kumpulan_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strPayTypeFrom;?></td>
				<td><input type="text" id="paytypedari" name="paytypedari" size="10" /><img
					id="btnSearchPaytypeDari" src="image/search.gif"
					onclick="loadSearchPaytypeDari();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="paytypedari_desc" name="paytypedari_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strPayTypeTo;?></td>
				<td><input type="text" id="paytypeke" name="paytypeke" size="10" /><img
					id="btnSearchPaytypeKe" src="image/search.gif"
					onclick="loadSearchPaytypeKe();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="paytypeke_desc" name="paytypeke_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiptDateFrom;?></td>
				<td><input type="text" id="tarikhdari" name="tarikhdari" size="10" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiptDateTo;?></td>
				<td><input type="text" id="tarikhkepada" name="tarikhkepada"
					size="10" /></td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
</table>
<div id="divSearchKumpulan"
	title=""></div>
<div id="divSearchPaytypeDari"
	title=""></div>
<div id="divSearchPaytypeKe"
	title=""></div>
<?php include_once 'footer.php';?>