<?php

Class Aradjbatch {

	protected $sqlTable = 'ar_adjbatch';
	
	public $arabcompany;  //arab_company char(4)
	public $arabtransid;  //arab_transid char(8)
	public $arabtrdate;  //arab_trdate date
	public $arabsource;  //arab_source char(3)
	public $arabcurcode;  //arab_curcode char(3)
	public $arabcurrate;  //arab_currate double(10,4)
	public $arabbaseunit;  //arab_baseunit int(10)
	public $araboperator;  //arab_operator char(1)
	public $arabheld;  //arab_held char(1)
	public $arabposted;  //arab_posted char(1)
	public $arabpostdate;  //arab_postdate date
	public $arabnprefid;  //arab_nprefid int(10)
	public $arabwho;  //arab_who char(20)
	public $arabdtime;  //arab_dtime datetime
	public $arabldtime;  //arab_ldtime datetime
	public $flguploaded;  //flg_uploaded char(1)

	public function insert() {

		if ( strlen ( $this->arabcompany ) > 0 ) { $insertCols .= "arab_company, "; $insertVals .= "'$this->arabcompany', "; }
		if ( strlen ( $this->arabtransid ) > 0 ) { $insertCols .= "arab_transid, "; $insertVals .= "'$this->arabtransid', "; }
		if ( strlen ( $this->arabtrdate ) > 0 ) { $insertCols .= "arab_trdate, "; $insertVals .= "STR_TO_DATE('$this->arabtrdate','%d/%m/%Y'), "; }
		if ( strlen ( $this->arabsource ) > 0 ) { $insertCols .= "arab_source, "; $insertVals .= "'$this->arabsource', "; }
		if ( strlen ( $this->arabcurcode ) > 0 ) { $insertCols .= "arab_curcode, "; $insertVals .= "'$this->arabcurcode', "; }
		if ( strlen ( $this->arabcurrate ) > 0 ) { $insertCols .= "arab_currate, "; $insertVals .= "'$this->arabcurrate', "; }
		if ( strlen ( $this->arabbaseunit ) > 0 ) { $insertCols .= "arab_baseunit, "; $insertVals .= "'$this->arabbaseunit', "; }
		if ( strlen ( $this->araboperator ) > 0 ) { $insertCols .= "arab_operator, "; $insertVals .= "'$this->araboperator', "; }
		if ( strlen ( $this->arabheld ) > 0 ) { $insertCols .= "arab_held, "; $insertVals .= "'$this->arabheld', "; }
		if ( strlen ( $this->arabposted ) > 0 ) { $insertCols .= "arab_posted, "; $insertVals .= "'$this->arabposted', "; }
		if ( strlen ( $this->arabpostdate ) > 0 ) { $insertCols .= "arab_postdate, "; $insertVals .= "STR_TO_DATE('$this->arabpostdate','%d/%m/%Y'), "; }
		if ( strlen ( $this->arabnprefid ) > 0 ) { $insertCols .= "arab_nprefid, "; $insertVals .= "'$this->arabnprefid', "; }
		if ( strlen ( $this->arabwho ) > 0 ) { $insertCols .= "arab_who, "; $insertVals .= "'$this->arabwho', "; }
		if ( strlen ( $this->arabdtime ) > 0 ) { $insertCols .= "arab_dtime, "; $insertVals .= "STR_TO_DATE('$this->arabdtime','%d/%m/%Y'), "; }
		if ( strlen ( $this->arabldtime ) > 0 ) { $insertCols .= "arab_ldtime, "; $insertVals .= "STR_TO_DATE('$this->arabldtime','%d/%m/%Y'), "; }
		if ( strlen ( $this->flguploaded ) > 0 ) { $insertCols .= "flg_uploaded, "; $insertVals .= "'$this->flguploaded', "; }

		$insertCols = eregi_replace(", $", "", $insertCols);
		$insertVals = eregi_replace(", $", "", $insertVals);

		$sql = "INSERT INTO $this->sqlTable ($insertCols)";
		$sql .= " VALUES ($insertVals)";

		db_query ( $sql );
	}

	public function update() {

		$sql = "UPDATE $this->sqlTable SET ";

		if ( strlen ( $this->arabcompany ) > 0 ) { $sql .= "arab_company = '$this->arabcompany', "; }
		if ( strlen ( $this->arabtransid ) > 0 ) { $sql .= "arab_transid = '$this->arabtransid', "; }
		if ( strlen ( $this->arabtrdate ) > 0 ) { $sql .= "arab_trdate = STR_TO_DATE('$this->arabtrdate','%d/%m/%Y'), "; }
		if ( strlen ( $this->arabsource ) > 0 ) { $sql .= "arab_source = '$this->arabsource', "; }
		if ( strlen ( $this->arabcurcode ) > 0 ) { $sql .= "arab_curcode = '$this->arabcurcode', "; }
		if ( strlen ( $this->arabcurrate ) > 0 ) { $sql .= "arab_currate = '$this->arabcurrate', "; }
		if ( strlen ( $this->arabbaseunit ) > 0 ) { $sql .= "arab_baseunit = '$this->arabbaseunit', "; }
		if ( strlen ( $this->araboperator ) > 0 ) { $sql .= "arab_operator = '$this->araboperator', "; }
		if ( strlen ( $this->arabheld ) > 0 ) { $sql .= "arab_held = '$this->arabheld', "; }
		if ( strlen ( $this->arabposted ) > 0 ) { $sql .= "arab_posted = '$this->arabposted', "; }
		if ( strlen ( $this->arabpostdate ) > 0 ) { $sql .= "arab_postdate = STR_TO_DATE('$this->arabpostdate','%d/%m/%Y'), "; }
		if ( strlen ( $this->arabnprefid ) > 0 ) { $sql .= "arab_nprefid = '$this->arabnprefid', "; }
		if ( strlen ( $this->arabwho ) > 0 ) { $sql .= "arab_who = '$this->arabwho', "; }
		if ( strlen ( $this->arabdtime ) > 0 ) { $sql .= "arab_dtime = STR_TO_DATE('$this->arabdtime','%d/%m/%Y'), "; }
		if ( strlen ( $this->arabldtime ) > 0 ) { $sql .= "arab_ldtime = STR_TO_DATE('$this->arabldtime','%d/%m/%Y'), "; }

		$sql = eregi_replace ( ', $', '', $sql);

		$sql .= " WHERE 1=1 ";


		db_query ( $sql );
	}

	public function select() {

		$sql = "SELECT *
		, DATE_FORMAT(arab_trdate,'%d/%m/%Y') arab_trdate
		, DATE_FORMAT(arab_postdate,'%d/%m/%Y') arab_postdate
		, DATE_FORMAT(arab_dtime,'%d/%m/%Y %H:%i:%s') arab_dtime
		, DATE_FORMAT(arab_ldtime,'%d/%m/%Y %H:%i:%s') arab_ldtime
		FROM $this->sqlTable WHERE 1=1 ";

		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$this->arabcompany = $row ['arab_company'];
			$this->arabtransid = $row ['arab_transid'];
			$this->arabtrdate = $row ['arab_trdate'];
			$this->arabsource = $row ['arab_source'];
			$this->arabcurcode = $row ['arab_curcode'];
			$this->arabcurrate = $row ['arab_currate'];
			$this->arabbaseunit = $row ['arab_baseunit'];
			$this->araboperator = $row ['arab_operator'];
			$this->arabheld = $row ['arab_held'];
			$this->arabposted = $row ['arab_posted'];
			$this->arabpostdate = $row ['arab_postdate'];
			$this->arabnprefid = $row ['arab_nprefid'];
			$this->arabwho = $row ['arab_who'];
			$this->arabdtime = $row ['arab_dtime'];
			$this->arabldtime = $row ['arab_ldtime'];
		}

	}

	public function count () {

		$total = 0;
		$sql = "SELECT COUNT(*) TOTAL FROM $this->sqlTable WHERE 1=1 ";


		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$total = $row ['TOTAL'];
		}
		return $total;

	}

	public function delete () {

		$sql = "DELETE FROM $this->sqlTable WHERE 1=1";


		db_query ( $sql );

	}

}

?>