<?php

include_once 'lib/acl.php';

if ($arrACL ['user'] != 1){
	header('Location: error.php');
}

include_once 'header.php';

?>
<title><?=$sys_name?> - <?=$strUserMaintenance?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	//navigation button
	loadNaviButton();
	loadDisabledField();
});

//make enter key behave like tab key
$( document ).on('keydown','input', function(e) { 
	if (e.keyCode == 13) {
		var id = this.id;
		if ( id == "las_nme" ) {
			$("#frs_nme").select();
		} else if ( id == "frs_nme" ) {
			$("#opr_role").focus();
		} else if ( id == "opr_role" ) {
			$("#pwd").focus();
		} else if ( id == "pwd" ) {
			$("#atv_flg").focus();
		}
	}
});

//load navigation button
function loadNaviButton () {
	var action = $('#action').val();

	//if got data, enable navigation button
	if (action == 'data') {
		$('#btnNavi1').attr("disabled", false);
		$('#btnNavi2').attr("disabled", false);
		$('#btnNavi3').attr("disabled", false);
		$('#btnNavi4').attr("disabled", false);
		$('#btnNavi5').attr("disabled", false);
		$('#btnNavi6').attr("disabled", false);
		$('#divTotal').show();
	} else {
		$('#btnNavi1').attr("disabled", true);
		$('#btnNavi2').attr("disabled", true);
		$('#btnNavi3').attr("disabled", true);
		$('#btnNavi4').attr("disabled", true);
		$('#btnNavi5').attr("disabled", true);
		$('#btnNavi6').attr("disabled", true);
		$('#divTotal').hide();
	}
}

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search,add,modify only
	if (action == 'search' || action == 'add' || action == 'modify') {
		$('#opr_num').attr("readonly", false);
		$('#frs_nme').attr("readonly", false);
		$('#las_nme').attr("readonly", false);
		$('#opr_role').attr("disabled", false);
		$('#pwd').attr("readonly", false);
		$('#dep_grp').attr("disabled", false);
		$('#atv_flg').attr("disabled", false);
	} else {
		$('#opr_num').attr("readonly", true);
		$('#frs_nme').attr("readonly", true);
		$('#las_nme').attr("readonly", true);
		$('#opr_role').attr("disabled", true);
		$('#pwd').attr("readonly", true);
		$('#dep_grp').attr("disabled", true);
		$('#atv_flg').attr("disabled", true);
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'search') {
		var opr_num = $('#opr_num').val();
		var frs_nme = $('#frs_nme').val();
		var las_nme = $('#las_nme').val();
		var opr_role = $('#opr_role').val();
		var dep_grp = $('#dep_grp').val();
		var atv_flg = $('#atv_flg').val();

		$.post("user_search.php", {
			opr_num: opr_num, 
			frs_nme: frs_nme, 
			las_nme: las_nme, 
			opr_role: opr_role, 
			dep_grp: dep_grp,
			atv_flg: atv_flg 
			}, function(data) {
				if (data.total > 0) {
					$('#divTotal').val('1 dari ' + data.total);
					
					//load data
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", false);
					$('#btnDelete').attr("disabled", false);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("data");
					$('#totaldata').val(data.total);
					$('#strwhere').val(data.strwhere);
					loadNaviButton();
					loadDisabledField();

					//now load the data
					loaddata();
				} else {
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("");
					loadNaviButton();
					loadDisabledField();

					$('#divTotal').show();
					$('#divTotal').val('Tiada Rekod Dipilih');
				}
		}, "json");
	}

	//do add
	if (action == 'add') {
		var opr_num = $('#opr_num').val();
		var frs_nme = $('#frs_nme').val();
		var las_nme = $('#las_nme').val();
		var opr_role = $('#opr_role').val();
		var dep_grp = $('#dep_grp').val();
		var atv_flg = $('#atv_flg').val();
		var pwd = $('#pwd').val();

		var gotErr = 0;
		if (las_nme == "") {
			alert("Sila masukkan <?=$strUserId?>.");
			gotErr = 1;
			$("#las_nme").focus();
		} else if (frs_nme == "") {
			alert("Sila masukkan <?=$strUserName?>.");
			gotErr = 1;
			$("#frs_nme").focus();
		} else if (opr_role == "") {
			alert("Sila masukkan <?=$strRole?>.");
			gotErr = 1;
			$("#opr_role").focus();
		} else if (pwd == "") {
			alert("Sila masukkan <?=$strPwd?>.");
			gotErr = 1;
			$("#pwd").focus();
		}

		if (las_nme != "") {
			if (/[ ]/.test(las_nme)) {
				alert('Pastikan <?=$strUserId?> tiada jarak (space).');
				gotErr = 1;
				$("#las_nme").focus();
			}
		}

		if (gotErr == 0) {
			$.post("user_add.php", {
				opr_num: opr_num, 
				frs_nme: frs_nme, 
				las_nme: las_nme, 
				opr_role: opr_role, 
				dep_grp: dep_grp, 
				pwd: pwd 
			}, function(data) {
				if (data > 0) {
					alert('Rekod telah wujud.\nSila gunakan <?=$strUserId?> baru.');
				} else {
					$('#action').val("");
					loadNaviButton();
					loadDisabledField();
		
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", false);
					$('#btnDelete').attr("disabled", false);
					$('#btnSearch').attr("disabled", false);
				}
			});	
		}
	}
	
	//do modify
	if (action == 'modify') {
		var opr_num_ori = $('#mod_opr_num').val();
		var las_nme_ori = $('#mod_las_nme').val();
		var opr_num = $('#opr_num').val();
		var frs_nme = $('#frs_nme').val();
		var las_nme = $('#las_nme').val();
		var opr_role = $('#opr_role').val();
		var dep_grp = $('#dep_grp').val();
		var atv_flg = $('#atv_flg').val();
		var pwd = $('#pwd').val();

		var gotErr = 0;
		if (opr_num == "") {
			alert("Sila masukkan <?=$strCashierNo?>.");
			gotErr = 1;
			$("#opr_num").focus();
		} else if (frs_nme == "") {
			alert("Sila masukkan <?=$strCashierName?>.");
			gotErr = 1;
			$("#frs_nme").focus();
		}

		if (gotErr == 0) {
			$.post("user_modify.php", {
				opr_num_ori: opr_num_ori, 
				las_nme_ori: las_nme_ori, 
				opr_num: opr_num, 
				frs_nme: frs_nme, 
				las_nme: las_nme, 
				opr_role: opr_role, 
				dep_grp: dep_grp,
				atv_flg: atv_flg,  
				pwd: pwd 
				}, function(data) {
					if (data > 0) {
						alert('Rekod telah wujud.\nSila gunakan <?=$strUserId?> baru.');
					} else {
						$('#btnOk').attr("disabled", true);
						$('#btnCancel').attr("disabled", true);
						$('#btnAdd').attr("disabled", false);
						$('#btnModify').attr("disabled", false);
						$('#btnDelete').attr("disabled", false);
						$('#btnSearch').attr("disabled", false);
						
						$('#action').val("data");
						loadNaviButton();
						loadDisabledField();
						loaddata();
					}
				});	
		}
	}
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadNaviButton();
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click add
function doAdd () {
	$('#action').val("add");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	$('#kumpulan').focus();
	
	resetAllField();
}

//when click modify
function doModify () {
	$('#action').val("modify");
	loadNaviButton();
	loadDisabledField();

	//store current value
	$('#mod_opr_num').val($('#opr_num').val());
	$('#mod_las_nme').val($('#las_nme').val());

	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);
}

//when click delete
function doDelete () {
	if (confirm('Adakah anda pasti untuk hapuskan rekod ini?')) {
		var opr_num = $('#opr_num').val();
		$.post("user_delete.php", {
			opr_num: opr_num 
			}, function(data) {
				if (data.total > 0) {
					alert('<?=$strRecordLock?>');
				} else {
					$('#action').val("");
					$('#currentdata').val("1");
					
					loadNaviButton();
					loadDisabledField();
					resetAllField();

					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);
				}
		}, "json");
	} else {
	}
}

//when click search
function search () {
	$('#action').val("search");
	$('#currentdata').val("1");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	resetAllField();
	
	$('#kumpulan').focus();
}

//load data to page
function loaddata () {
	var currentdata = $('#currentdata').val();
	var strwhere = $('#strwhere').val();
	$.post("user_search.php?getdata=1&currentdata=" + currentdata + "&strwhere=" + strwhere, {
		}, function(data) {
			var opr_num = data.opr_num;
			var frs_nme = data.frs_nme;
			var las_nme = data.las_nme;
			var opr_role = data.opr_role;
			var createdate = data.createdate;
			var modifydate = data.modifydate;
			var operator = data.operator;
			var operatorname = data.operatorname;
			var dep_grp = data.dep_grp;
			var atv_flg = data.atv_flg;

			$('#opr_num').val(opr_num);
			$('#frs_nme').val(frs_nme);
			$('#las_nme').val(las_nme);
			$('#opr_role').val(opr_role);
			$('#createdate').val(createdate);
			$('#modifydate').val(modifydate);
			$('#modoperator').val(operator);
			$('#modoperatorname').val(operatorname);
			$('#dep_grp').val(dep_grp);
			$('#atv_flg').val(atv_flg);
		}, "json");
}

//when click next navigation
function datanavinext () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev navigation
function datanaviprev () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click next 10 navigation
function datanavinext10 () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 10;
		if (currentdata > $('#totaldata').val()) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev 10 navigation
function datanaviprev10 () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 10;
		if (currentdata < 1) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click last navigation
function datanavilast () {
	currentdata = $('#totaldata').val();
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click first navigation
function datanavifirst () {
	currentdata = 1;
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

function resetAllField () {
	//reset all field
	$('#opr_num').val("");
	$('#frs_nme').val("");
	$('#las_nme').val("");
	$('#opr_role').val("");
	$('#pwd').val("");
	$('#dep_grp').val("");
	$('#atv_flg').val("");
	
	$('#createdate').val("");
	$('#modifydate').val("");
	$('#modoperator').val("");
	$('#modoperatorname').val("");
}

function doList () {
	location.href='user_list.php';
}

</script>
<br />
<input type="hidden"
	id="action" value="">
<input type="hidden"
	id="currentdata" value="1">
<input type="hidden"
	id="totaldata" value="0">
<input type="hidden"
	id="strwhere" value="0">
<input type="hidden"
	id="mod_opr_num" value="">
<input type="hidden"
	id="mod_las_nme" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strUserMaintenance?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_all.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_navi.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset class="fieldset">
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
			<tr>
				<td width="10%" nowrap="nowrap"><?=$strUserId?></td>
				<td><input type="hidden" id="opr_num" name="opr_num"><input
					type="text" id="las_nme" name="las_nme" size="15" maxlength="12"
					style="text-transform: uppercase" class="font-std" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strUserName?></td>
				<td><input type="text" id="frs_nme" name="frs_nme" size="50"
					maxlength="100" style="text-transform: uppercase" class="font-std" />
				</td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strRole;?></td>
				<td><select id="opr_role" name="opr_role" class="font-std">
					<option value=""></option>
					<option value="s">PENYELIA</option>
					<option value="c">JURUWANG</option>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strPwd;?></td>
				<td><input type="password" id="pwd" name="pwd" size="15"
					maxlength="15" class="font-std" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strDepGrp;?></td>
				<td><select id="dep_grp" name="dep_grp" class="font-std">
					<option value=""></option>
					<?=re_getOptionDepGrp()?>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strStatus;?></td>
				<td><select id="atv_flg" name="atv_flg" class="font-std">
					<option value=""></option>
					<option value="Y">AKTIF</option>
					<option value="N">TIDAK AKTIF</option>
				</select></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
		</table>
		</fieldset>
		</td>
	</tr>
	<tr>
		<td><?php include_once 'include_createdby.php';?></td>
		<td></td>
	</tr>
</table>
<div id="divSearchKumpulan"
	title=""></div>
<div id="divSearchPrinter" title=""></div>
					<?php include_once 'footer.php';?>