<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND b.DEP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$arrResitBatal = array();
$a = 0;
$sql = "SELECT b.dep_grp,b.tty_num,DATE_FORMAT(b.dep_dte,'%d/%m/%Y') dep_dte,b.pay_typ,b.dep_num,SUM(a.rcp_amt) rcp_amt FROM 
aureline a JOIN aurebank b ON a.dep_grp=b.dep_grp AND a.tty_num=b.tty_num AND a.rcp_dte=b.rcp_dte AND a.rcp_num=b.rcp_num
WHERE 1=1 $strWhere 
GROUP BY b.dep_num
ORDER BY b.dep_num";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$dep_grp = $row ['dep_grp'];
	$tty_num = $row ['tty_num'];
	$dep_dte = $row ['dep_dte'];
	$pay_typ = $row ['pay_typ'];
	$dep_num = $row ['dep_num'];
	$rcp_amt = $row ['rcp_amt'];

	$arrResult [++$a]['dep_grp'] = $dep_grp;
	$arrResult [$a]['tty_num'] = $tty_num;
	$arrResult [$a]['dep_dte'] = $dep_dte;
	$arrResult [$a]['rcp_amt'] = $rcp_amt;
	$arrResult [$a]['pay_typ'] = $pay_typ;
	$arrResult [$a]['dep_num'] = $dep_num;
}


$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs10 = strtoupper("Laporan Slip Deposit Bank");
$strKumpulan = strtoupper($kumpulan);
$strKumpulanDesc = strtoupper(re_getDepGrpDesc($kumpulan));
$strFontSize = 9;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('L','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : SDB", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs10", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan ($strKumpulanDesc)", 0, 0, 'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER       : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI   : $tarikhdari", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH HINGGA : $tarikhkepada", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH     PUSAT KUTIPAN                            KAUNTER  JENIS      NO B/SLIP              JUMLAH", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"                                                             BAYARAN", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"-----------------------------------------------------------------------------------------------------", 0, 0, 'L');

foreach ($arrResult as $curResult) {
	$dep_grp = $curResult['dep_grp'];
	$strDepGrpDesc = strtoupper(re_getDepGrpDesc($dep_grp));
	$dep_dte = $curResult['dep_dte'];
	$tty_num = $curResult['tty_num'];
	$pay_typ = $curResult['pay_typ'];
	$dep_num = $curResult['dep_num'];
	$rcp_amt = $curResult['rcp_amt'];
	$totAmt += $rcp_amt;

	switch ($pay_typ) {
		case 1 :
			$caraBayaran = "TUNAI";
			break;
		case 2 :
			$caraBayaran = "CEK";
			break;
		case 3 :
			$caraBayaran = "KAD KREDIT";
			break;
		case 4 :
			$caraBayaran = "WANG POS";
			break;
		case 5 :
			$caraBayaran = "EFT";
			break;
		case 6 :
			$caraBayaran = "BANK DERAF";
			break;
		case 7 :
			$caraBayaran = "BANK SLIP";
			break;
		case 8 :
			$caraBayaran = "OSP";
			break;
	}

	$strRcpDte = $dep_dte;
	
	$depGrpPad = str_pad($dep_grp, 5, " ", STR_PAD_RIGHT);
	$strDepGrp = str_pad("$depGrpPad $strDepGrpDesc", 40, " ", STR_PAD_RIGHT);
	$strTtyNum = str_pad($tty_num, 7, " ", STR_PAD_RIGHT);
	$strCaraBayaran = str_pad($caraBayaran, 10, " ", STR_PAD_RIGHT);
	$strDepNum = str_pad($dep_num, 8, " ", STR_PAD_RIGHT);
	$strAmt = str_pad(number_format($rcp_amt,2), 20, " ", STR_PAD_LEFT);

	$pdf->Ln();
	$pdf->Cell(0,3,"$strRcpDte $strDepGrp $strTtyNum  $strCaraBayaran $strDepNum $strAmt", 0, 0, 'L');
}

$strTotAmt = str_pad(number_format($totAmt,2), 20, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,4,"JUMLAH                                                                           $strTotAmt", 0, 0, 'L');

$pdf->Output("SDB_$today_pdf.pdf","D");
?>
