<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$pdf = new FPDF('L','mm','A4');
$pdf->AddPage();
$pdf->SetFont('Courier','',8);

$operator = $_GET ['operator'];
$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$datetype = $_GET ['datetype'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$operator_name = re_getfullname($operator);

$strWhere = ($operator) ? " AND OPR_NUM='$operator'" : "";
$strWhere .= ($kumpulan) ? " AND DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND TTY_NUM='$terminal'" : "";

if ($datetype == "resit") {
	$strWhere .= " AND VOD_STU='O'";
} else {
	$strWhere .= " AND VOD_STU='V'";
}

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$arrResitBatal = array();
$counter = 0;
$sql = "SELECT RCP_NUM,RCP_DTE,VOD_STU,VOD_RCP FROM AURERECP WHERE 1=1 $strWhere
GROUP BY DEP_GRP,TTY_NUM,OPR_NUM,RCP_NUM,RCP_DTE 
ORDER BY RCP_DTE, RCP_NUM";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	if ($row ['VOD_STU'] == "V") {
		$rcp_num = str_pad($row ['VOD_RCP'], 8, '0', STR_PAD_LEFT);
	} else {
		$rcp_num = str_pad($row ['RCP_NUM'], 8, '0', STR_PAD_LEFT);
	}
	$rcp_dte = $row ['RCP_DTE'];
	$arrResitBatal [$rcp_dte][$counter++] = $rcp_num;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

//each tarikh different page
$counterPg = 0;
foreach ($arrResitBatal as $k => $curTarikh) {
	$rcp_dte = $k;
	$arrRcpDte = explode ( "-", $rcp_dte ); //ori Y-m-d
	$rcp_dte = $arrRcpDte[2] . "/" . $arrRcpDte[1] . "/" . $arrRcpDte[0];  //convert to d/m/Y
	$pg = $counterPg + 1;

	//page break for next tarikh
	if ($counterPg != 0) {
		$pdf->AddPage();
		$pdf->SetFont('Courier','',8);
	}

	//header foreach rcp_dte
	$pdf->Ln();
	$pdf->Cell(5,5,"SENARAI RESIT DIBATAL                                     CETAK PADA : $today   $time                                             Muka Surat : $pg");
	$pdf->Ln();
	$pdf->Cell(5,5,"JURUWANG : $operator_name    $operator");
	$pdf->Ln();
	$pdf->Cell(5,5,"TARIKH KUTIPAN DARI : $tarikhdari HINGGA : $tarikhkepada");
	$pdf->Ln();
	$pdf->Cell(5,5,"");
	$pdf->Ln();
	$pdf->Cell(5,2,"KOD    NO.AKAUN        NO.BDERAF/      PUSAT    NO.      NO.DOC   NO.RESIT  TARIKH     TARIKH             AMAUN  BYRN  SEBAB BATAL");
	$pdf->Ln();
	$pdf->Cell(5,2,"HASIL                  CEK/WPOS        KUTIPAN  KAUNTER  BATAL    DIBATAL   RESIT      BATAL");
	$pdf->Ln();
	$pdf->Cell(5,4,"-------------------------------------------------------------------------------------------------------------------------------------------------------------------");

	$tot_rcp_amt = $tot_rcp = 0;
	foreach ($curTarikh as $k => $curCounter) {
		$counter = $k;
		$rcp_num = $curCounter;
		$rcp_num_pad = str_pad ( $rcp_num, 6, "0", STR_PAD_LEFT );

		//get receipt details
		$sql = "SELECT DATE_FORMAT(RCP_DTE,'%d/%m/%Y') RCP_DTE, RCP_TYP, DEP_GRP, TTY_NUM, SUM(RCP_AMT) + SUM(TAX_AMT) RCP_AMT, MDU_ACC FROM AURELINE
		WHERE RCP_NUM='$rcp_num' AND DEP_GRP='$kumpulan' AND TTY_NUM='$terminal'
		GROUP BY RCP_NUM,DEP_GRP,TTY_NUM,RCP_DTE,MOD_OPR";
		$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
		while ( $row = db_fetch_array ( $s ) ) {
			$rcp_typ = str_pad ( $row ['RCP_TYP'], 5, "0", STR_PAD_LEFT );
			$rcp_dte = $row ['RCP_DTE'];
			$dep_grp = $row ['DEP_GRP'];
			$tty_num = $row ['TTY_NUM'];
			$mdu_acc = $row ['MDU_ACC'];
			$rcp_amt = $row ['RCP_AMT'];
			$tot_rcp_amt += $row ['RCP_AMT'];
		}

		//get void receipt details
		$sql = "SELECT RCP_NUM, RCP_NM2 FROM AURERECP WHERE DEP_GRP='$kumpulan' AND TTY_NUM='$terminal' AND VOD_RCP='$rcp_num'";
		$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
		while ( $row = db_fetch_array ( $s ) ) {
			$rcp_num_void = $row ['RCP_NUM'];
			$rcp_num_void_pad = str_pad ( $rcp_num_void, 6, "0", STR_PAD_LEFT );
			$rcp_nm2 = $row ['RCP_NM2'];
		}

		$sql = "SELECT DATE_FORMAT(CRE_DTE_TME,'%d/%m/%Y') CANCEL_DATE FROM AURELINE WHERE DEP_GRP='$kumpulan' AND TTY_NUM='$terminal' AND RCP_NUM='$rcp_num_void'";
		$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
		while ( $row = db_fetch_array ( $s ) ) {
			$cancel_date = $row ['CANCEL_DATE'];
		}

		//get bayaran
		$sql = "SELECT PAY_TYP,PAY_REF FROM AUREPYMT WHERE DEP_GRP='$kumpulan' AND TTY_NUM='$terminal' AND RCP_NUM='$rcp_num'";
		$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
		while ( $row = db_fetch_array ( $s ) ) {
			$pay_typ = $row ['PAY_TYP'];
			$pay_ref = $row ['PAY_REF'];

			//1=Tunai, 2=Cek, 3=Kad Kredit, 4=Wang Pos, 5=EFT, 6=Deraf Bank, 7=Slip Bank
			switch ($pay_typ) {
				case 1 :
					$jenis = "TU";
					break;
				case 2 :
					$jenis = "CQ";
					break;
				case 3 :
					$jenis = "KK";
					break;
				case 4 :
					$jenis = "WP";
					break;
				case 5 :
					$jenis = "EFT";
					break;
				case 6 :
					$jenis = "BD";
					break;
				case 7 :
					$jenis = "BS";
					break;
				case 8 :
					$jenis = "OSP";
					break;
				default :
					$jenis = "TU";
			}
		}

		$strMduAcc = str_pad($mdu_acc, 15, " ", STR_PAD_RIGHT);
		$strPayRef = str_pad($pay_ref, 15, " ", STR_PAD_RIGHT);
		$strDepGrp = str_pad($dep_grp, 8, " ", STR_PAD_RIGHT);
		$strTtyNum = str_pad($tty_num, 8, " ", STR_PAD_RIGHT);
		$strRcpAmt = str_pad(number_format($rcp_amt,2), 12, " ", STR_PAD_LEFT);
		$strJenis = str_pad($jenis, 3, " ", STR_PAD_RIGHT);
		$strSebab = substr($rcp_nm2, 0, 43);

		//now print each rcp_num foreach receipt
		$pdf->Ln();
		$pdf->Cell(5,4,"$rcp_typ  $strMduAcc $strPayRef $strDepGrp $strTtyNum $rcp_num_void_pad $rcp_num_pad  $rcp_dte $cancel_date  $strRcpAmt  $strJenis   $strSebab");

		$tot_rcp += 1;
		$grand_tot_rcp_amt += $rcp_amt;
		$grand_tot_rcp += 1;
	}

	$pdf->Ln();
	$pdf->Cell(5,4,"");
	$pdf->Ln();
	$pdf->Cell(5,4,"JUMLAH ($rcp_dte)      " . number_format($tot_rcp_amt,2));
	$pdf->Ln();
	$pdf->Cell(5,4,"BILG. REKOD              $tot_rcp");
	$pdf->Ln();
	$pdf->Cell(5,4,"-------------------------------------------------------------------------------------------------------------------------------------------------------------------");

	$counterPg += 1;
}

$pdf->Ln();
$pdf->Cell(5,4,"");
$pdf->Ln();
$pdf->Cell(5,4,"JUMLAH BESAR             " . number_format($grand_tot_rcp_amt,2));
$pdf->Ln();
$pdf->Cell(5,4,"BILG. REKOD              $grand_tot_rcp");
$pdf->Ln();
$pdf->Cell(5,4,"                                                                    ----- LAPORAN TAMAT -----");

$pdf->Output("senarai_resitbatal_$today_pdf.pdf","D");
?>
