<?php

include_once 'header.php';
include_once 'lib/db.php';
require_once 'class/Aualrefs.php';

$opr_num = $_SESSION ['userid'];
$session_depgrp = $_SESSION ['kumpulan'];
$session_ttynum = $_SESSION ['terminal'];
$today = date('d/m/Y');

$sql = "SELECT OPR_NUM,DEP_GRP,TTY_NUM,SUM(RCP_AMT) RCP_AMT,DATE_FORMAT(RCP_DTE, '%d/%m/%Y') AS RCP_DTE FROM AURERECP WHERE BAL_FLG != 'Y' AND DEP_GRP LIKE '%OSP%' GROUP BY TTY_NUM, RCP_DTE ORDER BY RCP_DTE LIMIT 1";  //now we can close previous day bil
$s = db_query ( $sql );
while ( $row = db_fetch_array ( $s ) ) {
	$opr_num = $row ['OPR_NUM'];
	$dep_grp = $row ['DEP_GRP'];
	$tty_num = $row ['TTY_NUM'];
	$rcp_dte = $row ['RCP_DTE'];
	$balance = $row ['RCP_AMT'];
}

$name = re_getfullname ($opr_num);

$objAUALREFS = new Aualrefs();
$objAUALREFS->reftyp = 'dep_grp';
$objAUALREFS->refval = $dep_grp;
$objAUALREFS->select();
$kumpulan_desc = $objAUALREFS->dscno1;

$sql3 = "SELECT DEP_GRP,OPR_NUM,TTY_NUM,DATE_FORMAT(RCP_DTE, '%d/%m/%Y') AS RCP_DTE FROM AURERECP WHERE BAL_FLG != 'Y' AND DEP_GRP LIKE '%OSP%' GROUP BY TTY_NUM, RCP_DTE ORDER BY RCP_DTE";
$s3 = db_query ( $sql3 );

?>
<title><?=$sys_name?> - <?=$strCloseCounter?></title>
<script>

if ('<?=$diff?>' == '1') {
	alert('Sila lengkapkan proses Slip Deposit Bank terlebih dahulu.');
	window.location.href = 'index.php';
}

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	loadDisabledField();
});

//make enter key behave like tab key
$( document ).on('keydown','input', function(e) { 
	if (e.keyCode == 13 || e.keyCode == 9) {
		e.preventDefault();
		var id = this.id;
		if ( id == "kumpulan" ) {
			$("#operator").select();
		} else if ( id == "operator" ) {
			$("#terminal").focus();
		} else if ( id == "terminal" ) {
			$("#balance").select();
		} else if ( id == "balance" ) {
			$("#printer").select();
		} else if ( id == "printer" ) {
			$("#kumpulan").select();
		}
	}
});

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search only
	if (action == 'search') {
		$('#kumpulan').attr("readonly", false);
		$('#kumpulan_desc').attr("readonly", true);
		$('#btnSearchKumpulan').attr("readonly", false);
		$('#operator').attr("readonly", false);
		$('#btnSearchOperator').attr("readonly", false);
		$('#terminal').attr("readonly", false);
		$('#date').attr("readonly", false);
		$('#balance').attr("readonly", false);
	} else {
		$('#kumpulan').attr("readonly", true);
		$('#kumpulan_desc').attr("readonly", true);
		$('#btnSearchKumpulan').attr("readonly", true);
		$('#operator').attr("readonly", true);
		$('#btnSearchOperator').attr("readonly", true);
		$('#terminal').attr("readonly", true);
		$('#date').attr("readonly", true);
		$('#balance').attr("readonly", true);
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'search') {
		var kumpulan = $('#kumpulan').val();
		var operator = $('#operator').val();
		var terminal = $('#terminal').val();
		var date = $('#date').val();
		var printer = $('#printer').val();

		$.post("tutupkaunter_search.php", {
			kumpulan: kumpulan, 
			operator: operator,
			terminal: terminal, 
			date: date 
			}, function(data) {
				if (data.total > 0) {
					//load data
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("data");
					loadDisabledField();

					$.post("tutupkaunter_slipdepositbank.php", {
						kumpulan: kumpulan, 
						operator: operator,
						terminal: terminal, 
						date: date 
						}, function(data) {
							if (data.total == 0) {
								if (confirm("Adakah anda pasti untuk Tamat Proses OSP?")) {
									//print resit tamat hari to printer
									$('#divLoading').show();
									$.post("osp_close1.php", {
										kumpulan: kumpulan, 
										operator: operator,
										terminal: terminal, 
										date: date, 
										printer: printer 
										}, function(data) {
											$('#divLoading').hide();
											alert('Tamat Proses OSP selesai.');
											window.location.href = 'osp_close.php';
										});
									//print resit tamat hari as pdf
									//window.location.href = 'tutupkaunter_print.php?kumpulan='+kumpulan+'&terminal='+terminal+'&operator='+operator;
								}
							} else {
								sdb = data.sdb;
								alert('Sila lengkapkan proses Slip Deposit Bank terlebih dahulu.' + sdb);
							}
						}, "json");
				} else {

					alert('Tiada rekod untuk diproses.');
					
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("");
					loadDisabledField();
				}
		}, "json");
	}
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click search
function search () {
	$('#action').val("search");
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnSearch').attr("disabled", true);

	resetAllField();

	//default value
	$('#kumpulan').val('<?=$dep_grp;?>');
	$('#kumpulan_desc').val('<?=$kumpulan_desc;?>');
	$('#operator').val('<?=$opr_num;?>');
	$('#operator_name').val('<?=$name;?>');
	$('#terminal').val('<?=$tty_num;?>');
	$('#date').val('<?=$rcp_dte;?>');
	$('#balance').val('<?=number_format($balance,2);?>');
	
	$('#kumpulan').focus();
}

function resetAllField () {
	//reset all field
	$('#kumpulan').val("");
	$('#kumpulan_desc').val("");
	$('#operator').val("");
	$('#operator_name').val("");
	$('#terminal').val("");
	$('#date').val("");
	$('#balance').val("");
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulan.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: 'Pusat Kutipan', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchOperator () {
	try {

		var url = 'lookup_operator.php';
		
		$("#divSearchOperator").load(url);
		$("#divSearchOperator").dialog({ width: 400, height: 400, modal: true, title: 'Juruwang', 
			buttons: {
					'Pilih': function() {
						addSearchOperator();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchPrinter () {
	try {

		var url = 'lookup_printer.php';
		
		$("#divSearchPrinter").load(url);
		$("#divSearchPrinter").dialog({ width: 400, height: 400, modal: true, title: 'Printer', 
			buttons: {
					'Pilih': function() {
						addSearchPrinter();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		var kumpulan = $("#kumpulan").val();
		$.post("refresh_kumpulan.php", {
			kumpulan: kumpulan 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh printer
function refreshPrinter () {
	try {
		$.post("refresh_printer.php", {
			printer: $("#printer").val() 
			}, function(data) {
				$("#printer_desc").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}
</script>
<br>
<input type="hidden" id="action" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strOSPClosing?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_process.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset><legend>Kriteria</legend>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td nowrap="nowrap"><?=$strDepGrp?></td>
				<td><input type="text" id="kumpulan" name="kumpulan" size="10"
					onblur="refreshKumpulan();" style="text-transform: uppercase" /><img
					id="btnSearchKumpulan" src="image/search.gif"
					onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kumpulan_desc" name="kumpulan_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strCashierNo?></td>
				<td><input type="text" id="operator" name="operator" size="10" /><img
					id="btnSearchOperator" src="image/search.gif"
					onclick="loadSearchOperator();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="operator_name" name="operator_name" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strTerminalNo?></td>
				<td><input id="terminal" name="terminal" value="99" size="5"></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiptDate?></td>
				<td><input type="text" id="date" name="date" size="10" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strCashierBalance?></td>
				<td><input type="text" id="balance" name="balance" size="15"
					readonly="readonly" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
			<tr>
				<td colspan="2">
				<div id="divLoading" title="" style="display: none;"><img
					src="image/loading.gif"> Sila tunggu sebentar..</div>
				</td>
			</tr>
			<tr style="display: none;">
				<td nowrap="nowrap"><?=$strAuditRoll?></td>
				<td><input type="text" id="printer" name="printer" size="10"
					onblur="refreshPrinter()" /><img src="image/search.gif"
					onclick="loadSearchPrinter();"
					onmouseover="this.style.cursor='pointer';"> <input type="text"
					id="printer_desc" name="printer_desc" size="30" /></td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
	<tr>
		<td>
		<fieldset><legend>Senarai Kaunter Yang Belum Ditutup</legend>
		<table width="50%" border="0" cellpadding="2" cellspacing="1"
			class="font-std">
			<tr class="table-header" align="center">
				<td width="1%">Bil.</td>
				<td width="20%" nowrap="nowrap">Pusat Kutipan</td>
				<td width="20%">Kaunter</td>
				<td width="20%">Juruwang</td>
				<td width="20%">Tarikh</td>
			</tr>
			<?php
			while ( $row3 = db_fetch_array ( $s3 ) ) {
				$dep_grp = $row3 ['DEP_GRP'];
				$opr_num = $row3 ['OPR_NUM'];
				$tty_num = $row3 ['TTY_NUM'];
				$rcp_dte = $row3 ['RCP_DTE'];

				?>
			<tr align="center">
				<td><?=++$counter;?>.</td>
				<td><?=$dep_grp?></td>
				<td><?=$tty_num?></td>
				<td><?=re_getLastName($opr_num)?></td>
				<td><?=$rcp_dte?></td>
			</tr>
			<?php } ?>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
</table>
<br>

<div id="divSearchKumpulan" title=""></div>
<div id="divSearchOperator" title=""></div>
<div id="divSearchPrinter" title=""></div>
			<?php include_once 'footer.php';?>