<?php

include_once 'header.php';
include_once 'lib/db.php';
require_once 'class/Aualrefs.php';

//get all unclosed receipt
$sql3 = "SELECT a.DEP_GRP,a.OPR_NUM,a.TTY_NUM,DATE_FORMAT(a.RCP_DTE, '%d/%m/%Y') AS RCP_DTE,DATE_FORMAT(b.RUN_DTE_TME, '%d/%m/%Y') AS RUN_DTE_TME,SUM(a.RCP_AMT) RCP_AMT
FROM AURERECP a LEFT JOIN AUREBANK B ON a.DEP_GRP=b.DEP_GRP AND a.TTY_NUM=b.TTY_NUM AND a.RCP_DTE=b.RCP_DTE AND a.RCP_NUM=b.RCP_NUM
WHERE a.BAL_FLG != 'Y' AND a.DEP_GRP LIKE '%OSP%' 
GROUP BY a.DEP_GRP,a.TTY_NUM,DATE(b.RUN_DTE_TME),a.OPR_NUM 
ORDER BY b.RUN_DTE_TME,a.DEP_GRP,a.TTY_NUM";
$s3 = db_query ( $sql3 );

?>
<title><?=$sys_name?> - <?=$strOSPClosing?></title>
<script
	type="text/javascript" src="scripts/datatables.min.js"></script>
<link rel="stylesheet"
	type="text/css" media="screen" href="scripts/datatables.min.css" />
<script>

$(document).ready(function() {
    var table = $('#myTable').DataTable( {
        filter: false,
        pageLength: 500,
        info: false,
        sort: false,
        dom: 'Bfrtip',        
        
    } );
});

function doProcess (depgrp,ttynum,rcpdte,oprnum) {
	if(confirm("Adakah anda pasti untuk Tamat Proses OSP ini?")) {
		$('#divLoading').show();
		$.post("osp_close1.php", {
			kumpulan: depgrp, 
			operator: oprnum,
			terminal: ttynum, 
			date: rcpdte 
			}, function(data) {
				$('#divLoading').hide();
				alert('Proses Tamat Proses OSP selesai.');
				window.location.href = 'osp_close.php';
			});
	}
}

</script>
<br>
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strOSPClosing?></td>
	</tr>
	<tr>
		<td>
		<table id="myTable" class="display font-small">
			<thead>
			<tr align="center">
				<th width="1%">Bil.</th>
				<th width="1%">Tarikh Kutipan</th>
				<th width="1%">Tarikh Proses</th>
				<th width="1%">Kod Pusat Kutipan</th>
				<th width="20%">Pusat Kutipan</th>
				<th width="1%">Nombor Kaunter</th>
				<th width="1%">Kod Juruwang</th>
				<th width="20%">Juruwang</th>
				<th width="10%">Jumlah Kutipan (RM)</th>
				<th width="1%"></th>
			</tr>
			</thead>
			<?php
			while ( $row3 = db_fetch_array ( $s3 ) ) {
				$dep_grp = $row3 ['DEP_GRP'];
				$opr_num = $row3 ['OPR_NUM'];
				$tty_num = $row3 ['TTY_NUM'];
				$rcp_dte = $row3 ['RCP_DTE'];
				$run_dte_tme = $row3 ['RUN_DTE_TME'];
				$rcp_amt = $row3 ['RCP_AMT'];

				$objAUALREFS = new Aualrefs();
				$objAUALREFS->reftyp = 'dep_grp';
				$objAUALREFS->refval = $dep_grp;
				$objAUALREFS->select();
				$kumpulan_desc = $objAUALREFS->dscno1;

				?>
			<tr>
				<td align="center"><?=++$counter;?>.</td>
				<td align="center"><?=$rcp_dte?></td>
				<td align="center"><?=$run_dte_tme?></td>
				<td align="center"><b><?=$dep_grp?></b></td>
				<td><?=$kumpulan_desc?></td>
				<td align="center"><b><?=$tty_num?></b></td>
				<td align="center"><?=$opr_num?></td>
				<td><?=re_getLastName($opr_num)?></td>
				<td align="right"><?=number_format($rcp_amt,2)?></td>
				<td align="center"><input type="button" value="Proses"
					class="font-std"
					onclick="doProcess('<?=$dep_grp?>','<?=$tty_num?>','<?=$run_dte_tme?>','<?=$opr_num?>')"></td>
			</tr>
			<?php } ?>
		</table>
		</td>
	</tr>
	<tr>
		<td align="center">
		<div id="divLoading" style="display: none;"><img
			src="image/loading.gif"> Sila tunggu sebentar..</div>
		</td>
	</tr>
</table>
<br>
			<?php include_once 'footer.php';?>