<?php

include_once 'header.php';

?>
<title><?=$sys_name?> - <?=$strIntegrationSas?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	loadDisabledField();
	$( "#progressbar" ).progressbar({ value: 0 });
});

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search only
	if (action == 'search') {
		$('#tarikh').attr("readonly", false);
		$("#tarikh").datepicker({dateFormat:'dd/mm/yy'});
	} else {
		$('#tarikh').attr("readonly", true);
		$("#tarikh").datepicker('destroy');
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	if (confirm("Adakah anda pasti?")) {
		//do search
		if (action == 'search') {
			var tarikh = $('#tarikh').val();

			$.post("manual_sas_import1.php", {
				tarikh: tarikh
				}, function(data) {
					var total = data.total;
					var totali = data.totali;
					var totAureopit = data.totAureopit;
					var totAurealloc = data.totAurealloc;
					$('#aureopit').html(totAureopit);
					$('#aurealloc').html(totAurealloc);
			}, "json");
		}
	}
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click search
function search () {
	$('#action').val("search");
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnSearch').attr("disabled", true);

	$('#tarikh').val("<?=date('d/m/Y')?>");
}

function resetAllField () {
	$('#tarikh').val("");
}

</script>
<br>
<input type="hidden" id="action" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strIntegrationSas?></td>
		<td></td>
	</tr>
	<tr>
		<td class="font-std">Import open item dari Sistem SAS.</td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_process.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td nowrap="nowrap" width="10%">Tarikh Kutipan</td>
				<td><input type="text" id="tarikh" name="tarikh" size="10" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
	<tr>
		<td>
		<fieldset><legend><?=$strProgress?></legend>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			class="font-std">
			<tr>
				<td width="30%">AUREOPIT</td>
				<td>
				<div id="aureopit"></div>
				</td>
			</tr>
			<tr>
				<td width="30%">AUREALLOC</td>
				<td>
				<div id="aurealloc"></div>
				</td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
</table>
<?php include_once 'footer.php';?>