<?php

require_once $INC_DIR.'class/Aualrefs.php';
require_once $INC_DIR.'class/Aumnoper.php';

define("CONFIG_ROLE_SUPERVISOR", "s");
define("CONFIG_ROLE_CASHIER", "c");

define("CONFIG_BANKSLIP", "BANKSLIP");
define("CONFIG_ONLINE", "ONLINE");
define("CONFIG_CANCEL", "CANCEL");
define("CONFIG_OSP", "OSP");
define("CONFIG_DEPNUM", "DEP_NUM");

define("CONFIG_BANKSLIP_SINGLE", "1");
define("CONFIG_BANKSLIP_MULTIPLE", "2");
define("CONFIG_DEPNUM_MANUAL", "1");
define("CONFIG_DEPNUM_AUTO", "2");
define("CONFIG_DEPNUM_RCPNUM", "3");
define("CONFIG_ONLINE_YES", "1");
define("CONFIG_ONLINE_NO", "0");
define("CONFIG_CANCEL_ENABLE", "1");
define("CONFIG_CANCEL_DISABLE", "0");
define("CONFIG_OSP_REJECT", "1");
define("CONFIG_OSP_MODIFY", "2");

define("PAYTYP_DESC1", getPaymentTypeDesc('1'));
define("PAYTYP_DESC2", getPaymentTypeDesc('2'));
define("PAYTYP_DESC3", getPaymentTypeDesc('3'));
define("PAYTYP_DESC4", getPaymentTypeDesc('4'));
define("PAYTYP_DESC5", getPaymentTypeDesc('5'));
define("PAYTYP_DESC6", getPaymentTypeDesc('6'));
define("PAYTYP_DESC7", getPaymentTypeDesc('7'));
define("PAYTYP_DESC8", getPaymentTypeDesc('8'));

define("PAYTYP_SHORTDESC1", getPaymentTypeShortDesc('1'));
define("PAYTYP_SHORTDESC2", getPaymentTypeShortDesc('2'));
define("PAYTYP_SHORTDESC3", getPaymentTypeShortDesc('3'));
define("PAYTYP_SHORTDESC4", getPaymentTypeShortDesc('4'));
define("PAYTYP_SHORTDESC5", getPaymentTypeShortDesc('5'));
define("PAYTYP_SHORTDESC6", getPaymentTypeShortDesc('6'));
define("PAYTYP_SHORTDESC7", getPaymentTypeShortDesc('7'));
define("PAYTYP_SHORTDESC8", getPaymentTypeShortDesc('8'));

function config ($type) {
	$sqlN = "SELECT SYS_VAL FROM SYSTEM WHERE SYS_TYP='$type'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return trim($rowN ['SYS_VAL']);
	}
}

function re_getfullname ($operator) {
	$sqlN = "SELECT FRS_NME, LAS_NME FROM AUMNOPER WHERE OPR_NUM='$operator'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $operator_name = trim($rowN ['FRS_NME']);
	}
}

function re_getLastName ($operator) {
	$objAUMNOPER = new Aumnoper();
	$objAUMNOPER->oprnum = $operator;
	$objAUMNOPER->select();
	return trim($objAUMNOPER->lasnme);
}

function re_getrcpgrp ($a) {
	$sqlN = "SELECT DSC_NO1 FROM AUALREFS WHERE REF_TYP='rcp_grp' AND REF_VAL='$a'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['DSC_NO1'];
	}
}

function re_getDepGrpDesc ($a) {
	$objAUALREFS = new Aualrefs();
	$objAUALREFS->reftyp = 'dep_grp';
	$objAUALREFS->refval = $a;
	$objAUALREFS->select();
	return $objAUALREFS->dscno1;
}

function re_getOptionDepGrp ($a = null) {
	$sqlN = "SELECT REF_VAL,DSC_NO1 FROM AUALREFS WHERE REF_TYP='dep_grp' ORDER BY DSC_NO1";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		$id = $rowN ['REF_VAL'];
		$name = $rowN ['DSC_NO1'];
		$strSelected = ($a == $id)? "selected":"";
		$strOptions .= "<option value=\"$id\" $strSelected>$name</option>\n";
	}
	return $strOptions;
}

function re_getLastKutipanDate ($dep_grp,$tty_num){
	$sqlN = "SELECT DATE_FORMAT(RCP_DTE, '%d-%m-%Y') AS RCP_DTE FROM AURELINE WHERE DEP_GRP='$dep_grp' AND TTY_NUM='$tty_num' AND DATEDIFF(RCP_DTE,NOW())<0 GROUP BY RCP_DTE ORDER BY RCP_DTE DESC LIMIT 1";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['RCP_DTE'];
	}
}

function re_getLastKutipanReceipt ($dep_grp,$tty_num){
	$sqlN = "SELECT RCP_NUM FROM AURELINE WHERE DEP_GRP='$dep_grp' AND TTY_NUM='$tty_num' AND DATEDIFF(RCP_DTE,NOW())<0 ORDER BY RCP_DTE DESC LIMIT 1";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['RCP_NUM'];
	}
}

function re_getLastKutipanAmt ($dep_grp,$tty_num){
	$sqlN = "SELECT SUM(RCP_AMT) AS RCP_AMT FROM AURELINE WHERE DEP_GRP='$dep_grp' AND TTY_NUM='$tty_num' AND DATEDIFF(RCP_DTE,NOW())<0 GROUP BY RCP_DTE ORDER BY RCP_DTE DESC LIMIT 1";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['RCP_AMT'];
	}
}

function re_getLastKutipanOperator ($dep_grp,$tty_num){
	$sqlN = "SELECT MOD_OPR FROM AURELINE WHERE DEP_GRP='$dep_grp' AND TTY_NUM='$tty_num' ORDER BY RCP_DTE DESC LIMIT 1";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['MOD_OPR'] . " " . re_getfullname ($rowN ['MOD_OPR']);
	}
}

function re_getLastBankSlip ($dep_grp){
	global $online;

	$year = date('Y');
	//$sqlN = "SELECT MAX(DEP_NUM) DEP_NUM FROM AUREBANK WHERE DEP_GRP='$dep_grp' AND YEAR(DEP_DTE)=$year ORDER BY DEP_NUM DESC LIMIT 1";
	$sqlN = "SELECT DEP_NUM FROM AUREBANK WHERE DEP_GRP='$dep_grp' AND YEAR(DEP_DTE)=$year ORDER BY LENGTH(DEP_NUM) DESC, DEP_NUM DESC LIMIT 1";
	$sN = ($online == "1") ? db_query_server($sqlN) : db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		$num = $rowN ['DEP_NUM'];
	}
	
	if (strlen($num) == '8') {
		$newnum = substr($num, -4,4) + 1;
	} else if (strlen($num) == '9') {
		$newnum = substr($num, -5,5) + 1;
	}
	//return $num = substr($num, -4,4) + 1;
	return $newnum;
}

function re_getLastBankSlipOSP ($imp_typ,$month){
	$num = 0;
	$sqlN = "SELECT MAX(DEP_NUM) DEP_NUM FROM AUREBANK WHERE DEP_GRP LIKE '%OSP%' AND DEP_NUM LIKE '$imp_typ$month%' LIMIT 1";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		$num = substr($rowN ['DEP_NUM'],-4,4);
	}
	return $num = str_pad($num + 1,4,'0',STR_PAD_LEFT);
}

function re_getpaytype ($a) {
	$sqlN = "SELECT PAY_DES,FMS_TYP FROM AUALPTYP WHERE PAY_TYP='$a'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['PAY_DES'];
	}
}

function re_getFmsTyp ($a) {
	$sqlN = "SELECT FMS_TYP FROM AUALPTYP WHERE PAY_TYP='$a'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['FMS_TYP'];
	}
}

function re_getFmsBankCode ($a) {
	$sqlN = "SELECT BNK_AD1 FROM AUALBSBN WHERE BNK_BSB='$a'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['BNK_AD1'];
	}
}

function re_validateexport(){
	$start_export = false;
	$end_export = true;

	$sqlN = "SELECT
DATE_FORMAT(LAST_EXPORT_AURERECP, '%d/%m/%Y %H:%i:%s') AS LAST_EXPORT_AURERECP, DATEDIFF(LAST_EXPORT_AURERECP,NOW()) AS DATEDIFF_AURERECP,
DATE_FORMAT(LAST_EXPORT_AURELINE, '%d/%m/%Y %H:%i:%s') AS LAST_EXPORT_AURELINE, DATEDIFF(LAST_EXPORT_AURELINE,NOW()) AS DATEDIFF_AURELINE, 
DATE_FORMAT(LAST_EXPORT_AUREPYMT, '%d/%m/%Y %H:%i:%s') AS LAST_EXPORT_AUREPYMT, DATEDIFF(LAST_EXPORT_AUREPYMT,NOW()) AS DATEDIFF_AUREPYMT  
FROM INTEGRATION";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		if($rowN ['DATEDIFF_AURERECP'] == "0" || $rowN ['DATEDIFF_AURELINE'] == "0" || $rowN ['DATEDIFF_AUREPYMT'] == "0"){
			$start_export = true;
			$end_export = true;
		}
		if($rowN ['DATEDIFF_AURERECP'] != "0" || $rowN ['DATEDIFF_AURELINE'] != "0" || $rowN ['DATEDIFF_AUREPYMT'] != "0"){
			$end_export = false;
		}
	}

	if ($start_export == true && $end_export == false) {
		return false;
	} else {
		return true;
	}

}

function re_amttostr ($a){
	$strRM = number_format($a,2,'.','');

	$arrRM = explode(".", $strRM);
	$ringgit = $arrRM[0];
	$sen = $arrRM[1];

	$strSen1 = substr($sen, 0, 1);
	$strSen2 = substr($sen, 1, 1);

	$sa = (strlen($ringgit) >= 1) ? substr($ringgit, -1, 1) : 0;
	$puluh = (strlen($ringgit) >= 2) ? substr($ringgit, -2, 1) : 0;
	$ratus = (strlen($ringgit) >= 3) ? substr($ringgit, -3, 1) : 0;
	$ribu = (strlen($ringgit) >= 4) ? substr($ringgit, -4, 1) : 0;
	$pribu = (strlen($ringgit) >= 5) ? substr($ringgit, -5, 1) : 0;
	$rribu = (strlen($ringgit) >= 6) ? substr($ringgit, -6, 1) : 0;
	$juta = (strlen($ringgit) >= 7) ? substr($ringgit, -7, 1) : 0;
	$pjuta = (strlen($ringgit) >= 8) ? substr($ringgit, -8, 1) : 0;
	$rjuta = (strlen($ringgit) >= 9) ? substr($ringgit, -9, 1) : 0;
	$bilion = (strlen($ringgit) >= 10) ? substr($ringgit, -10, 1) : 0;
	$pbilion = (strlen($ringgit) >= 11) ? substr($ringgit, -11, 1) : 0;
	$rbilion = (strlen($ringgit) >= 12) ? substr($ringgit, -12, 1) : 0;

	//ringgit
	if ($ringgit > 0) {

		if ( $rbilion > 0) {
			$strRinggit .= convertNoToStr($rbilion) . " RATUS";
		}

		if ( $pbilion > 0) {
			if ( $pbilion == 1) {
				if ( $bilion == 0) {
					$strRinggit .= " SEPULUH";
				} else if ( $bilion == 1) {
					$strRinggit .= " SEBELAS";
				} else {
					$strRinggit .= convertNoToStr($bilion) . " BELAS";
				}
			} else {
				if ( $bilion > 0) {
					$strRinggit .=  convertNoToStr($pbilion) . " PULUH" . convertNoToStr($bilion);
				} else {
					$strRinggit .=  convertNoToStr($pbilion) . " PULUH";
				}
			}
		} else if ($pbilion == 0) {
			if ( $bilion > 0) {
				$strRinggit .= convertNoToStr($bilion);
			}
		}

		if ($rbilion || $pbilion || $bilion) {
			$strRinggit .= " BILION";
		}

		if ( $rjuta > 0) {
			$strRinggit .= convertNoToStr($rjuta) . " RATUS";
		}

		if ( $pjuta > 0) {
			if ( $pjuta == 1) {
				if ( $juta == 0) {
					$strRinggit .= " SEPULUH";
				} else if ( $juta == 1) {
					$strRinggit .= " SEBELAS";
				} else {
					$strRinggit .= convertNoToStr($juta) . " BELAS";
				}
			} else {
				if ( $juta > 0) {
					$strRinggit .=  convertNoToStr($pjuta) . " PULUH" . convertNoToStr($juta);
				} else {
					$strRinggit .=  convertNoToStr($pjuta) . " PULUH";
				}
			}
		} else if ($pjuta == 0) {
			if ( $juta > 0) {
				$strRinggit .= convertNoToStr($juta);
			}
		}

		if ($rjuta || $pjuta || $juta) {
			$strRinggit .= " JUTA";
		}

		if ( $rribu > 0) {
			$strRinggit .= convertNoToStr($rribu) . " RATUS";
		}

		if ( $pribu > 0) {
			if ( $pribu == 1) {
				if ( $ribu == 0) {
					$strRinggit .= " SEPULUH";
				} else if ( $ribu == 1) {
					$strRinggit .= " SEBELAS";
				} else {
					$strRinggit .= convertNoToStr($ribu) . " BELAS";
				}
			} else {
				if ( $ribu > 0) {
					$strRinggit .=  convertNoToStr($pribu) . " PULUH" . convertNoToStr($ribu);
				} else {
					$strRinggit .=  convertNoToStr($pribu) . " PULUH";
				}
			}
		} else if ($pribu == 0) {
			if ( $ribu > 0) {
				$strRinggit .= convertNoToStr($ribu);
			}
		}

		if ($rribu || $pribu || $ribu) {
			$strRinggit .= " RIBU";
		}

		if ( $ratus > 0) {
			$strRinggit .= convertNoToStr($ratus) . " RATUS";
		}

		if ( $puluh > 1) {
			//20-99
			$strRinggit .= convertNoToStr($puluh) . " PULUH";
			if ($sa > 0) {
				$strRinggit .= convertNoToStr($sa);
			}
		} else if ($puluh == 1) {
			// 10-19
			if ($sa == 0) {
				$strRinggit .= " SEPULUH";
			} else if ($sa == 1) {
				$strRinggit .= " SEBELAS";
			} else {
				$strRinggit .= convertNoToStr($sa) . " BELAS";
			}
		} else if ( $puluh == 0) {
			// 0-9
			if ($sa > 0) {
				$strRinggit .= convertNoToStr($sa);
			}
		}
		$strRinggit .= " RINGGIT";
	}

	//sen
	if ($sen > 0) {
		$strSen .= "";
		if ($sen < 10) {
			$strSen .= convertNoToStr($strSen2);
		} else if ($sen == 10) {
			$strSen .= " SEPULUH";
		} else if ($sen == 11) {
			$strSen .= " SEBELAS";
		} else if ($sen < 20) {
			$strSen .= convertNoToStr($strSen2) . " BELAS";
		} else {
			$strSen .= convertNoToStr($strSen1) . " PULUH";
			if ($strSen2 > 0) {
				$strSen .= convertNoToStr($strSen2);
			}
		}
		$strSen .= " SEN";
	}

	return $strRinggit . $strSen . " SAHAJA";
}

function convertNoToStr ($n) {
	switch ($n) {
		case '1':
			return " SATU";
			break;
		case '2':
			return " DUA";
			break;
		case '3':
			return " TIGA";
			break;
		case '4':
			return " EMPAT";
			break;
		case '5':
			return " LIMA";
			break;
		case '6':
			return " ENAM";
			break;
		case '7':
			return " TUJUH";
			break;
		case '8':
			return " LAPAN";
			break;
		case '9':
			return " SEMBILAN";
			break;
	}
}

function getDefaultCshLmt () {
	$sqlN = "SELECT VAL_NO1 FROM AUALREFS WHERE REF_TYP='csh_lmt'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['VAL_NO1'];
	}
}

function getDefaultRcpLmt () {
	$sqlN = "SELECT VAL_NO1 FROM AUALREFS WHERE REF_TYP='rcp_lmt'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['VAL_NO1'];
	}
}

function getDesMdu ($a) {
	$sqlN = "SELECT DES_MDU FROM AURETYPE WHERE RCP_TYP='$a'";
	$sN = db_query ( $sqlN );
	while ( $rowN = db_fetch_array ( $sN ) ) {
		return $rowN ['DES_MDU'];
	}
}

function getGstId () {
	$sql = "SELECT DSC_NO1 FROM AUALREFS WHERE REF_TYP='gst_id'";
	$s = db_query ( $sql );
	while ( $row = db_fetch_array ( $s ) ) {
		$dsc_no1 = $row ['DSC_NO1'];
	}
	return $dsc_no1;
}

function getPaymentTypeDesc ($a) {
	$sql = "SELECT PAY_DES FROM AUALPTYP WHERE PAY_TYP='$a'";
	$s = db_query ( $sql );
	while ( $row = db_fetch_array ( $s ) ) {
		$dsc_no1 = $row ['PAY_DES'];
	}
	return $dsc_no1;
}

function getPaymentTypeShortDesc ($a) {
	$sql = "SELECT FMS_TYP FROM AUALPTYP WHERE PAY_TYP='$a'";
	$s = db_query ( $sql );
	while ( $row = db_fetch_array ( $s ) ) {
		$dsc_no1 = $row ['FMS_TYP'];
	}
	return $dsc_no1;
}

function getBankDesc ($a) {
	$sql = "SELECT BNK_NME FROM AUALBANK WHERE BNK_NUM='$a'";
	$s = db_query ( $sql );
	while ( $row = db_fetch_array ( $s ) ) {
		$dsc_no1 = $row ['BNK_NME'];
	}
	return $dsc_no1;
}

function getBankTypeDesc ($bnk_typ) {
	$sql = "SELECT PAY_DES FROM AUALPTYP WHERE BNK_TYP='$bnk_typ'";
	$s = db_query ( $sql );
	while ( $row = db_fetch_array ( $s ) ) {
		$desc .= $row ['PAY_DES'] . ",";
	}
	$desc = eregi_replace(",$", "", $desc);
	return $desc;
}
?>