<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];
$kodhasildari = $_GET ['kodhasildari'];
$kodhasilke = $_GET ['kodhasilke'];
$paytypedari = $_GET ['paytypedari'];
$paytypeke = $_GET ['paytypeke'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

if ($kodhasildari && $kodhasilke) {
	$strWhere .= " AND b.RCP_TYP BETWEEN '$kodhasildari' AND '$kodhasilke'";
}

if ($paytypedari && $paytypeke) {
	$strWhere .= " AND c.PAY_TYP BETWEEN '$paytypedari' AND '$paytypeke'";
}

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$a = 0;
$sql = "SELECT DATE_FORMAT( a.rcp_dte, '%d/%m/%Y' ) rcp_dte,DATE_FORMAT( c.cre_dte_tme, '%H:%i:%s' ) pay_time,e.las_nme,a.rcp_num,b.mdu_acc,b.des_ref,b.rcp_typ,a.vod_stu,c.pay_typ,d.bnk_brn,SUM(b.rcp_amt) + SUM(b.tax_amt) amt
FROM 
(aurerecp a, aureline b, aurepymt c, aumnoper e) 
LEFT JOIN aualbsbn d ON c.bnk_bsb=d.bnk_bsb
WHERE
a.rcp_num=b.rcp_num
AND a.rcp_num=c.rcp_num
AND a.opr_num=e.opr_num
AND a.dep_grp=b.dep_grp
AND a.dep_grp=c.dep_grp
AND a.tty_num=b.tty_num
AND a.tty_num=c.tty_num
AND a.rcp_dte=b.rcp_dte
AND a.rcp_dte=c.rcp_dte
$strWhere
GROUP BY a.RCP_NUM";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$rcp_dte = $row ['rcp_dte'];
	$pay_time = $row ['pay_time'];
	$las_nme = $row ['las_nme'];
	$rcp_num = $row ['rcp_num'];
	$mdu_acc = $row ['mdu_acc'];
	$des_ref = $row ['des_ref'];
	$rcp_typ = $row ['rcp_typ'];
	$vod_stu = $row ['vod_stu'];
	$pay_typ = $row ['pay_typ'];
	$bnk_brn = $row ['bnk_brn'];
	$amt = $row ['amt'];
	$arrResult [++$a]['rcp_dte'] = $rcp_dte;
	$arrResult [$a]['pay_time'] = $pay_time;
	$arrResult [$a]['las_nme'] = $las_nme;
	$arrResult [$a]['rcp_num'] = $rcp_num;
	$arrResult [$a]['mdu_acc'] = $mdu_acc;
	$arrResult [$a]['des_ref'] = $des_ref;
	$arrResult [$a]['rcp_typ'] = $rcp_typ;
	$arrResult [$a]['vod_stu'] = $vod_stu;
	$arrResult [$a]['pay_typ'] = $pay_typ;
	$arrResult [$a]['bnk_brn'] = $bnk_brn;
	$arrResult [$a]['amt'] = $amt;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs13 = strtoupper($strCs13);
$strKumpulan = strtoupper($kumpulan);
$strFontSize = 10;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('L','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-13", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs13", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan", 0, 0, 'C');

$strSpace1 = str_pad("", 20 - strlen($kodhasildari), " ",STR_PAD_LEFT);
$strSpace2 = str_pad("", 20 - strlen($tarikhdari), " ",STR_PAD_LEFT);

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER        : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"KOD HASIL DARI : $kodhasildari $strSpace1 KOD HASIL HINGGA : $kodhasilke", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI    : $tarikhdari $strSpace2 TARIKH HINGGA    : $tarikhkepada", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"BIL TARIKH     NO RESIT  NO BIL      KEMASKINI SEMASA  TUNGGAKAN FAEDAH NOTIS CARA BAYARAN               JUMLAH", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"    MASA       NO AKAUN  JENIS LESEN BATAL     SEWAAN  LAIN-LAIN              JENIS BANK", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"    PENGGUNA   KOD HASIL NO RESIT AM           DISKAUN ADJUST", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,2,"---------------------------------------------------------------------------------------------------------------", 0, 0, 'L');

$counterPg = 0;
$bil = 0;
foreach ($arrResult as $curResult) {
	$pg = $counterPg + 1;

	$rcp_dte = $curResult['rcp_dte'];
	$pay_time = $curResult['pay_time'];
	$las_nme = $curResult['las_nme'];
	$rcp_num = $curResult['rcp_num'];
	$mdu_acc = $curResult['mdu_acc'];
	$des_ref = $curResult['des_ref'];
	$rcp_typ = $curResult['rcp_typ'];
	$vod_stu = ($curResult['vod_stu'] == 'N') ? "N" : "BATAL";
	$pay_typ = $curResult['pay_typ'];
	$bnk_brn = $curResult['bnk_brn'];
	$amt = $curResult['amt'];
	$totAmt += $amt;
	++$bil;

	switch ($pay_typ) {
		case 1 :
			$pay_typ = "TUNAI";
			break;
		case 2 :
			$pay_typ = "CEK";
			break;
		case 3 :
			$pay_typ = "KAD KREDIT";
			break;
		case 4 :
			$pay_typ = "WANG POS";
			break;
		case 5 :
			$pay_typ = "EFT";
			break;
		case 6 :
			$pay_typ = "BANK DERAF";
			break;
		case 7 :
			$pay_typ = "BANK SLIP";
			break;
	}

	$strBil = str_pad($bil, 3, " ", STR_PAD_RIGHT);
	$strTarikh = str_pad($rcp_dte, 10, " ", STR_PAD_RIGHT);
	$strMasa = str_pad($pay_time, 10, " ", STR_PAD_RIGHT);
	$strPengguna = str_pad($las_nme, 10, " ", STR_PAD_RIGHT);
	$strNoResit = str_pad($rcp_num, 9, " ", STR_PAD_RIGHT);
	$strNoAkaun = str_pad($mdu_acc, 9, " ", STR_PAD_RIGHT);
	$strKodHasil = str_pad($rcp_typ, 9, " ", STR_PAD_RIGHT);
	$strNoBil = str_pad($noBil, 11, " ", STR_PAD_RIGHT);
	$strJenisLesen = str_pad($jenisLesen, 11, " ", STR_PAD_RIGHT);
	$strNoResitAm = str_pad($noResitAm, 11, " ", STR_PAD_RIGHT);
	$strKemaskini = str_pad($kemasikini, 9, " ", STR_PAD_RIGHT);
	$strBatal = str_pad($vod_stu, 9, " ", STR_PAD_RIGHT);
	$strSemasa = str_pad($semasa, 7, " ", STR_PAD_RIGHT);
	$strSewaan = str_pad($sewaan, 7, " ", STR_PAD_RIGHT);
	$strDiskaun = str_pad($diskaun, 7, " ", STR_PAD_RIGHT);
	$strTunggakanFaedah = str_pad($tunggakanFaedah, 16, " ", STR_PAD_RIGHT);
	$strLainLain = str_pad($lainlain, 16, " ", STR_PAD_RIGHT);
	$strAdjust = str_pad($adjust, 16, " ", STR_PAD_RIGHT);
	$strNotis = str_pad($notis, 5, " ", STR_PAD_RIGHT);
	$strCaraBayaran = str_pad($pay_typ, 10, " ", STR_PAD_RIGHT);
	$strJenisBank = str_pad($bnk_brn, 10, " ", STR_PAD_RIGHT);
	$strAmt = str_pad(number_format($amt,2), 22, " ", STR_PAD_LEFT);

	$pdf->Ln();
	$pdf->Cell(0,3,"$strBil $strTarikh $strNoResit $strNoBil $strKemaskini $strSemasa $strTunggakanFaedah $strNotis $strCaraBayaran $strAmt", 0, 0, 'L');
	$pdf->Ln();
	$pdf->Cell(0,3,"    $strMasa $strNoAkaun $strJenisLesen $strBatal $strSewaan $strLainLain       $strJenisBank", 0, 0, 'L');
	$pdf->Ln();
	$pdf->Cell(0,3,"    $strPengguna $strKodHasil $strNoResitAm           $strDiskaun $strAdjust", 0, 0, 'L');
	$pdf->Ln();
	$pdf->Cell(0,1,"", 0, 0, 'L');
}

$strTotAmt = str_pad(number_format($totAmt,2), 104, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"JUMLAH $strTotAmt", 0, 0, 'L');

$pdf->Output("CS13_$today_pdf.pdf","D");
?>
