<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$arrResitBatal = array();
$a = 0;
$sql = "SELECT TIME(c.cre_dte_tme) pay_time,a.rcp_num,b.mdu_acc,a.vod_stu,c.pay_typ,SUM(b.rcp_amt) + SUM(b.tax_amt) rcp_amt
FROM 
aurerecp a, aureline b, aurepymt c
WHERE
a.rcp_num=b.rcp_num AND a.rcp_num=c.rcp_num AND
a.dep_grp=b.dep_grp AND a.dep_grp=c.dep_grp AND
a.tty_num=b.tty_num AND a.tty_num=c.tty_num AND
a.rcp_dte=b.rcp_dte AND a.rcp_dte=c.rcp_dte
$strWhere
GROUP BY a.RCP_NUM";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$pay_time = $row ['pay_time'];
	$rcp_num = $row ['rcp_num'];
	$mdu_acc = $row ['mdu_acc'];
	$vod_stu = $row ['vod_stu'];
	$pay_typ = $row ['pay_typ'];
	$amt = $row ['rcp_amt'];
	$arrResult [++$a]['pay_time'] = $pay_time;
	$arrResult [$a]['rcp_num'] = $rcp_num;
	$arrResult [$a]['mdu_acc'] = $mdu_acc;
	$arrResult [$a]['vod_stu'] = $vod_stu;
	$arrResult [$a]['pay_typ'] = $pay_typ;
	$arrResult [$a]['amt'] = $amt;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs11 = strtoupper($strCs11);
$strKumpulan = strtoupper($kumpulan);
$strFontSize = 10;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('P','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-11", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs11", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan", 0, 0, 'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI : $tarikhdari          TARIKH HINGGA : $tarikhkepada", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"BIL   MASA       NO RESIT         NO AKAUN         BATAL     BAYARAN              AMAUN", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,2,"---------------------------------------------------------------------------------------", 0, 0, 'L');

$bil = 0;
foreach ($arrResult as $curResult) {
	$pay_time = $curResult['pay_time'];
	$rcp_num = $curResult['rcp_num'];
	$amt = $curResult['amt'];
	$pay_typ = $curResult['pay_typ'];
	$vod_stu = ($curResult['vod_stu'] == 'V') ? "BATAL" : "N";
	$mdu_acc = $curResult['mdu_acc'];
	$des_ref = $curResult['des_ref'];
	$totAmt += $amt;
	++$bil;

	switch ($pay_typ) {
		case 1 :
			$pay_typ = "TUNAI";
			break;
		case 2 :
			$pay_typ = "CEK";
			break;
		case 3 :
			$pay_typ = "KAD KREDIT";
			break;
		case 4 :
			$pay_typ = "WANG POS";
			break;
		case 5 :
			$pay_typ = "EFT";
			break;
		case 6 :
			$pay_typ = "BANK DERAF";
			break;
		case 7 :
			$pay_typ = "BANK SLIP";
			break;
	}

	$strBil = str_pad($bil, 5, " ", STR_PAD_RIGHT);
	$strMasa = str_pad($pay_time, 8, " ", STR_PAD_RIGHT);
	$strNoResit = str_pad($rcp_num, 8, " ", STR_PAD_RIGHT);
	$strNoAkaun = str_pad(substr($mdu_acc,0,15), 15, " ", STR_PAD_RIGHT);
	$strBatal = str_pad($vod_stu, 5, " ", STR_PAD_RIGHT);
	$strBayaran = str_pad($pay_typ, 10, " ", STR_PAD_RIGHT);
	$strAmt = str_pad(number_format($amt,2), 15, " ", STR_PAD_LEFT);

	$pdf->Ln();
	$pdf->Cell(0,4,"$strBil $strMasa   $strNoResit         $strNoAkaun  $strBatal     $strBayaran $strAmt", 0, 0, 'L');
}

$strTotAmt = str_pad(number_format($totAmt,2), 80, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"JUMLAH $strTotAmt", 0, 0, 'L');

$pdf->Output("CS11_$today_pdf.pdf","D");
?>
