<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$desmdu = $_GET ['desmdu'];
$kodhasildari = $_GET ['kodhasildari'];
$kodhasilke = $_GET ['kodhasilke'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= ($desmdu) ? " AND d.DES_MDU='$desmdu'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

if ($kodhasildari && $kodhasilke) {
	$strWhere .= " AND b.RCP_TYP BETWEEN '$kodhasildari' AND '$kodhasilke'";
}

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$arrResitBatal = array();
$a = 0;
$sql = "SELECT a.tty_num,a.rcp_num,b.rcp_typ,a.vod_stu,SUM(b.tax_amt) tax_amt,SUM(b.rcp_amt) act_amt,SUM(b.rcp_amt) + SUM(b.tax_amt) rcp_amt,c.drw_nme,b.mdu_acc,b.des_ref,c.pay_typ,e.dep_num,d.gst_typ
FROM 
(aurerecp a, aureline b, aurepymt c, auretype d) LEFT JOIN aurebank e ON b.DEP_GRP=e.DEP_GRP AND b.TTY_NUM=e.TTY_NUM AND b.RCP_NUM=e.RCP_NUM AND b.RCP_DTE=e.RCP_DTE
WHERE
a.rcp_num=b.rcp_num AND a.rcp_num=c.rcp_num
AND a.dep_grp=b.dep_grp AND a.dep_grp=c.dep_grp
AND a.tty_num=b.tty_num AND a.tty_num=c.tty_num
AND a.rcp_dte=b.rcp_dte AND a.rcp_dte=c.rcp_dte
AND a.opr_num=b.mod_opr AND a.opr_num=c.mod_opr
AND b.rcp_typ=d.rcp_typ
$strWhere
GROUP BY a.RCP_NUM";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$tty_num = $row ['tty_num'];
	$rcp_num = $row ['rcp_num'];
	$rcp_typ = $row ['rcp_typ'];
	$vod_stu = $row ['vod_stu'];
	$tax_amt = $row ['tax_amt'];
	$act_amt = $row ['act_amt'];
	$amt = $row ['rcp_amt'];
	$drw_nme = $row ['drw_nme'];
	$mdu_acc = $row ['mdu_acc'];
	$des_ref = $row ['des_ref'];
	$pay_typ = $row ['pay_typ'];
	$dep_num = $row ['dep_num'];
	$gst_typ = $row ['gst_typ'];

	$arrResult [++$a]['rcp_num'] = $rcp_num;
	$arrResult [$a]['tty_num'] = $tty_num;
	$arrResult [$a]['tax_amt'] = $tax_amt;
	$arrResult [$a]['act_amt'] = $act_amt;
	$arrResult [$a]['amt'] = $amt;
	$arrResult [$a]['rcp_typ'] = $rcp_typ;
	$arrResult [$a]['vod_stu'] = $vod_stu;
	$arrResult [$a]['drw_nme'] = $drw_nme;
	$arrResult [$a]['mdu_acc'] = $mdu_acc;
	$arrResult [$a]['des_ref'] = $des_ref;
	$arrResult [$a]['pay_typ'] = $pay_typ;
	$arrResult [$a]['dep_num'] = $dep_num;
	$arrResult [$a]['gst_typ'] = $gst_typ;
}


$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs10 = strtoupper($strCs10);
$strKumpulan = strtoupper($kumpulan);
$strKumpulanDesc = strtoupper(re_getDepGrpDesc($kumpulan));
$strFontSize = 9;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('L','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-10", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs10", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan ($strKumpulanDesc)", 0, 0, 'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER       : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI   : $tarikhdari          KOD HASIL DARI   : $kodhasildari", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH HINGGA : $tarikhkepada          KOD HASIL HINGGA : $kodhasilke", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KTR KOD   KOD    JENIS   NO AKAUN       NO BIL         NO       NO       NAMA                                       AMAUN     AMAUN        JUMLAH", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"    HASIL GST    BAYARAN                               RESIT    B/SLIP                                                          GST         AMAUN", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"-------------------------------------------------------------------------------------------------------------------------------------------------", 0, 0, 'L');

foreach ($arrResult as $curResult) {
	$tty_num = $curResult['tty_num'];
	$rcp_num = $curResult['rcp_num'];
	$tax_amt = $curResult['tax_amt'];
	$act_amt = $curResult['act_amt'];
	$amt = $curResult['amt'];
	$rcp_typ = $curResult['rcp_typ'];
	$vod_stu = ($curResult['vod_stu'] == 'V') ? "BATAL" : "N";
	$drw_nme = $curResult['drw_nme'];
	$mdu_acc = $curResult['mdu_acc'];
	$des_ref = $curResult['des_ref'];
	$pay_typ = $curResult['pay_typ'];
	$dep_num = $curResult['dep_num'];
	$gst_typ = $curResult['gst_typ'];
	$totTax += $tax_amt;
	$totAct += $act_amt;
	$totAmt += $amt;

	switch ($pay_typ) {
		case 1 :
			$caraBayaran = "TUNAI";
			break;
		case 2 :
			$caraBayaran = "CEK";
			break;
		case 3 :
			$caraBayaran = "KAD KREDIT";
			break;
		case 4 :
			$caraBayaran = "WANG POS";
			break;
		case 5 :
			$caraBayaran = "EFT";
			break;
		case 6 :
			$caraBayaran = "BANK DERAF";
			break;
		case 7 :
			$caraBayaran = "BANK SLIP";
			break;
		case 8 :
			$caraBayaran = "OSP";
			break;
	}

	$strTtyNum = str_pad($tty_num, 3, " ", STR_PAD_RIGHT);
	$strJenisBayaran = str_pad($jenisBayaran, 7, " ", STR_PAD_RIGHT);
	$strKodHasil = str_pad($rcp_typ, 5, " ", STR_PAD_RIGHT);
	$strCaraBayaran = str_pad($caraBayaran, 7, " ", STR_PAD_RIGHT);
	$strGstTyp = str_pad($gst_typ, 6, " ", STR_PAD_RIGHT);
	$strBatal = str_pad($vod_stu, 6, " ", STR_PAD_RIGHT);
	$strNoAkaun = str_pad(substr($mdu_acc, 0,14), 14, " ", STR_PAD_RIGHT);
	$strNoBil = str_pad(substr($des_ref, 0,14), 14, " ", STR_PAD_RIGHT);
	$strNoResit = str_pad($rcp_num, 8, " ", STR_PAD_RIGHT);
	$strDepNum = str_pad($dep_num, 8, " ", STR_PAD_RIGHT);
	$drw_nme = substr($drw_nme, 0,33);
	$strActAmt = str_pad(number_format($act_amt,2), 47 - strlen($drw_nme), " ", STR_PAD_LEFT);
	$strTaxAmt = str_pad(number_format($tax_amt,2), 9, " ", STR_PAD_LEFT);
	$strAmt = str_pad(number_format($amt,2), 13, " ", STR_PAD_LEFT);

	$pdf->Ln();
	$pdf->Cell(0,3,"$strTtyNum $strKodHasil $strGstTyp $strCaraBayaran $strNoAkaun $strNoBil $strNoResit $strDepNum $drw_nme $strActAmt $strTaxAmt $strAmt", 0, 0, 'L');
}

$strTotAct = str_pad(number_format($totAct,2), 114, " ", STR_PAD_LEFT);
$strTotTax = str_pad(number_format($totTax,2), 9, " ", STR_PAD_LEFT);
$strTotAmt = str_pad(number_format($totAmt,2), 13, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,4,"JUMLAH $strTotAct $strTotTax $strTotAmt", 0, 0, 'L');

$pdf->Output("CS10_$today_pdf.pdf","D");
?>
