<?php

class Osp  {

	protected $sqlTable = 'OSP';

	public $ospid;
	public $ospcode;
	public $ospdesc;
	public $mduacc_start;
	public $mduacc_length;
	public $drwnme_start;
	public $drwnme_length;
	public $rcpdte_start;
	public $rcpdte_length;
	public $rcpamt_start;
	public $rcpamt_length;
	public $paytyp_start;
	public $paytyp_length;
	public $payref_start;
	public $payref_length;
	public $credtetme;
	public $moddtetme;
	public $modopr;

	//insert function
	public function insert(){
			
		if (isset ( $this->ospcode )) {
			$insertCols .= "OSP_CODE, ";
			$insertVals .= "'" . $this->ospcode . "', ";
		}
			
		if (isset ( $this->ospdesc )) {
			$insertCols .= "OSP_DESC, ";
			$insertVals .= "'" . $this->ospdesc . "', ";
		}
			
		if (isset ( $this->mduacc_start )) {
			$insertCols .= "MDU_ACC_START, ";
			$insertVals .= "'" . $this->mduacc_start . "', ";
		}
			
		if (isset ( $this->mduacc_length )) {
			$insertCols .= "MDU_ACC_LENGTH, ";
			$insertVals .= "'" . $this->mduacc_length . "', ";
		}

		if (isset ( $this->drwnme_start )) {
			$insertCols .= "DRW_NME_START, ";
			$insertVals .= "'" . $this->drwnme_start . "', ";
		}

		if (isset ( $this->drwnme_length )) {
			$insertCols .= "DRW_NME_LENGTH, ";
			$insertVals .= "'" . $this->drwnme_length . "', ";
		}

		if (isset ( $this->rcpdte_start )) {
			$insertCols .= "RCP_DTE_START, ";
			$insertVals .= "'" . $this->rcpdte_start . "', ";
		}

		if (isset ( $this->rcpdte_length )) {
			$insertCols .= "RCP_DTE_LENGTH, ";
			$insertVals .= "'" . $this->rcpdte_length . "', ";
		}
			
		if (isset ( $this->rcpamt_start )) {
			$insertCols .= "RCP_AMT_START, ";
			$insertVals .= "'" . $this->rcpamt_start . "', ";
		}
			
		if (isset ( $this->rcpamt_length )) {
			$insertCols .= "RCP_AMT_LENGTH, ";
			$insertVals .= "'" . $this->rcpamt_length . "', ";
		}
			
		if (isset ( $this->paytyp_start )) {
			$insertCols .= "PAY_TYP_START, ";
			$insertVals .= "'" . $this->paytyp_start . "', ";
		}
			
		if (isset ( $this->paytyp_length )) {
			$insertCols .= "PAY_TYP_LENGTH, ";
			$insertVals .= "'" . $this->paytyp_length . "', ";
		}
			
		if (isset ( $this->payref_start )) {
			$insertCols .= "PAY_REF_START, ";
			$insertVals .= "'" . $this->payref_start . "', ";
		}
			
		if (isset ( $this->payref_length )) {
			$insertCols .= "PAY_REF_LENGTH, ";
			$insertVals .= "'" . $this->payref_length . "', ";
		}
			
		$insertCols .= "CRE_DTE_TME, ";
		$insertVals .= "NOW(), ";

		if (isset ( $this->modopr )) {
			$insertCols .= "MOD_OPR, ";
			$insertVals .= "'" . $this->modopr . "', ";
		}
			
		$insertCols = eregi_replace(", $", "", $insertCols);
		$insertVals = eregi_replace(", $", "", $insertVals);

		$sql = "INSERT INTO $this->sqlTable ($insertCols)";
		$sql .= " VALUES ($insertVals)";
			
		db_query ( $sql );

	}

	//update function
	public function update(){

		$sql = "UPDATE $this->sqlTable SET ";

		if (isset ( $this->ospcode )) {
			$sql .= "OSP_CODE = '" . $this->ospcode . "', ";
		}

		if (isset ( $this->ospdesc )) {
			$sql .= "OSP_DESC = '" . $this->ospdesc . "', ";
		}

		if (isset ( $this->mduacc_start )) {
			$sql .= "MDU_ACC_START = '" . $this->mduacc_start . "', ";
		}

		if (isset ( $this->mduacc_length )) {
			$sql .= "MDU_ACC_LENGTH = '" . $this->mduacc_length . "', ";
		}

		if (isset ( $this->drwnme_start )) {
			$sql .= "DRW_NME_START = '" . $this->drwnme_start . "', ";
		}

		if (isset ( $this->drwnme_length )) {
			$sql .= "DRW_NME_LENGTH = '" . $this->drwnme_length . "', ";
		}

		if (isset ( $this->rcpdte_start )) {
			$sql .= "RCP_DTE_START = '" . $this->rcpdte_start . "', ";
		}

		if (isset ( $this->rcpdte_length )) {
			$sql .= "RCP_DTE_LENGTH = '" . $this->rcpdte_length . "', ";
		}

		if (isset ( $this->rcpamt_start )) {
			$sql .= "RCP_AMT_START = '" . $this->rcpamt_start . "', ";
		}

		if (isset ( $this->rcpamt_length )) {
			$sql .= "RCP_AMT_LENGTH = '" . $this->rcpamt_length . "', ";
		}

		if (isset ( $this->paytyp_start )) {
			$sql .= "PAY_TYP_START = '" . $this->paytyp_start . "', ";
		}

		if (isset ( $this->paytyp_length )) {
			$sql .= "PAY_TYP_LENGTH = '" . $this->paytyp_length . "', ";
		}

		if (isset ( $this->payref_start )) {
			$sql .= "PAY_REF_START = '" . $this->payref_start . "', ";
		}

		if (isset ( $this->payref_length )) {
			$sql .= "PAY_REF_LENGTH = '" . $this->payref_length . "', ";
		}

		$sql .= "MOD_DTE_TME = NOW(), ";

		if (isset ( $this->modopr )) {
			$sql .= "MOD_OPR = '" . $this->modopr . "', ";
		}

		$sql = eregi_replace ( ', $', '', $sql);
		$sql .= " WHERE OSP_ID = '" . $this->ospid . "'";

		db_query ( $sql );
	}

	//search function
	public function searchTotal(){

		$total = 0;
		$sql = "SELECT COUNT(*) TOTAL FROM $this->sqlTable WHERE 1=1 ";

		if (strlen ( $this->ospid ) > 0) {
			$sql .= "AND OSP_ID = '" . $this->ospid . "' ";
		}

		if (strlen ( $this->ospcode ) > 0) {
			$sql .= "AND OSP_CODE = '" . $this->ospcode . "' ";
		}

		if (strlen ( $this->ospdesc ) > 0) {
			$sql .= "AND OSP_DESC = '" . $this->ospdesc . "' ";
		}

		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$total = $row ['TOTAL'];
		}

		return $total;

	}

	//search function
	public function search(){

		global $db;
		$total = 0;

		if ($db == "oracle") {
			$sql = "select *
			  from ( select a.*, rownum rnum
			           from ( SELECT TTY_NUM,RCP_NUM,to_char(RCP_DTE,'DD/MM/YYYY') RCP_DTE,KEP_CSH,RNG_RCP,ST_RCP,END_RCP,PRT_FLG,ACT_FLG,to_char(CRE_DTE_TME,'DD-MM-YYYY HH24:MI:SS') CRE_DTE_TME,to_char(MOD_DTE_TME,'DD-MM-YYYY HH24:MI:SS') MOD_DTE_TME,MOD_OPR,DEP_GRP FROM AURETERM WHERE 1=1 $this->strwhere ) a
			          where rownum <= $this->currentdata )
			  where rnum >= $this->currentdata";
		} else if ($db == "mysql") {
			$sql = "SELECT *
					FROM ( 
					    SELECT 
					        @row := @row +1 AS rownum, OSP_ID,OSP_CODE,OSP_DESC,MDU_ACC_START,MDU_ACC_LENGTH,DRW_NME_START,DRW_NME_LENGTH,RCP_DTE_START,RCP_DTE_LENGTH,RCP_AMT_START,RCP_AMT_LENGTH,PAY_TYP_START,PAY_TYP_LENGTH,PAY_REF_START,PAY_REF_LENGTH,DATE_FORMAT(CRE_DTE_TME,'%d/%m/%Y %H:%i:%s') AS CRE_DTE_TME,DATE_FORMAT(MOD_DTE_TME,'%d/%m/%Y %H:%i:%s') AS MOD_DTE_TME,MOD_OPR
					    FROM ( 
					        SELECT @row :=0) r, OSP WHERE 1=1 $this->strwhere
					    ) ranked 
					WHERE rownum = $this->currentdata";
		}
		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$this->ospid = $row ['OSP_ID'];
			$this->ospcode = $row ['OSP_CODE'];
			$this->ospdesc = $row ['OSP_DESC'];
			$this->mduacc_start = $row ['MDU_ACC_START'];
			$this->mduacc_length = $row ['MDU_ACC_LENGTH'];
			$this->drwnme_start = $row ['DRW_NME_START'];
			$this->drwnme_length = $row ['DRW_NME_LENGTH'];
			$this->rcpdte_start = $row ['RCP_DTE_START'];
			$this->rcpdte_length = $row ['RCP_DTE_LENGTH'];
			$this->rcpamt_start = $row ['RCP_AMT_START'];
			$this->rcpamt_length = $row ['RCP_AMT_LENGTH'];
			$this->paytyp_start = $row ['PAY_TYP_START'];
			$this->paytyp_length = $row ['PAY_TYP_LENGTH'];
			$this->payref_start = $row ['PAY_REF_START'];
			$this->payref_length = $row ['PAY_REF_LENGTH'];
			$this->credtetme = $row ['CRE_DTE_TME'];
			$this->moddtetme = $row ['MOD_DTE_TME'];
			$this->modopr = $row ['MOD_OPR'];
		}

	}

	//for search function, we have to build strwhere
	public function builtStrWhere(){

		global $db;

		if (strlen ( $this->ospid ) > 0) {
			$sql .= " AND OSP_ID = '" . $this->ospid . "'";
		}

		if (strlen ( $this->ospcode ) > 0) {
			$sql .= " AND OSP_CODE = '" . $this->ospcode . "'";
		}

		if (strlen ( $this->ospdesc ) > 0) {
			$sql .= " AND OSP_DESC = '" . $this->ospdesc . "'";
		}

		return $sql;

	}

	public function select() {

		$sql = "SELECT * FROM $this->sqlTable WHERE OSP_ID = '" . $this->ospid . "'";
		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$this->ospid = $row ['OSP_ID'];
			$this->ospcode = $row ['OSP_CODE'];
			$this->ospdesc = $row ['OSP_DESC'];
			$this->mduacc_start = $row ['MDU_ACC_START'];
			$this->mduacc_length = $row ['MDU_ACC_LENGTH'];
			$this->drwnme_start = $row ['DRW_NME_START'];
			$this->drwnme_length = $row ['DRW_NME_LENGTH'];
			$this->rcpdte_start = $row ['RCP_DTE_START'];
			$this->rcpdte_length = $row ['RCP_DTE_LENGTH'];
			$this->rcpamt_start = $row ['RCP_AMT_START'];
			$this->rcpamt_length = $row ['RCP_AMT_LENGTH'];
			$this->paytyp_start = $row ['PAY_TYP_START'];
			$this->paytyp_length = $row ['PAY_TYP_LENGTH'];
			$this->payref_start = $row ['PAY_REF_START'];
			$this->payref_length = $row ['PAY_REF_LENGTH'];
		}

	}

	public function count () {

		$total = 0;
		$sql = "SELECT COUNT(*) TOTAL FROM $this->sqlTable ";
		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$total = $row ['TOTAL'];
		}
		return $total;
	}

	public function delete () {

		$sql = "DELETE FROM $this->sqlTable WHERE OSP_ID = '" . $this->ospid . "'";
		db_query ( $sql );

	}
}

?>