<?php

Class Mapbankcode {

	protected $sqlTable = 'map_bankcode';
	
	public $depgrp;  //DEP_GRP varchar(10)
	public $bnktyp;  //BNK_TYP char(1)
	public $bnknum;  //BNK_NUM int(5)
	public $bnkcdec;  //BNK_CDE_C int(5)
	public $bnkcdet;  //BNK_CDE_T int(5)
	public $bnkcded;  //BNK_CDE_D int(5)
	public $credtetme;  //CRE_DTE_TME datetime
	public $moddtetme;  //MOD_DTE_TME datetime
	public $modopr;  //MOD_OPR int(10)

	public function insert() {

		if ( strlen ( $this->depgrp ) > 0 ) { $insertCols .= "DEP_GRP, "; $insertVals .= "'$this->depgrp', "; }
		if ( strlen ( $this->bnktyp ) > 0 ) { $insertCols .= "BNK_TYP, "; $insertVals .= "'$this->bnktyp', "; }
		if ( strlen ( $this->bnknum ) > 0 ) { $insertCols .= "BNK_NUM, "; $insertVals .= "'$this->bnknum', "; }
		if ( strlen ( $this->bnkcdec ) > 0 ) { $insertCols .= "BNK_CDE_C, "; $insertVals .= "'$this->bnkcdec', "; }
		if ( strlen ( $this->bnkcdet ) > 0 ) { $insertCols .= "BNK_CDE_T, "; $insertVals .= "'$this->bnkcdet', "; }
		if ( strlen ( $this->bnkcded ) > 0 ) { $insertCols .= "BNK_CDE_D, "; $insertVals .= "'$this->bnkcded', "; }
		$insertCols .= "CRE_DTE_TME, "; $insertVals .= "NOW(), ";
		if ( strlen ( $this->modopr ) > 0 ) { $insertCols .= "MOD_OPR, "; $insertVals .= "'$this->modopr', "; }

		$insertCols = eregi_replace(", $", "", $insertCols);
		$insertVals = eregi_replace(", $", "", $insertVals);

		$sql = "INSERT INTO $this->sqlTable ($insertCols)";
		$sql .= " VALUES ($insertVals)";

		db_query ( $sql );
	}

	public function update() {

		$sql = "UPDATE $this->sqlTable SET ";

		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "DEP_GRP = '$this->depgrp', "; }
		if ( strlen ( $this->bnktyp ) > 0 ) { $sql .= "BNK_TYP = '$this->bnktyp', "; }
		if ( strlen ( $this->bnknum ) > 0 ) { $sql .= "BNK_NUM = '$this->bnknum', "; }
		if ( strlen ( $this->bnkcdec ) > 0 ) { $sql .= "BNK_CDE_C = '$this->bnkcdec', "; }
		if ( strlen ( $this->bnkcdet ) > 0 ) { $sql .= "BNK_CDE_T = '$this->bnkcdet', "; }
		if ( strlen ( $this->bnkcded ) > 0 ) { $sql .= "BNK_CDE_D = '$this->bnkcded', "; }
		$sql .= "MOD_DTE_TME = NOW(), ";
		if ( strlen ( $this->modopr ) > 0 ) { $sql .= "MOD_OPR = '$this->modopr', "; }

		$sql = eregi_replace ( ', $', '', $sql);

		$sql .= " WHERE 1=1 ";

		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "AND DEP_GRP = '$this->depgrp' "; }
		if ( strlen ( $this->bnktyp ) > 0 ) { $sql .= "AND BNK_TYP = '$this->bnktyp' "; }

		db_query ( $sql );
	}

	public function select() {

		$sql = "SELECT *
		, DATE_FORMAT(CRE_DTE_TME,'%d/%m/%Y %H:%i:%s') CRE_DTE_TME
		, DATE_FORMAT(MOD_DTE_TME,'%d/%m/%Y %H:%i:%s') MOD_DTE_TME
		FROM $this->sqlTable WHERE 1=1 ";

		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "AND DEP_GRP = '$this->depgrp' "; }
		if ( strlen ( $this->bnktyp ) > 0 ) { $sql .= "AND BNK_TYP = '$this->bnktyp' "; }
		
		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$this->depgrp = $row ['DEP_GRP'];
			$this->bnktyp = $row ['BNK_TYP'];
			$this->bnknum = $row ['BNK_NUM'];
			$this->bnkcdec = $row ['BNK_CDE_C'];
			$this->bnkcdet = $row ['BNK_CDE_T'];
			$this->bnkcded = $row ['BNK_CDE_D'];
			$this->credtetme = $row ['CRE_DTE_TME'];
			$this->moddtetme = $row ['MOD_DTE_TME'];
			$this->modopr = $row ['MOD_OPR'];
		}

	}

	public function count () {

		$total = 0;
		$sql = "SELECT COUNT(*) TOTAL FROM $this->sqlTable WHERE 1=1 ";

		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "AND DEP_GRP = '$this->depgrp' "; }

		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$total = $row ['TOTAL'];
		}
		return $total;

	}

	public function delete () {

		$sql = "DELETE FROM $this->sqlTable WHERE 1=1";

		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "AND DEP_GRP = '$this->depgrp' "; }

		db_query ( $sql );

	}

}

?>