<?php

include_once 'lib/db.php';
require_once 'class/Aurerecp.php';
require_once 'class/Aureterm.php';
require_once 'class/Aurecash.php';
require_once 'class/Aualrefs.php';
require_once 'class/Paytrana.php';
require_once 'class/Paytrand.php';
require_once 'class/Paytranm.php';
require_once 'class/Aurealloc.php';
require_once 'class/Billtranr.php';
require_once 'class/Compoundr.php';

$kumpulan = $_POST ['kumpulan'];
$terminal = $_POST ['terminal'];
$operator = $_POST ['operator'];
$date = $_POST ['date'];
$printer = $_POST ['printer'];

$time = date ( 'H:i:s' );
$today = date ( 'd-m-Y' );
$today_full = date ( 'd-m-Y H:i:s' );

$objAURERECP = new Aurerecp();
$objAURERECP->depgrp = $kumpulan;
$objAURERECP->ttynum = $terminal;
$objAURERECP->oprnum = $operator;
$objAURERECP->rcpdte = $date;
$objAURERECP->vodstu = 'N';
$objAURERECP->balflg = 'N';
$objAURERECP->select();
$dep_grp = $objAURERECP->depgrp;
$tty_num = $objAURERECP->ttynum;
$rcp_num = $objAURERECP->rcpnum;

//get last no resit
$objAURETERM = new Aureterm();
$objAURETERM->depgrp = $kumpulan;
$objAURETERM->ttynum = $terminal;
$objAURETERM->select();
$last_rcp_num = $objAURETERM->rcpnum;

$strWhereLine = ($kumpulan) ? " AND AURELINE.DEP_GRP='$kumpulan'" : "";
$strWhereLine .= ($terminal) ? " AND AURELINE.TTY_NUM='$terminal'" : "";
$strWhereLine .= " AND AURERECP.VOD_STU != 'V'";
$strWhereLine .= " AND AURERECP.VOD_STU != 'O'";
$strWhereLine .= " AND AURERECP.BAL_FLG != 'Y'";

$arrTyp = array ();
$c = 0;
$sqlA = "SELECT AURELINE.RCP_TYP, AURELINE.RCP_AMT, AURETYPE.RCP_DSC
FROM AURELINE
LEFT JOIN AURERECP ON AURERECP.RCP_NUM = AURELINE.RCP_NUM AND AURERECP.RCP_DTE = AURELINE.RCP_DTE
LEFT JOIN AURETYPE ON AURELINE.RCP_TYP = AURETYPE.RCP_TYP 
WHERE 1=1 $strWhereLine  ORDER BY AURELINE.RCP_TYP";
$sA = db_query ( $sqlA );
while ( $rowA = db_fetch_array ( $sA ) ) {
	$rcp_typ = $rowA ['RCP_TYP'];
	$arrTyp [$rcp_typ] [$c] ['amt'] = $rowA ['RCP_AMT'];
	$arrTyp [$rcp_typ] [$c] ['dsc'] = substr ($rowA ['RCP_DSC'], 0, 14);
	$c++;
}

$totTunai = $totLCCek = $totHSCek = $totOSCek = $totOTCek = $totKad = $totWangPos = $totEft = $totDerafBank = $totSlipBank = $totOthers = $totType = $totBil = 0;
$totBilTunai = $totBilLCCek = $totBilHSCek = $totBilOSCek = $totBilOTCek = $totBilKad = $totBilWangPos = $totBilEft = $totBilDerafBank = $totBilSlipBank = $totBilOthers = $grandTotalBil = 0;

$strWherePymt = ($kumpulan) ? " AND AUREPYMT.DEP_GRP='$kumpulan'" : "";
$strWherePymt .= ($terminal) ? " AND AUREPYMT.TTY_NUM='$terminal'" : "";
$strWherePymt .= " AND AURERECP.VOD_STU != 'V'";
$strWherePymt .= " AND AURERECP.VOD_STU != 'O'";
$strWherePymt .= " AND AURERECP.BAL_FLG != 'Y'";

$sql1 = "SELECT AUREPYMT.PAY_TYP,AUREPYMT.BNK_BSB,AURERECP.RCP_AMT,AURERECP.RCP_DTE
FROM AUREPYMT 
LEFT JOIN AURERECP ON AURERECP.RCP_NUM = AUREPYMT.RCP_NUM
WHERE 1=1 $strWherePymt GROUP BY AUREPYMT.RCP_NUM";
$s1 = db_query ( $sql1 );
while ( $row1 = db_fetch_array ( $s1 ) ) {
	$pay_typ = $row1 ['PAY_TYP'];
	$rcp_amt = $row1 ['RCP_AMT'];
	$bnk_bsb = $row1 ['BNK_BSB'];
	$rcp_dte = $row1 ['RCP_DTE'];

	if ($bnk_bsb && $pay_typ == "2") {
		$arrBnkBsb = explode("-", $bnk_bsb);

		if ( substr( $arrBnkBsb [0], -1 ) == "0" && substr( $arrBnkBsb [1], 0, 1 ) == "0" ) {  //tempatan
			$totLCCek += 1;
			$totBilLCCek += $rcp_amt;
		}
		if ( substr( $arrBnkBsb [1], 0, 1 ) == "1" ) {  //sendiri
			$totHSCek += 1;
			$totBilHSCek += $rcp_amt;
		}
		if ( substr( $arrBnkBsb [0], -1 ) == "1" ) {  //luar
			$totOSCek += 1;
			$totBilOSCek += $rcp_amt;
		}
	}

	//1=Tunai, 2=Cek, 3=Kad Kredit, 4=Wang Pos, 5=EFT, 6=Deraf Bank, 7=Slip Bank
	switch ($pay_typ) {
		case 1 :
			$totTunai += 1;
			$totBilTunai += $rcp_amt;
			break;
		case 3 :
			$totKad += 1;
			$totBilKad += $rcp_amt;
			break;
		case 4 :
			$totWangPos += 1;
			$totBilWangPos += $rcp_amt;
			break;
		case 5 :
			$totEft += 1;
			$totBilEft += $rcp_amt;
			break;
		case 6 :
			$totDerafBank += 1;
			$totBilDerafBank += $rcp_amt;
			break;
		case 7 :
			$totSlipBank += 1;
			$totBilSlipBank += $rcp_amt;
			break;
		default :
			$totOthers += 1;
			$totBilOthers += $rcp_amt;
	}
	$totType += 1;
	$grandTotalBil += $rcp_amt;
}

//get dep_grp desc
$objAUALREFS = new Aualrefs();
$objAUALREFS->reftyp = 'dep_grp';
$objAUALREFS->refval = $dep_grp;
$objAUALREFS->select();
$kumpulan_desc = $objAUALREFS->dscno1;

//get oeprator name
$operator_name = re_getfullname ( $operator );

$totBilTunai = ($totBilTunai > 0) ? number_format ( $totBilTunai, 2 ) : '0.00';
$totBilHSCek = ($totBilHSCek > 0) ? number_format ( $totBilHSCek, 2 ) : '0.00';
$totBilLCCek = ($totBilLCCek > 0) ? number_format ( $totBilLCCek, 2 ) : '0.00';
$totBilOSCek = ($totBilOSCek > 0) ? number_format ( $totBilOSCek, 2 ) : '0.00';
$totBilOTCek = ($totBilOTCek > 0) ? number_format ( $totBilOTCek, 2 ) : '0.00';
$totBilWangPos = ($totBilWangPos > 0) ? number_format ( $totBilWangPos, 2 ) : '0.00';
$totBilEft = ($totBilEft > 0) ? number_format ( $totBilEft, 2 ) : '0.00';
$totBilSlipBank = ($totBilSlipBank > 0) ? number_format ( $totBilSlipBank, 2 ) : '0.00';
$totBilKad = ($totBilKad > 0) ? number_format ( $totBilKad, 2 ) : '0.00';
$totBilDerafBank = ($totBilDerafBank > 0) ? number_format ( $totBilDerafBank, 2 ) : '0.00';
$grandTotalBil = ($grandTotalBil > 0) ? number_format ( $grandTotalBil, 2 ) : '0.00';

$audit_printer = ($audit_printer) ? $audit_printer : "EPSON TM-U220 Receipt";

#$handle = printer_open($audit_printer);
#printer_start_doc($handle, "My Document");
#printer_start_page($handle);

#$font = printer_create_font("FontB11", 17, 12, 400, false, false, false, 0);
#printer_select_font($handle, $font);

$x = 0;
$y = 25;
#printer_draw_text($handle, "LAPORAN KELUAR", 0, $y);
$y += 25;
#printer_draw_text($handle, "$kumpulan_desc", 0, $y);
$y += 25;
$strSpace = str_pad ( " ", 18 - strlen($kumpulan), " ", STR_PAD_LEFT );
#printer_draw_text($handle, "STESEN $kumpulan $strSpace MESIN $tty_num", 0, $y);
$y += 25;
$strSpace = str_pad ( " ", 18 - strlen($today), " ", STR_PAD_LEFT );
#printer_draw_text($handle, "TARIKH $today $strSpace MASA $time", 0, $y);
$y += 50;
#printer_draw_text($handle, "----------------------------------------", 0, $y);

$y += 25;
#printer_draw_text($handle, "OPERATOR: $operator $operator_name", 0, $y);
$y += 25;
#printer_draw_text($handle, "CARA_______BILG._____________AMAUN", 0, $y);

$y += 25;
$strTotTunai = str_pad ( $totTunai, 3, " ", STR_PAD_LEFT );
$strTotBilTunai = str_pad ( $totBilTunai, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "TUNAI        $strTotTunai $strTotBilTunai", 0, $y);
$y += 25;
$strTotHSCek = str_pad ( $totHSCek, 3, " ", STR_PAD_LEFT );
$strTotBilHSCek = str_pad ( $totBilHSCek, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "HSCEK        $strTotHSCek $strTotBilHSCek", 0, $y);
$y += 25;
$strTotLCCek = str_pad ( $totLCCek, 3, " ", STR_PAD_LEFT );
$strTotBilLCCek = str_pad ( $totBilLCCek, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "LCCEK        $strTotLCCek $strTotBilLCCek", 0, $y);
$y += 25;
$strTotOSCek = str_pad ( $totOSCek, 3, " ", STR_PAD_LEFT );
$strTotBilOSCek = str_pad ( $totBilOSCek, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "OSCEK        $strTotOSCek $strTotBilOSCek", 0, $y);
$y += 25;
$strTotOTCek = str_pad ( $totOTCek, 3, " ", STR_PAD_LEFT );
$strTotBilOTCek = str_pad ( $totBilOTCek, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "OTCEK        $strTotOTCek $strTotBilOTCek", 0, $y);
$y += 25;
$strTotWangPos = str_pad ( $totWangPos, 3, " ", STR_PAD_LEFT );
$strTotBilWangPos = str_pad ( $totBilWangPos, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "PO/MO        $strTotWangPos $strTotBilWangPos", 0, $y);
$y += 25;
$strTotEft = str_pad ( $totEft, 3, " ", STR_PAD_LEFT );
$strTotBilEft = str_pad ( $totBilEft, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "EFT          $strTotEft $strTotBilEft", 0, $y);
$y += 25;
$strTotSlipBank = str_pad ( $totSlipBank, 3, " ", STR_PAD_LEFT );
$strTotBilSlipBank = str_pad ( $totBilSlipBank, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "BNKSL        $strTotSlipBank $strTotBilSlipBank", 0, $y);
$y += 25;
$strTotKad = str_pad ( $totKad, 3, " ", STR_PAD_LEFT );
$strTotBilKad = str_pad ( $totBilKad, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "KAD          $strTotKad $strTotBilKad", 0, $y);
$y += 25;
$strTotDerafBank = str_pad ( $totDerafBank, 3, " ", STR_PAD_LEFT );
$strTotBilDerafBank = str_pad ( $totBilDerafBank, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "BDRAF        $strTotDerafBank $strTotBilDerafBank", 0, $y);

$y += 50;
$strTotType = str_pad ( $totType, 3, " ", STR_PAD_LEFT );
$strGrandTotalBil = str_pad ( $grandTotalBil, 17, " ", STR_PAD_LEFT );
#printer_draw_text($handle, "JUMLAH       $strTotType $strGrandTotalBil", 0, $y);

$y += 50;
#printer_draw_text($handle, "RESIT AKHIR   $last_rcp_num", 0, $y);

$y += 50;
#printer_draw_text($handle, "KOD_____________TRANS______________AMAUN", 0, $y);

$strWhere = ($operator) ? " AND AURERECP.OPR_NUM='$operator'" : "";
$strWhere .= ($kumpulan) ? " AND AURERECP.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND AURERECP.TTY_NUM='$terminal'" : "";
$strWhere .= " AND AURERECP.VOD_STU != 'V' AND AURERECP.VOD_STU != 'O'";
$strWhere .= " AND AURERECP.BAL_FLG != 'Y'";

$arrRcp = array();
$totRcpAmt = 0;
$sql3 = "SELECT AURELINE.RCP_TYP,AURETYPE.RCP_DSC,COUNT(AURELINE.RCP_TYP) TOTAL,SUM(AURELINE.RCP_AMT) SUM
		FROM AURELINE,AURERECP,AURETYPE
		WHERE AURELINE.RCP_NUM=AURERECP.RCP_NUM 
		AND AURERECP.DEP_GRP=AURELINE.DEP_GRP
		AND AURERECP.TTY_NUM=AURELINE.TTY_NUM
		AND AURERECP.RCP_DTE=AURELINE.RCP_DTE
		AND AURERECP.OPR_NUM=AURELINE.MOD_OPR
		AND AURETYPE.RCP_TYP=AURELINE.RCP_TYP
		AND AURERECP.VOD_STU != 'V' AND AURERECP.VOD_STU != 'O' $strWhere 
		GROUP BY AURELINE.RCP_TYP ORDER BY AURELINE.RCP_TYP";
$s3 = db_query ( $sql3 );
while ( $row3 = db_fetch_array ( $s3 ) ) {
	$type = str_pad ($row3 ['RCP_TYP'], 5, "0", STR_PAD_LEFT);
	$desc = substr ( $row3 ['RCP_DSC'], 0, 12 );
	$total = $row3 ['TOTAL'];
	$sum = $row3 ['SUM'];
	$grandTotal += $row3 ['TOTAL'];
	$grandSum += $row3 ['SUM'];

	$strTotal = str_pad ( $total, 19 - strlen ( $type ) - strlen ( $desc ), " ", STR_PAD_LEFT );
	$strSum = str_pad ( number_format( $sum, 2 ), 18, " ", STR_PAD_LEFT );

	$y += 25;
	#printer_draw_text($handle, "$type $desc $strTotal $strSum", 0, $y);
}

$strGrandTotal = str_pad ( $grandTotal, 3, " ", STR_PAD_LEFT );
$strGrandSum = str_pad ( number_format( $grandSum, 2 ), 21 - strlen ( $strGrandTotal ), " ", STR_PAD_LEFT );

$y += 50;
#printer_draw_text($handle, "JUMLAH            $strGrandTotal $strGrandSum", 0, $y);

$y += 25;
#printer_draw_text($handle, "----------------------------------------", 0, $y);
$y += 50;
#printer_draw_text($handle, "           *** TAMAT HARI ***", 0, $y);
$y += 50;
#printer_draw_text($handle, "           $today_full", 0, $y);
$y += 50;
#printer_draw_text($handle, "ADALAH DISAHKAN JUMLAH YANG DISERAHKAN", 0, $y);
$y += 25;
#printer_draw_text($handle, "UNTUK DIBANK-IN ADALAH SAMA DENGAN", 0, $y);
$y += 25;
#printer_draw_text($handle, "JUMLAH PADA LAPORAN KUTIPAN", 0, $y);
$y += 50;
#printer_draw_text($handle, "                  ......................", 0, $y);
$y += 25;
#printer_draw_text($handle, "                  (                    )", 0, $y);
$y += 50;
#printer_draw_text($handle, "DISEMAK DAN DISAHKAN", 0, $y);
$y += 50;
#printer_draw_text($handle, "                  ......................", 0, $y);
$y += 25;
#printer_draw_text($handle, "                  (                    )", 0, $y);

#printer_delete_font($font);
#printer_end_page($handle);
#printer_end_doc($handle);
#printer_close($handle);

$objAURECASH = new Aurecash();
$objAURECASH->depgrp = $kumpulan;
$objAURECASH->ttynum = $terminal;
$objAURECASH->oprnum = $operator;
$objAURECASH->delete();

//====================PLMIS===============================

//PLMIS BILLTRANR & COMPOUND_R
$sql4a = "SELECT a.RCP_AMT RCP_AMT, a.RCP_NUM RCP_NUM, DATE_FORMAT(a.RCP_DTE,'%d/%m/%Y') RCP_DTE, a.MDU_ACC, a.DES_MDU, a.DES_REF
FROM (AURELINE a, AURERECP b) 
WHERE a.DEP_GRP = b.DEP_GRP AND
a.TTY_NUM = b.TTY_NUM AND
a.RCP_DTE = b.RCP_DTE AND 
a.RCP_NUM = b.RCP_NUM AND
a.MOD_OPR = b.OPR_NUM AND
b.DEP_GRP = '$kumpulan' AND
b.TTY_NUM = '$terminal' AND
b.OPR_NUM = '$operator' AND
b.VOD_STU = 'N' AND 
b.RCP_DTE = STR_TO_DATE('$date','%d/%m/%Y')";
$s4a = db_query ( $sql4a );
while ( $row4a = db_fetch_array ( $s4a ) ) {
	$rcp_num = $row4a ['RCP_NUM'];
	$rcp_amt = $row4a ['RCP_AMT'];
	$rcp_dte = $row4a ['RCP_DTE'];
	$mdu_acc = $row4a ['MDU_ACC'];
	$mdu_ref = ($row4a ['DES_MDU']) ? "AND BILL_TYP='".$row4a ['DES_MDU']."'" : "";
	$des_ref = $row4a ['DES_REF'];

	//get total outstanding foreach account
	$sql4a1 = "SELECT SYS_ID, OS_AMT OS_AMT FROM AUREALLOC WHERE ACCT_NO='$mdu_acc' $mdu_ref AND BILL_NO='$des_ref'";
	$s4a1 = db_query ( $sql4a1 );
	while ( $row4a1 = db_fetch_array ( $s4a1 ) ) {
		$sys_id = $row4a1 ['SYS_ID'];
		$os_amt = $row4a1 ['OS_AMT'];
		$amtR = $os_amt - $rcp_amt;

		if ($sys_id == "PAS" || $sys_id == "PRS") {
			$objBILLTRANR = new Billtranr();
			$objBILLTRANR->acctno = $mdu_acc;
			$objBILLTRANR->billno = $des_ref;
			$objBILLTRANR->ramt = $amtR;
			$objBILLTRANR->insert();
		} else if ($sys_id == "CMP") {
			$objCOMPOUNDR = new Compoundr();
			$objCOMPOUNDR->mduacc = $mdu_acc;
			$objCOMPOUNDR->datercpt = $rcp_dte;
			$objCOMPOUNDR->rcptamt = $rcp_amt;
			$objCOMPOUNDR->rcptno = $rcp_num;
			$objCOMPOUNDR->insert();
		}
	}
}

//integration to PLMIS - aureline,aurerecp,aurepymt to paytran_a,paytran_d,paytran_m
$sql4 = "SELECT b.DEP_GRP,e.MDU_REF,DATE_FORMAT(b.RCP_DTE,'%d/%m/%Y') RCP_DTE,b.RCP_NUM,e.CUS_ID,a.MDU_ACC,f.OS_AMT-a.RCP_AMT OS_AMT,SUM(a.RCP_AMT) RCP_AMT,SUM(f.OS_AMT) total_bill
FROM (AURELINE a, AURERECP b, AUREPYMT c) 
JOIN AUREOPIT e ON a.MDU_ACC = e.MDU_ACC
JOIN AUREALLOC f ON a.MDU_ACC = f.ACCT_NO AND (a.DES_REF = f.BILL_NO OR f.BILL_NO IS NULL) AND (a.DES_MDU = f.BILL_TYP OR f.BILL_TYP IS NULL) AND (a.RCP_AD4=f.BILL_DTE OR a.RCP_AD4 IS NULL)
WHERE a.DEP_GRP = b.DEP_GRP AND
a.TTY_NUM = b.TTY_NUM AND
a.RCP_DTE = b.RCP_DTE AND 
a.RCP_NUM = b.RCP_NUM AND
a.MOD_OPR = b.OPR_NUM AND
b.DEP_GRP = c.DEP_GRP AND
b.TTY_NUM = c.TTY_NUM AND
b.RCP_DTE = c.RCP_DTE AND 
b.RCP_NUM = c.RCP_NUM AND 
b.OPR_NUM = c.MOD_OPR AND
b.DEP_GRP = '$kumpulan' AND
b.TTY_NUM = '$terminal' AND
b.OPR_NUM = '$operator' AND
b.VOD_STU = 'N' AND 
b.RCP_DTE = STR_TO_DATE('$date','%d/%m/%Y')
GROUP BY a.RCP_NUM";
$s4 = db_query ( $sql4 );
while ( $row4 = db_fetch_array ( $s4 ) ) {
	$dep_grp = $row4 ['DEP_GRP'];
	$sys_id = $row4 ['MDU_REF'];
	$rcp_dte = $row4 ['RCP_DTE'];
	$rcp_num = $row4 ['RCP_NUM'];
	$cus_id = $row4 ['CUS_ID'];
	$mdu_acc = $row4 ['MDU_ACC'];
	$os_amt = $row4 ['OS_AMT'];
	$rcp_amt = $row4 ['RCP_AMT'];
	$total_bill = $row4 ['total_bill'];
	$overpymt_amt = (($rcp_amt - $total_bill) > 0 ) ? $rcp_amt - $total_bill : 0;

	if ($rcp_amt == 0) {
		$topaid_amt = 0;
	} else if ($os_amt != 0) {
		$topaid_amt = $os_amt;
	}

	//paytran_a only for PAS & PRS
	if ($sys_id == 'PRS' || $sys_id == 'PAS') {
		$objPAYTRANA = new Paytrana();
		$objPAYTRANA->centercode = $dep_grp;
		$objPAYTRANA->systemid = $sys_id;
		$objPAYTRANA->txdate = $rcp_dte;
		$objPAYTRANA->rcptno = $rcp_num;
		$objPAYTRANA->personid = $cus_id;
		$objPAYTRANA->acctno = $mdu_acc;
		$objPAYTRANA->osamt = $os_amt;
		$objPAYTRANA->paidamt = $rcp_amt;
		$objPAYTRANA->status = 'N';
		$objPAYTRANA->discamt = 0;
		$objPAYTRANA->overpymtamt = $overpymt_amt;
		$objPAYTRANA->topaidamt = $topaid_amt;
		$objPAYTRANA->rdamt = 0;
		$objPAYTRANA->remitamt = 0;
		$objPAYTRANA->insert();
	}
}

$sql4b = "SELECT b.RCP_NUM,a.MDU_ACC,f.BILL_TYP TX_TYPE,a.RCP_AMT,a.RCP_AD4,b.OPR_NUM,c.CRE_DTE_TME,e.MDU_REF SYS_ID,b.DEP_GRP,DATE_FORMAT(b.RCP_DTE,'%d/%m/%Y') RCP_DTE,f.OS_AMT total_bill,f.BILL_NO
	FROM (AURELINE a, AURERECP b, AUREPYMT c) 
	JOIN aureopit e ON a.MDU_ACC = e.MDU_ACC
	JOIN aurealloc f ON a.MDU_ACC = f.ACCT_NO AND a.DES_REF = f.BILL_NO AND a.DES_MDU = f.BILL_TYP AND a.RCP_AD4=f.BILL_DTE
	WHERE a.DEP_GRP = b.DEP_GRP AND
	a.TTY_NUM = b.TTY_NUM AND
	a.RCP_DTE = b.RCP_DTE AND
	a.RCP_NUM = b.RCP_NUM AND
	a.MOD_OPR = b.OPR_NUM AND
	b.DEP_GRP = c.DEP_GRP AND
	b.TTY_NUM = c.TTY_NUM AND
	b.RCP_DTE = c.RCP_DTE AND
	b.RCP_NUM = c.RCP_NUM AND
	b.OPR_NUM = c.MOD_OPR AND
	b.DEP_GRP = '$kumpulan' AND
	b.TTY_NUM = '$terminal' AND
	b.OPR_NUM = '$operator' AND
	b.VOD_STU = 'N' AND
	b.RCP_DTE = STR_TO_DATE('$date','%d/%m/%Y')";
$s4b = db_query ( $sql4b );
while ( $row4b = db_fetch_array ( $s4b ) ) {

	$rcp_num = $row4b ['RCP_NUM'];
	$mdu_acc = $row4b ['MDU_ACC'];
	$tx_type = $row4b ['TX_TYPE'];
	$rcp_amt = $row4b ['RCP_AMT'];
	$opr_num = $row4b ['OPR_NUM'];
	$cre_dte_tme = $row4b ['CRE_DTE_TME'];
	$sys_id = $row4b ['SYS_ID'];
	$dep_grp = $row4b ['DEP_GRP'];
	$rcp_dte = $row4b ['RCP_DTE'];
	$rcp_ad4 = $row4b ['RCP_AD4'];  //bill_date
	$total_bill = $row4b ['total_bill'];
	$billno = addslashes($row4b ['BILL_NO']);
	$overpymt_amt = (($rcp_amt - $total_bill) > 0 ) ? $rcp_amt - $total_bill : 0;
	$arrRcpAd4 = ($rcp_ad4) ? explode("-", $rcp_ad4):"";
	$strRcpAd4 = ($rcp_ad4) ? $arrRcpAd4[2] . "/" . $arrRcpAd4[1] . "/" . $arrRcpAd4[0] : "";

	//paytran_a only for PAS & PRS
	if ($sys_id == 'PRS' || $sys_id == 'PAS') {
		$objPAYTRAND = new Paytrand();
		$objPAYTRAND->rcptno = $rcp_num;
		$objPAYTRAND->acctno = $mdu_acc;
		$objPAYTRAND->txtype = $tx_type;
		$objPAYTRAND->txno = $billno;
		$objPAYTRAND->payamount = $rcp_amt;
		$objPAYTRAND->idstamp = $opr_num;
		$objPAYTRAND->systemid = $sys_id;
		$objPAYTRAND->targetid = 'LBU';
		$objPAYTRAND->centercode = $dep_grp;
		$objPAYTRAND->txdate = $rcp_dte;
		$objPAYTRAND->billdate = $strRcpAd4;
		$objPAYTRAND->discamt = 0;
		$objPAYTRAND->overpymtamt = $overpymt_amt;
		$objPAYTRAND->insert();
	}
}

$sql4c = "SELECT
	b.DEP_GRP,b.TTY_NUM,
	DATE_FORMAT(b.RCP_DTE,'%d/%m/%Y') RCP_DTE,b.RCP_NUM,c.PAY_TYP,
	c.PAY_REF,c.RCP_AMT,a.RCP_DSC,
	a.DES_MDU,b.OPR_NUM,c.CRE_DTE_TME,
	f.MDU_REF SYS_ID,'LBU', 
	b.OPR_NUM,a.SRL_NO,c.DRW_NME,
	a.MDU_ACC,c.BNK_BSB,g.OS_AMT total_bill,f.CUS_ID CUS_ID,g.LIC_TYP,h.DEP_NUM
	FROM (AURELINE a, AURERECP b, AUREPYMT c)
	JOIN AUREOPIT f ON a.MDU_ACC = f.MDU_ACC
	JOIN AUREALLOC g ON a.MDU_ACC = g.ACCT_NO AND (a.DES_REF = g.BILL_NO OR g.BILL_NO IS NULL) AND (a.RCP_AD4=g.BILL_DTE OR a.RCP_AD4 IS NULL)
	JOIN AUREBANK h ON h.RCP_NUM=a.RCP_NUM AND a.DEP_GRP = h.DEP_GRP AND a.TTY_NUM = h.TTY_NUM AND a.RCP_DTE = h.RCP_DTE
	WHERE a.DEP_GRP = b.DEP_GRP AND
	a.TTY_NUM = b.TTY_NUM AND
	a.RCP_DTE = b.RCP_DTE AND
	a.RCP_NUM = b.RCP_NUM AND
	a.MOD_OPR = b.OPR_NUM AND
	b.DEP_GRP = c.DEP_GRP AND
	b.TTY_NUM = c.TTY_NUM AND
	b.RCP_DTE = c.RCP_DTE AND
	b.RCP_NUM = c.RCP_NUM AND
	b.OPR_NUM = c.MOD_OPR AND
	b.DEP_GRP = '$kumpulan' AND
	b.TTY_NUM = '$terminal' AND
	b.OPR_NUM = '$operator' AND
	b.VOD_STU = 'N' AND
	b.RCP_DTE = STR_TO_DATE('$date','%d/%m/%Y')
	GROUP BY a.RCP_NUM";
$s4c = db_query ( $sql4c );
while ( $row4c = db_fetch_array ( $s4c ) ) {

	$dep_grp = $row4c ['DEP_GRP'];
	$tty_num = $row4c ['TTY_NUM'];
	$rcp_dte = $row4c ['RCP_DTE'];
	$rcp_num = $row4c ['RCP_NUM'];
	$pay_typ = $row4c ['PAY_TYP'];
	$pay_ref = $row4c ['PAY_REF'];
	$drw_nme = $row4c ['DRW_NME'];
	$rcp_amt = $row4c ['RCP_AMT'];
	$rcp_dsc = $row4c ['RCP_DSC'];
	$mdu_ref = $row4c ['DES_MDU'];
	$strMduRef = ($row4c ['DES_MDU'])?"BILL_TYP='$mdu_ref'" : "(BILL_TYP='' OR BILL_TYP IS NULL)";
	$opr_num = $row4c ['OPR_NUM'];
	$cre_dte_tme = $row4c ['CRE_DTE_TME'];
	$total_bill = $row4c ['total_bill'];
	$lictyp = $row4c ['LIC_TYP'];
	$overpymt_amt = (($rcp_amt - $total_bill) > 0 ) ? $rcp_amt - $total_bill : 0;
	$sys_id = $row4c ['SYS_ID'];
	$cus_id = $row4c ['CUS_ID'];
	$mdu_acc = $row4c ['MDU_ACC'];
	$bnk_bsb = $row4c ['BNK_BSB'];
	$srl_no = $row4c ['SRL_NO'];
	$dep_num = $row4c ['DEP_NUM'];

	//we cannot join aurealloc table to get the lic_typ as there will be duplicate acct no in aurealloc for LIS
	$lic = '';
	if ($sys_id == "LIS") {
		$objAUREALLOC = new Aurealloc();
		$objAUREALLOC->acctno = $mdu_acc;
		$objAUREALLOC->specialWhere = $strMduRef;
		$objAUREALLOC->select();
		$lictyp = $objAUREALLOC->billtyp;
		$lic = $objAUREALLOC->lictyp;
	}

	$cmp_id = '';
	$cmp_ref = '';
	if ($sys_id == "CMP") {
		$objAUREALLOC = new Aurealloc();
		$objAUREALLOC->acctno = $mdu_acc;
		$objAUREALLOC->select();
		$cmp_id = $objAUREALLOC->billno;

		$cmp_ref = $mdu_acc;

		//trim mdu_acc
		$cmp_ref = str_replace(" NO. ", "", $cmp_ref);
		$cmp_ref = str_replace("NO. ", "", $cmp_ref);
		$mdu_acc = '';  //blank acct_no for CMP
	}

	if ($sys_id == "LIS" && $lic == "T") {
	} else {
		$objPAYTRANM = new Paytranm();
		$objPAYTRANM->centercode = $dep_grp;
		$objPAYTRANM->counterno = $tty_num;
		$objPAYTRANM->rcptfrom = $drw_nme;
		$objPAYTRANM->txdate = $rcp_dte;
		$objPAYTRANM->rcptno = $rcp_num;
		$objPAYTRANM->paymenttype = $pay_typ;
		$objPAYTRANM->paymentref = $dep_num;
		$objPAYTRANM->totalamount = $rcp_amt;
		$objPAYTRANM->remarks = $rcp_dsc;
		$objPAYTRANM->rcptref = $srl_no;
		$objPAYTRANM->idstamp = $opr_num;
		$objPAYTRANM->overpymt = $overpymt_amt;
		$objPAYTRANM->systemid = $sys_id;
		$objPAYTRANM->targetid = 'LBU';
		$objPAYTRANM->tellerid = $opr_num;
		$objPAYTRANM->lictype = $lictyp;
		$objPAYTRANM->license = $lic;
		$objPAYTRANM->personid = $cus_id;
		$objPAYTRANM->acctno = $mdu_acc;
		$objPAYTRANM->bankcode = $bnk_bsb;
		$objPAYTRANM->voidind = 'N';
		$objPAYTRANM->cardno = $pay_ref;
		$objPAYTRANM->ototalamount = $rcp_amt;
		$objPAYTRANM->rtotalamount = $rcp_amt;
		$objPAYTRANM->cpdid = $cmp_id;
		$objPAYTRANM->cpdreference = $cmp_ref;
		$objPAYTRANM->recordid = '0.00';
		$objPAYTRANM->insert();
	}
}

$objAURERECP = new Aurerecp();
$objAURERECP->depgrp = $kumpulan;
$objAURERECP->ttynum = $terminal;
$objAURERECP->oprnum = $operator;
$objAURERECP->rcpdte = $date;
$objAURERECP->balflg = 'Y';
$objAURERECP->update();

$objAURETERM = new Aureterm();
$objAURETERM->actflg = 'N';
$objAURETERM->depgrpori = $kumpulan;
$objAURETERM->ttynumori = $terminal;
$objAURETERM->rcpdteori = $rcp_dte;
$objAURETERM->update();

?>
