<?php

include_once 'header.php';

$kumpulan = $_SESSION ['kumpulan'];

?>
<title><?=$sys_name?> - <?=$strStartDate?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	//navigation button
	loadNaviButton();
	loadDisabledField();
});

//make enter key behave like tab key
$('input').live('keydown', function(e) {
	if (e.keyCode == 13 || e.keyCode == 9) {
		e.preventDefault();
		var id = this.id;
		if ( id == "kumpulan" ) {
			if (validate() == true) {	
				$("#tarikh").select();
			} 
		} else if ( id == "tarikh" ) {
			$("#kumpulan").select();
		}
	}
});

//load navigation button
function loadNaviButton () {
	var action = $('#action').val();

	//if got data, enable navigation button
	if (action == 'data') {
		$('#btnNavi1').attr("disabled", false);
		$('#btnNavi2').attr("disabled", false);
		$('#btnNavi3').attr("disabled", false);
		$('#btnNavi4').attr("disabled", false);
		$('#btnNavi5').attr("disabled", false);
		$('#btnNavi6').attr("disabled", false);
		$('#divTotal').show();
	} else {
		$('#btnNavi1').attr("disabled", true);
		$('#btnNavi2').attr("disabled", true);
		$('#btnNavi3').attr("disabled", true);
		$('#btnNavi4').attr("disabled", true);
		$('#btnNavi5').attr("disabled", true);
		$('#btnNavi6').attr("disabled", true);
		$('#divTotal').hide();
	}
}

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search,add,modify only
	if (action == 'search' || action == 'add') {
		$('#kumpulan').attr("disabled", false);
		$('#kumpulan_desc').attr("disabled", false);
		$('#btnSearchKumpulan').attr("onclick", "loadSearchKumpulan()");
		$('#tarikh').attr("disabled", false);
		$("#tarikh").datepicker({dateFormat:'dd/mm/yy'});
	} else if (action == 'modify') {
		$('#kumpulan').attr("disabled", true);
		$('#kumpulan_desc').attr("disabled", true);
		$('#btnSearchKumpulan').attr("onclick", "");
		$('#tarikh').attr("disabled", false);
		$("#tarikh").datepicker({dateFormat:'dd/mm/yy'});
	} else {
		$('#kumpulan').attr("disabled", true);
		$('#kumpulan_desc').attr("disabled", true);
		$('#btnSearchKumpulan').attr("onclick", "");
		$('#tarikh').attr("disabled", true);
		$("#tarikh").datepicker('destroy');
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'search') {
		var kumpulan = $('#kumpulan').val();
		var tarikh = $('#tarikh').val();

		$.post("tarikhpermulaanhari_search.php", {
			kumpulan: kumpulan, 
			tarikh: tarikh 
			}, function(data) {
				if (data.total > 0) {
					$('#divTotal').val('1 dari ' + data.total);
					
					//load data
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", false);
					$('#btnDelete').attr("disabled", false);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("data");
					$('#totaldata').val(data.total);
					$('#strwhere').val(data.strwhere);
					loadNaviButton();
					loadDisabledField();

					//now load the data
					loaddata();
				} else {
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("");
					loadNaviButton();
					loadDisabledField();

					$('#divTotal').show();
					$('#divTotal').val('Tiada Rekod Dipilih');
				}
		}, "json");
	}

	//do add
	if (action == 'add') {
		var kumpulan = $('#kumpulan').val();
		var tarikh = $('#tarikh').val();

		var gotErr = 0;
		if (kumpulan == "") {
			alert("Sila masukkan Pusat Kutipan");
			gotErr = 1;
			$("#kumpulan").focus();
		} else if (tarikh == "") {
			alert("Sila masukkan Tarikh Penerimaan");
			gotErr = 1;
			$("#tarikh").focus();
		}

		if (gotErr == 0) {
			$.post("validate_pusatkutipan.php", {
				kod: kumpulan 
				}, function(data) {
					if (data == 0){
						alert("Pusat Kutipan tidak wujud.");
						gotErr = 1;
						$("#kumpulan").select();
					} else {
						$.post("tarikhpermulaanhari_add.php", {
							kumpulan: kumpulan, 
							tarikh: tarikh 
							}, function(data) {
								if (data > 0) {
									alert('Rekod telah wujud.');
								} else {
									$('#action').val("");
									loadNaviButton();
									loadDisabledField();
						
									$('#btnOk').attr("disabled", true);
									$('#btnCancel').attr("disabled", true);
									$('#btnAdd').attr("disabled", false);
									$('#btnModify').attr("disabled", false);
									$('#btnDelete').attr("disabled", false);
									$('#btnSearch').attr("disabled", false);

									var depgrp = data.depgrp;
									var rcpdte = data.rcpdte;
									var ttynum = data.ttynum;
									var oprnum = data.oprnum;
									var oprname = data.oprname;

									var arrttynum = ttynum.split('|');
									var arroprnum = oprnum.split('|');
									var arroprname = oprname.split('|');

									var i = 0;
									var txt = 'Juruwang telah ditambah seperti berikut: \n\n';
									txt += 'Pusat Kutipan : ' + depgrp + '\n';
									txt += 'Tarikh Kutipan : ' + rcpdte + '\n';
									jQuery.each(arrttynum, function() {
										txt += '\nKaunter : ' + arrttynum[i] + '   Juruwang : ' + arroprnum[i] + ' (' + arroprname[i] + ')';
										i++;
									});
									alert(txt);
								}
							}, "json");	
					} 
			});
		}
	}
	
	//do modify
	if (action == 'modify') {
		var kumpulan_ori = $('#mod_kumpulan').val();
		var tarikh_ori = $('#mod_tarikh').val();
		var kumpulan = $('#kumpulan').val();
		var tarikh = $('#tarikh').val();

		var gotErr = 0;
		if (kumpulan == "") {
			alert("Sila masukkan Pusat Kutipan");
			gotErr = 1;
			$("#kumpulan").focus();
		} else if (tarikh == "") {
			alert("Sila masukkan Tarikh Penerimaan");
			gotErr = 1;
			$("#tarikh").focus();
		}

		if (gotErr == 0) {
			$.post("validate_pusatkutipan.php", {
				kod: kumpulan 
				}, function(data) {
					if (data == 0){
						alert("Pusat Kutipan tidak wujud.");
						gotErr = 1;
						$("#kumpulan").select();
					} else {
							$.post("tarikhpermulaanhari_modify.php", {
								kumpulan_ori: kumpulan_ori, 
								tarikh_ori: tarikh_ori, 
								kumpulan: kumpulan, 
								tarikh: tarikh 
								}, function(data) {
									if (data > 0) {
										alert('Rekod telah wujud.');
									} else {
										$('#action').val("");
										loadNaviButton();
										loadDisabledField();
							
										$('#btnOk').attr("disabled", true);
										$('#btnCancel').attr("disabled", true);
										$('#btnAdd').attr("disabled", false);
										$('#btnModify').attr("disabled", false);
										$('#btnDelete').attr("disabled", false);
										$('#btnSearch').attr("disabled", false);
									}
								});	
					} 
			});
		}
	}
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadNaviButton();
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click add
function doAdd () {
	$('#action').val("add");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	resetAllField();
	$('#kumpulan').focus();
	$('#kumpulan').val('<?=$kumpulan;?>');

	//if ada kumpulan, refresh nama kumpulan
	if ('<?=$kumpulan?>') {
		refreshKumpulan();
	}

	//default date is today
	$('#tarikh').val('<?=date ( "d/m/Y" );?>');
}

//when click modify
function doModify () {
	$('#action').val("modify");
	loadNaviButton();
	loadDisabledField();

	//store current value
	$('#mod_kumpulan').val($('#kumpulan').val());
	$('#mod_tarikh').val($('#tarikh').val());
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	$('#kumpulan').focus();
}

//when click delete
function doDelete () {
	if (confirm('Adakah anda pasti untuk hapuskan rekod ini?')) {
		var kumpulan = $('#kumpulan').val();
		var tarikh = $('#tarikh').val();
		$.post("tarikhpermulaanhari_delete.php", {
			kumpulan: kumpulan, 
			tarikh: tarikh 
			}, function(data) {
				if (data.total > 0) {
					alert('<?=$strRecordLock?>');
				} else {
					$('#action').val("");
					$('#currentdata').val("1");
					
					loadNaviButton();
					loadDisabledField();
					resetAllField();

					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);
				}
		}, "json");
	} else {
	}	
}

//when click search
function search () {
	$('#action').val("search");
	$('#currentdata').val("1");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	resetAllField();
	
	$('#kumpulan').focus();
}

//load data to page
function loaddata () {
	var currentdata = $('#currentdata').val();
	var strwhere = $('#strwhere').val();
	$.post("tarikhpermulaanhari_search.php?getdata=1&currentdata=" + currentdata + "&strwhere=" + strwhere, {
		}, function(data) {
			var kumpulan = data.kumpulan;
			var kumpulan_desc = data.kumpulan_desc;
			var tarikh = data.tarikh;
			var createdate = data.createdate;
			var modifydate = data.modifydate;
			var operator = data.operator;
			var operatorname = data.operatorname;

			$('#kumpulan').val(kumpulan);
			$('#kumpulan_desc').val(kumpulan_desc);
			$('#tarikh').val(tarikh);
			$('#createdate').val(createdate);
			$('#modifydate').val(modifydate);
			$('#modoperator').val(operator);
			$('#modoperatorname').val(operatorname);
		}, "json");
}

//when click next navigation
function datanavinext () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev navigation
function datanaviprev () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click next 10 navigation
function datanavinext10 () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 10;
		if (currentdata > $('#totaldata').val()) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev 10 navigation
function datanaviprev10 () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 10;
		if (currentdata < 1) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click last navigation
function datanavilast () {
	var currentdata = $('#totaldata').val();
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click first navigation
function datanavifirst () {
	var currentdata = 1;
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

function resetAllField () {
	//reset all field
	$('#kumpulan').val("");
	$('#kumpulan_desc').val("");
	$('#tarikh').val("");
	$('#createdate').val("");
	$('#modifydate').val("");
	$('#modoperator').val("");
	$('#modoperatorname').val("");
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulan.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: 'Pusat Kutipan', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		var kumpulan = $("#kumpulan").val();
		$.post("refresh_kumpulan.php", {
			kumpulan: kumpulan 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function validate () {
	var kod = $("#kumpulan").val();
	var action = $("#action").val();

	if (action == "add" || action == "modify") {
		$.post("validate_pusatkutipan.php", {
			kod: kod 
			}, function(data) {
				if (data == 0){
					alert("Pusat Kutipan tidak wujud.");
					$("#kumpulan").select();
					return false;
				} else {
					refreshKumpulan();
					$("#tarikh").select();
					return true;
				} 
		});
	} else {
		return true;
	}
}

function doList () {
	location.href='tarikhpermulaanhari_list.php';
}

</script>
<br>
<input type="hidden"
	id="action" value="">
<input type="hidden"
	id="currentdata" value="1">
<input type="hidden"
	id="totaldata" value="0">
<input type="hidden"
	id="strwhere" value="0">
<input type="hidden"
	id="mod_kumpulan" value="">
<input type="hidden"
	id="mod_tarikh" value="">

<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strStartDate?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_all.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_navi.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td nowrap="nowrap"><?=$strDepGrp?></td>
				<td><input type="text" id="kumpulan" name="kumpulan" size="10"
					style="text-transform: uppercase" /><img src="image/search.gif" id="btnSearchKumpulan"
					onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kumpulan_desc" name="kumpulan_desc" size="50" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiveDate?></td>
				<td><input type="text" id="tarikh" name="tarikh" size="10" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_createdby.php';?></td>
		<td></td>
	</tr>
</table>
<div id="divSearchKumpulan" title=""></div>
<?php include_once 'footer.php';?>