<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Courier','',8);

$operator = $_GET ['operator'];
$kumpulan = strtoupper($_GET ['kumpulan']);
$terminal = $_GET ['terminal'];
$resit = $_GET ['resit'];
$cek = $_GET ['cek'];
$akaun = $_GET ['akaun'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$operator_name = re_getfullname ( $operator );

$strWhere = ($operator) ? " AND AURERECP.OPR_NUM='$operator'" : "";
$strWhere .= ($kumpulan) ? " AND AURERECP.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND AURERECP.TTY_NUM='$terminal'" : "";
$strWhere .= ($resit) ? " AND AURERECP.RCP_NUM ='$resit'" : "";
$strWhere .= ($cek) ? " AND AUREPYMT.PAY_REF ='$cek'" : "";
$strWhere .= ($akaun) ? " AND AURELINE.MDU_ACC ='$akaun'" : "";
if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND AURERECP.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}
$strWhere .= " GROUP BY AURERECP.RCP_NUM,AURERECP.DEP_GRP,AURERECP.TTY_NUM,AURERECP.OPR_NUM,AURERECP.RCP_DTE
ORDER BY AURERECP.RCP_NUM";

$today = date ( 'Ymd' );

//select all bil except void
$sql = "SELECT AURERECP.RCP_NUM,AURERECP.DEP_GRP,AURERECP.TTY_NUM,AURERECP.RCP_AMT,AURERECP.CHN_AMT,AURERECP.VOD_STU,AURERECP.VOD_RCP,AURERECP.RCP_NM2,AURERECP.SEQ_TO,
DATE_FORMAT( AURERECP.RCP_DTE, '%d-%m-%Y' ) AS aurerecp_rcpdte,
DATE_FORMAT( AURELINE.CRE_DTE_TME, '%H:%i:%s' ) AS aureline_credtetme,
DATE_FORMAT( AUREPYMT.CRE_DTE_TME, '%d-%m-%Y %H:%i:%s' ) AS aurepymt_credtetme,
DATE_FORMAT( AUREPYMT.CRE_DTE_TME, '%H:%i:%s' ) AS aurepymt_time,
AURELINE.MDU_ACC
FROM AURERECP,AURELINE,AUREPYMT
WHERE 1=1
AND AURERECP.RCP_NUM=AURELINE.RCP_NUM
AND AURERECP.RCP_NUM=AUREPYMT.RCP_NUM
AND AURERECP.DEP_GRP=AURELINE.DEP_GRP
AND AURERECP.DEP_GRP=AUREPYMT.DEP_GRP
AND AURERECP.TTY_NUM=AURELINE.TTY_NUM
AND AURERECP.TTY_NUM=AUREPYMT.TTY_NUM
AND AURERECP.RCP_DTE=AURELINE.RCP_DTE
AND AURERECP.RCP_DTE=AUREPYMT.RCP_DTE
AND AURERECP.OPR_NUM=AURELINE.MOD_OPR
AND AURERECP.OPR_NUM=AUREPYMT.MOD_OPR
$strWhere";

$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$rcp_num = $row ['RCP_NUM'];

	$arrRcp[$rcp_num]['DEP_GRP'] = $row ['DEP_GRP'];
	$arrRcp[$rcp_num]['TTY_NUM'] = $row ['TTY_NUM'];
	$arrRcp[$rcp_num]['RCP_AMT'] = $row ['RCP_AMT'];
	$arrRcp[$rcp_num]['CHN_AMT'] = $row ['CHN_AMT'];
	$arrRcp[$rcp_num]['VOD_STU'] = $row ['VOD_STU'];
	$arrRcp[$rcp_num]['VOD_RCP'] = $row ['VOD_RCP'];
	$arrRcp[$rcp_num]['RCP_NM2'] = $row ['RCP_NM2'];
	$arrRcp[$rcp_num]['SEQ_TO'] = $row ['SEQ_TO'];
	$arrRcp[$rcp_num]['RCP_DTE'] = $row ['aurerecp_rcpdte'];
	$arrRcp[$rcp_num]['VOD_TIME'] = $row ['aureline_credtetme'];
	$arrRcp[$rcp_num]['CREDTETME'] = $row ['aurepymt_credtetme'];
	$arrRcp[$rcp_num]['TIME'] = $row ['aurepymt_time'];
	$arrRcp[$rcp_num]['MDU_ACC'] = $row ['MDU_ACC'];
}

//select all void bil
$sql_void = "SELECT AURERECP.RCP_NUM,AURERECP.DEP_GRP,AURERECP.TTY_NUM,AURERECP.RCP_AMT,AURERECP.CHN_AMT,AURERECP.VOD_STU,AURERECP.VOD_RCP,AURERECP.RCP_NM2,AURERECP.SEQ_TO,
DATE_FORMAT( AURERECP.RCP_DTE, '%d-%m-%Y' ) AS aurerecp_rcpdte,
DATE_FORMAT( AURELINE.CRE_DTE_TME, '%H:%i:%s' ) AS aureline_credtetme,
AURELINE.MDU_ACC
FROM AURERECP,AURELINE
WHERE 1=1
AND AURERECP.RCP_NUM=AURELINE.RCP_NUM
AND AURERECP.DEP_GRP=AURELINE.DEP_GRP
AND AURERECP.TTY_NUM=AURELINE.TTY_NUM
AND AURERECP.RCP_DTE=AURELINE.RCP_DTE
AND AURERECP.OPR_NUM=AURELINE.MOD_OPR
AND AURERECP.VOD_STU='V'
$strWhere";

$s = ($online == "1") ? db_query_server($sql_void) : db_query($sql_void);
while ( $row = db_fetch_array ( $s ) ) {
	$rcp_num = $row ['RCP_NUM'];

	$arrRcp[$rcp_num]['DEP_GRP'] = $row ['DEP_GRP'];
	$arrRcp[$rcp_num]['TTY_NUM'] = $row ['TTY_NUM'];
	$arrRcp[$rcp_num]['RCP_AMT'] = $row ['RCP_AMT'];
	$arrRcp[$rcp_num]['CHN_AMT'] = $row ['CHN_AMT'];
	$arrRcp[$rcp_num]['VOD_STU'] = $row ['VOD_STU'];
	$arrRcp[$rcp_num]['VOD_RCP'] = $row ['VOD_RCP'];
	$arrRcp[$rcp_num]['RCP_NM2'] = $row ['RCP_NM2'];
	$arrRcp[$rcp_num]['SEQ_TO'] = $row ['SEQ_TO'];
	$arrRcp[$rcp_num]['RCP_DTE'] = $row ['aurerecp_rcpdte'];
	$arrRcp[$rcp_num]['VOD_TIME'] = $row ['aureline_credtetme'];
	$arrRcp[$rcp_num]['CREDTETME'] = "";
	$arrRcp[$rcp_num]['TIME'] = $row ['aurepymt_time'];
	$arrRcp[$rcp_num]['MDU_ACC'] = $row ['MDU_ACC'];
}

ksort($arrRcp);

//get same transaction bil based on rcp_dte to show total actual payment
$arrNewRcp = array_reverse($arrRcp, true);
foreach ($arrNewRcp as $curRcp => $v){
	$rcp_num = $curRcp;
	$arrRcp[$rcp_num]['LAST'] = "1";

	if ($v ['CREDTETME'] == $prevRcpDte) {
		$arrRcp[$rcp_num]['LAST'] = "0";
	} else {
		$arrRcp[$rcp_num]['LAST'] = "1";
	}
	$prevRcpDte = $v ['CREDTETME'];
}

foreach ($arrRcp as $curRcp => $v){

	$rcp_num = $curRcp;
	$rcp_num_pad = str_pad ( $rcp_num, 6, "0", STR_PAD_LEFT );
	$dep_grp = $v ['DEP_GRP'];
	$tty_num = $v ['TTY_NUM'];
	$strTtyNum = str_pad ( $tty_num, 2, "0", STR_PAD_LEFT );
	$rcp_amt = $v ['RCP_AMT'];
	$chn_amt = $v ['CHN_AMT'];
	$vod_stu = $v ['VOD_STU'];
	$vod_rcp = $v ['VOD_RCP'];
	$rcp_nm2 = $v ['RCP_NM2'];
	$rcp_dte_format = $v ['RCP_DTE'];
	$time = $v ['TIME'];
	$vod_time = $v ['VOD_TIME'];
	$mdu_acc = $v ['MDU_ACC'];
	$last = $v ['LAST'];

	//receipt batal
	$strMaklumatResit = ($vod_stu == "V") ? str_pad ( "RESIT BATAL", 24, " ", STR_PAD_LEFT ) : str_pad ( "MAKLUMAT RESIT", 24, " ", STR_PAD_LEFT );
	$strMaklumatResit = str_replace(" ", " ", $strMaklumatResit);

	$strSpaceStesen = str_pad ( "", 25 - ( 9 + strlen ($dep_grp) ), " ", STR_PAD_LEFT );
	$strSpaceStesen = str_replace(" ", " ", $strSpaceStesen);

	$rcp_num_ori = ($vod_stu == "V") ? $vod_rcp : $rcp_num;
	$rcp_num = ($vod_stu == "V") ? $vod_rcp : $rcp_num;

	//dont repeat header if same day transaction
	if ($dep_grp != $curDepGrp || $tty_num != $curTtyNum || $rcp_dte_format != $curRcpDte || $vod_stu == "V") {

		$pdf->Ln();
		$pdf->Ln();
		$pdf->Cell(5,3,"-----------------------------------");
		$pdf->Ln();
		$pdf->Cell(5,3,"$strMaklumatResit");
		$pdf->Ln();
		$pdf->Cell(5,3,"-----------------------------------");

		//dont show this if cancel receipt
		if ($vod_stu != "V") {

			$pdf->Ln();
			$pdf->Cell(5,3,"ID OPER. $operator $operator_name");
			$pdf->Ln();
			$pdf->Cell(5,3,"TARIKH   $rcp_dte_format");
			$pdf->Ln();
			$pdf->Cell(5,3,"STESEN   $dep_grp $strSpaceStesen MESIN $strTtyNum");

			$pg += 7;
			$strPage = ceil ($pg / 103);

			$strSpacePage = str_pad ( "", 34 - ( 13 + strlen ($strPage) ), " ", STR_PAD_LEFT );
			$strSpacePage = str_replace(" ", " ", $strSpacePage);

			$pdf->Ln();
			$pdf->Cell(5,3,"$strSpacePage MUKA SURAT : $strPage");

			$curDepGrp = $dep_grp;
			$curTtyNum = $tty_num;
			$curRcpDte = $rcp_dte_format;

			$pdf->Ln();
			$pdf->Cell(5,3,"-----------------------------------");
		}
	}

	$pdf->Ln();
	$pdf->Ln();

	if ($vod_stu == "V") {
		$rcp_num_ori = str_pad ( $rcp_num_ori, 6, '0', STR_PAD_LEFT );

		$pdf->Cell(5,3,"RESIT $rcp_num_ori $vod_time ID OPER. $operator");
		$pdf->Ln();
		$pdf->Cell(5,3,"NO.DOC BATAL $rcp_num_pad $vod_time ID OPER. $operator");
		$pdf->Ln();
		$pdf->Cell(5,3,"SEBAB $rcp_nm2");
	} else {
		$pdf->Ln();
		$pdf->Cell(5,3,"$rcp_num_pad   $operator   $strTtyNum   $time");
	}

	$pdf->Ln();
	$pdf->Cell(5,3,"A/K: $mdu_acc");
	$pdf->Ln();
	$pdf->Cell(5,3,"BIL:");

	$bil++;
	$pg += 4;
	$sql1 = "SELECT RCP_TYP,RCP_AMT + TAX_AMT AS RCP_AMT,DES_REF FROM AURELINE WHERE RCP_NUM='$rcp_num' AND DEP_GRP='$kumpulan' AND TTY_NUM='$terminal' AND MOD_OPR='$operator'";
	$s1 = ($online == "1") ? db_query_server($sql1) : db_query($sql1);
	while ( $row1 = db_fetch_array ( $s1 ) ) {
		$rcp_typ = $row1 ['RCP_TYP'];
		$rcp_typ_pad = str_pad ( $row1 ['RCP_TYP'], 5, "0", STR_PAD_LEFT );
		$rcp_amt = $row1 ['RCP_AMT'];
		$des_ref = $row1 ['DES_REF'];
		$tot_amt_kelompok += $rcp_amt;

		$amt = number_format ($rcp_amt,2);
		$strRm = str_pad ( "RM", 16 - strlen($rcp_typ_pad), " ", STR_PAD_LEFT );
		$strAmt = str_pad ( "$amt", 11, " ", STR_PAD_LEFT );

		$pdf->Ln();
		$pdf->Cell(5,3,"A/S: $des_ref");
		$pdf->Ln();
		$pdf->Cell(5,3,"Kod: $rcp_typ_pad $strRm $strAmt");

		$pg += 2;
	}

	$amtKelompok = number_format ($tot_amt_kelompok,2);
	$strRm = str_pad ( "RM", 15 - strlen($bil), " ", STR_PAD_LEFT );
	$strAmtKelompok = str_pad ( "$amtKelompok", 11, " ", STR_PAD_LEFT );

	if ($last == 1 || $vod_stu == "V") {
		$pdf->Ln();
		$pdf->Ln();
		$pdf->Cell(5,3,"BILG. $bil $strRm $strAmtKelompok");
	}

	$pg += 2;

	$sql2 = "SELECT PAY_TYP,SEQ_NUM,RCP_AMT,BNK_BSB,PAY_REF FROM AUREPYMT WHERE RCP_NUM='$rcp_num' AND DEP_GRP='$kumpulan' AND TTY_NUM='$terminal' AND MOD_OPR='$operator'";
	$s2 = ($online == "1") ? db_query_server($sql2) : db_query($sql2);
	while ( $row2 = db_fetch_array ( $s2 ) ) {
		$pay_typ = $row2 ['PAY_TYP'];
		$seq_num = $row2 ['SEQ_NUM'];
		$rcp_amt_pymt = $row2 ['RCP_AMT'];
		$bnk_bsb = $row2 ['BNK_BSB'];
		$pay_ref = $row2 ['PAY_REF'];

		//1=Tunai, 2=Cek, 3=Kad Kredit, 4=Wang Pos, 5=EFT, 6=Deraf Bank, 7=Slip Bank
		$strInfo = "";
		switch ($pay_typ) {
			case 1 :
				$strType = "TUNAI";
				break;
			case 2 :
				$strType = "CEK";
				$arrBnkBsb = explode("-",$bnk_bsb);
				$strBnkBsb = $arrBnkBsb[0];
				$strInfo = "NO. $strBnkBsb-$pay_ref";
				break;
			case 3 :
				$strType = "KAD KREDIT";
				$strInfo = "NO. $pay_ref";
				break;
			case 4 :
				$strType = "$pay_ref";
				#$strType = "WANG POS";
				#$strInfo = "NO. $pay_ref";
				break;
			case 5 :
				$strType = "EFT";
				$arrBnkBsb = explode("-",$bnk_bsb);
				$strBnkBsb = $arrBnkBsb[0];
				$strInfo = "NO. $strBnkBsb-$pay_ref";
				break;
			case 6 :
				$strType = "BANK DERAF";
				$arrBnkBsb = explode("-",$bnk_bsb);
				$strBnkBsb = $arrBnkBsb[0];
				$strInfo = "NO. $strBnkBsb-$pay_ref";
				break;
			case 7 :
				$strType = "SLIP BANK";
				$arrBnkBsb = explode("-",$bnk_bsb);
				$strBnkBsb = $arrBnkBsb[0];
				$strInfo = "NO. $strBnkBsb-$pay_ref";
				break;
			default :
				$strType = "TUNAI";
		}

		$tot_pymt += $rcp_amt_pymt;

		if ($vod_stu == "V") {
			$amt3 = number_format($tot_pymt,2);
		} else {
			$amt3 = number_format($tot_pymt + $chn_amt,2);
		}

		$strRm = str_pad ( "RM", 21 - strlen($strType), " ", STR_PAD_LEFT );
		$strAmt3 = str_pad ( "$amt3", 11, " ", STR_PAD_LEFT );

		if ($last == 1 || $vod_stu == "V") {
			$tot_amt_kelompok = 0;
			$bil = 0;

			if ($pay_typ == 4 && $seq_num == 1) {
				$pdf->Ln();
				$pdf->Cell(5,3,"WANG POS            RM $strAmtKelompok");
			}

			$pdf->Ln();
			$pdf->Cell(5,3,"$strType $strRm $strAmt3");
			$pg += 1;
		}

		if ($strInfo && $last == 1 || $vod_stu == "V") {
			if ($strInfo) {
				$pdf->Ln();
				$pdf->Cell(5,3,"$strInfo");
			}
			$pg += 1;
		}

		if ($last == 1 || $vod_stu == "V") {
			$tot_pymt = 0;  //reset tot_pymt for next transaction bil
		}
	}

	//receipt batal
	if ($vod_stu == "V") {
		$pdf->Ln();
		$pdf->Cell(5,3,"-----------------------------------");
		$pg += 3;
	}

	//balance
	if ($chn_amt > 0 && $vod_stu != "V") {

		$strRm = str_pad ( "RM", 17, " ", STR_PAD_LEFT );
		$strRm = str_replace(" ", " ", $strRm);

		$strAmtBaki = str_pad ( "(".number_format($chn_amt,2).")", 12, " ", STR_PAD_LEFT );
		$strAmtBaki = str_replace(" ", " ", $strAmtBaki);

		$pdf->Ln();
		$pdf->Cell(5,3,"BAKI $strRm $strAmtBaki");

		$pg += 1;
	}
	$pg += 1;
}

$pdf->Output("laporan_audit_rol_mengikut_resit_$today.pdf","D");
?>