<?php

include_once 'header.php';

?>
<title><?=$sys_name?> - <?=$strUpload?></title>
<script>

$(document).ready(function() {
	$('#divLoading').hide();
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	loadDisabledField();
});

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search only
	if (action == 'search') {
		$('#kumpulan').attr("readonly", false);
		$('#tty_num').attr("readonly", false);
		$('#key_num').attr("disabled", false);
		$('#rcp_dte').attr("readonly", false);
		$("#rcp_dte").datepicker({dateFormat:'dd/mm/yy'});
		$('#file').attr("disabled", false);
	} else {
		$('#kumpulan').attr("readonly", true);
		$('#tty_num').attr("readonly", true);
		$('#key_num').attr("disabled", true);
		$('#rcp_dte').attr("readonly", true);
		$("#rcp_dte").datepicker('destroy');
		$('#file').attr("disabled", true);
	}
}

//when click ok
function ok () {
	$('#divLoading').show();
	$('#form1').submit();
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click search
function search () {
	$('#action').val("search");
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnSearch').attr("disabled", true);

	$('#tty_num').val("99");
	$('#rcp_dte').val("<?=date('d/m/Y', time() - 60 * 60 * 24)?>");
}

function resetAllField () {
	//reset all field
	$('#kumpulan').val("");
	$('#kumpulan_desc').val("");
	$('#tty_num').val("");
	$('#rcp_dte').val("");
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		$.post("refresh_kumpulan.php", {
			kumpulan: $("#kumpulan").val() 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulanosp.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: 'Pusat Kutipan', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

</script>
<br>
<input type="hidden" id="action" value="">
<form id="form1" action="osp_import1.php" method="post"
	enctype="multipart/form-data">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strOSPImport?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_process.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td nowrap="nowrap" width="10%"><?=$strDepGrp?></td>
				<td width="90%"><input type="text" id="kumpulan" name="kumpulan"
					size="10" onblur="refreshKumpulan();"
					style="text-transform: uppercase" /><img id="btnSearchKumpulan"
					src="image/search.gif" onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"> <input type="text"
					id="kumpulan_desc" name="kumpulan_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap">Nombor Kaunter</td>
				<td><input type="text" id="tty_num" name="tty_num" size="10"></td>
			</tr>
			<tr>
				<td nowrap="nowrap">Tarikh Kutipan</td>
				<td><input type="text" id="rcp_dte" name="rcp_dte" size="10"></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td></td>
			</tr>
			<tr>
				<td nowrap="nowrap">Jenis Import</td>
				<td><select id="key_num" name="key_num">
				<?php
				$sql = "SELECT * FROM AUREIMPP ORDER BY IMP_TYP";
				$s = db_query ( $sql );
				while ( $row = db_fetch_array ( $s ) ) {
					$key_num = $row ['KEY_NUM'];
					$imp_typ = $row ['IMP_TYP'];
					$imp_dsc = $row ['IMP_DSC'];
					echo "<option value=\"$key_num\">" . $imp_typ . " - " . $imp_dsc . "</option>";
				}
				?>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strTextFile?></td>
				<td><input type="file" name="file" id="file"></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
</table>
</form>
<div id="divLoading" style="text-align: center;"><img src="image/loading.gif"></div>
<div id="divSearchKumpulan" title=""></div>

				<?php include_once 'footer.php';?>