<?php

include_once 'header.php';

$operator = $_SESSION ['userid'];
$operator_name = $_SESSION ['username'];
$kumpulan = $_SESSION ['kumpulan'];
$terminal = $_SESSION ['terminal'];

?>
<title><?=$sys_name?> - <?=$strCashierControl?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);
	$('#btnSearchKumpulan').click(function() { return false; });

	//navigation button
	loadNaviButton();
	loadDisabledField();
});

//make enter key behave like tab key
$('input').live('keydown', function(e) {
	if (e.keyCode == 13 || e.keyCode == 9) {
		e.preventDefault();
		var id = this.id;
		if ( id == "operator" ) {
			if (validateOperator() == true) {	
				$("#kumpulan").select();
			} 
		} else if ( id == "kumpulan" ) {
			if (validate() == true) {	
				$("#terminal").focus();
			} 
		} else if ( id == "terminal" ) {
			$("#wangruncit").select();
		} else if ( id == "wangruncit" ) {
			$("#hadtunai").select();
		} else if ( id == "hadtunai" ) {
			$("#operator").select();
		}
	}
});

//load navigation button
function loadNaviButton () {
	var action = $('#action').val();

	//if got data, enable navigation button
	if (action == 'data') {
		$('#btnNavi1').attr("disabled", false);
		$('#btnNavi2').attr("disabled", false);
		$('#btnNavi3').attr("disabled", false);
		$('#btnNavi4').attr("disabled", false);
		$('#btnNavi5').attr("disabled", false);
		$('#btnNavi6').attr("disabled", false);
		$('#divTotal').show();
	} else {
		$('#btnNavi1').attr("disabled", true);
		$('#btnNavi2').attr("disabled", true);
		$('#btnNavi3').attr("disabled", true);
		$('#btnNavi4').attr("disabled", true);
		$('#btnNavi5').attr("disabled", true);
		$('#btnNavi6').attr("disabled", true);
		$('#divTotal').hide();
	}
}

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search,add,modify only
	if (action == 'search' || action == 'add' || action == 'modify') {
		$('#operator').attr("disabled", false);
		$('#operator_name').attr("disabled", false);
		$('#btnSearchOperator').attr("onclick", "loadSearchOperator()");
		$('#kumpulan').attr("disabled", false);
		$('#kumpulan_desc').attr("disabled", false);
		$('#btnSearchKumpulan').attr("onclick", "loadSearchKumpulan()");
		$('#terminal').attr("disabled", false);
		$('#wangruncit').attr("disabled", false);
		$('#hadtunai').attr("disabled", false);
		$('#hadresit').attr("disabled", false);
		$('#tunai').attr("disabled", true);
		$('#cek').attr("disabled", true);
		$('#kirimanwang').attr("disabled", true);
		$('#kadkredit').attr("disabled", true);
		$('#eft').attr("disabled", true);
		$('#slipbank').attr("disabled", true);
		$('#bankdraft').attr("disabled", true);
		$('#jumlah').attr("disabled", true);
	} else {
		$('#operator').attr("disabled", true);
		$('#operator_name').attr("disabled", true);
		$('#btnSearchOperator').attr("onclick", "");
		$('#kumpulan').attr("disabled", true);
		$('#kumpulan_desc').attr("disabled", true);
		$('#btnSearchKumpulan').attr("onclick", "");
		$('#terminal').attr("disabled", true);
		$('#wangruncit').attr("disabled", true);
		$('#hadtunai').attr("disabled", true);
		$('#hadresit').attr("disabled", true);
		$('#tunai').attr("disabled", true);
		$('#cek').attr("disabled", true);
		$('#kirimanwang').attr("disabled", true);
		$('#kadkredit').attr("disabled", true);
		$('#eft').attr("disabled", true);
		$('#slipbank').attr("disabled", true);
		$('#bankdraft').attr("disabled", true);
		$('#jumlah').attr("disabled", true);
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'search') {
		var operator = $('#operator').val();
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var wangruncit = $('#wangruncit').val();
		var hadtunai = $('#hadtunai').val();
		var hadresit = $('#hadresit').val();
		var tunai = $('#tunai').val();
		var cek = $('#cek').val();
		var kirimanwang = $('#kirimanwang').val();
		var kadkredit = $('#kadkredit').val();
		var eft = $('#eft').val();
		var slipbank = $('#slipbank').val();
		var bankdraft = $('#bankdraft').val();

		$.post("kawalanjuruwang_search.php", {
			operator: operator, 
			kumpulan: kumpulan, 
			terminal: terminal, 
			wangruncit: wangruncit, 
			hadtunai: hadtunai, 
			hadresit: hadresit, 
			tunai: tunai, 
			cek: cek, 
			kirimanwang: kirimanwang, 
			kadkredit: kadkredit, 
			eft: eft, 
			slipbank: slipbank, 
			bankdraft: bankdraft 
			}, function(data) {
				if (data.total > 0) {
					$('#divTotal').val('1 dari ' + data.total);
					
					//load data
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", false);
					$('#btnDelete').attr("disabled", false);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("data");
					$('#totaldata').val(data.total);
					$('#strwhere').val(data.strwhere);
					loadNaviButton();
					loadDisabledField();

					//now load the data
					loaddata();
				} else {
					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);

					$('#action').val("");
					loadNaviButton();
					loadDisabledField();

					$('#divTotal').show();
					$('#divTotal').val('Tiada Rekod Dipilih');
				}
		}, "json");
	}

	//do add
	if (action == 'add') {
		var operator = $('#operator').val();
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var wangruncit = $('#wangruncit').val();
		var hadtunai = $('#hadtunai').val();
		var hadresit = $('#hadresit').val();
		var tunai = $('#tunai').val();
		var cek = $('#cek').val();
		var kirimanwang = $('#kirimanwang').val();
		var kadkredit = $('#kadkredit').val();
		var eft = $('#eft').val();
		var slipbank = $('#slipbank').val();
		var bankdraft = $('#bankdraft').val();

		var gotErr = 0;
		if (operator == "") {
			alert("Sila masukkan Nombor Juruwang");
			gotErr = 1;
			$("#operator").focus();
		} else if (kumpulan == "") {
			alert("Sila masukkan Pusat Kutipan");
			gotErr = 1;
			$("#kumpulan").focus();
		} else if (terminal == "") {
			alert("Sila masukkan No. Kaunter");
			gotErr = 1;
			$("#terminal").focus();
		}

		if (gotErr == 0) {
			$.post("validate_pusatkutipan.php", {
				kod: kumpulan 
				}, function(data) {
					if (data == 0){
						alert("Pusat Kutipan tidak wujud.");
						gotErr = 1;
						$("#kumpulan").select();
					} else {
						$.post("kawalanjuruwang_add.php", {
							operator: operator, 
							kumpulan: kumpulan, 
							terminal: terminal, 
							wangruncit: wangruncit, 
							hadtunai: hadtunai, 
							hadresit: hadresit, 
							tunai: tunai, 
							cek: cek, 
							kirimanwang: kirimanwang, 
							kadkredit: kadkredit, 
							eft: eft, 
							slipbank: slipbank, 
							bankdraft: bankdraft 
							}, function(data) {
								if (data > 0) {   //duplicate entry (dep_grp & terminal)
									alert('Rekod telah wujud. Sila pilih juruwang lain.');
								} else if (data == 'x') {
									alert('Rekod tidak wujud. Sila pastikan Kawalan Terminal telah ditambah.');
								} else {
									$('#action').val("");
									loadNaviButton();
									loadDisabledField();
						
									$('#btnOk').attr("disabled", true);
									$('#btnCancel').attr("disabled", true);
									$('#btnAdd').attr("disabled", false);
									$('#btnModify').attr("disabled", false);
									$('#btnDelete').attr("disabled", false);
									$('#btnSearch').attr("disabled", false);
								}
							});
					} 
			});
		}
	}
	
	//do modify
	if (action == 'modify') {
		var operator_ori = $('#operator_ori').val();
		var kumpulan_ori = $('#kumpulan_ori').val();
		var terminal_ori = $('#terminal_ori').val();
		var operator = $('#operator').val();
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var wangruncit = $('#wangruncit').val();
		var hadtunai = $('#hadtunai').val();
		var hadresit = $('#hadresit').val();

		var gotErr = 0;
		if (operator == "") {
			alert("Sila masukkan Nombor Juruwang");
			gotErr = 1;
			$("#operator").focus();
		} else if (kumpulan == "") {
			alert("Sila masukkan Pusat Kutipan");
			gotErr = 1;
			$("#kumpulan").focus();
		} else if (terminal == "") {
			alert("Sila masukkan Nombor Kaunter");
			gotErr = 1;
			$("#terminal").focus();
		}

		if (gotErr == 0) {
			$.post("validate_pusatkutipan.php", {
				kod: kumpulan 
				}, function(data) {
					if (data == 0){
						alert("Pusat Kutipan tidak wujud.");
						gotErr = 1;
						$("#kumpulan").select();
					} else {
						$.post("kawalanjuruwang_modify.php", {
							operator_ori: operator_ori, 
							kumpulan_ori: kumpulan_ori, 
							terminal_ori: terminal_ori,
							operator: operator, 
							kumpulan: kumpulan, 
							terminal: terminal, 
							wangruncit: wangruncit, 
							hadtunai: hadtunai,
							hadresit: hadresit
							}, function(data) {
								if (data > 0) {   //duplicate entry (dep_grp & terminal)
									alert('Data telah wujud.');
								} else if (data == 'x') {
									alert('Data tidak wujud.');
								} else {
									$('#btnOk').attr("disabled", true);
									$('#btnCancel').attr("disabled", true);
									$('#btnAdd').attr("disabled", false);
									$('#btnModify').attr("disabled", false);
									$('#btnDelete').attr("disabled", false);
									$('#btnSearch').attr("disabled", false);
									
									$('#action').val("data");
									loadNaviButton();
									loadDisabledField();
									loaddata();
								}
							});
					} 
			});
		}
	}
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadNaviButton();
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnAdd').attr("disabled", false);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", false);

	resetAllField();
}

//when click add
function doAdd () {
	$('#action').val("add");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	resetAllField();
	
	//default value
	//$("#operator").val('<?=$operator;?>');
	//$("#operator_name").val('<?=$operator_name;?>');
	$("#operator").select();
	$("#kumpulan").val('<?=$kumpulan;?>');
	//if ada kumpulan, refresh nama kumpulan
	if ('<?=$kumpulan?>') {
		refreshKumpulan();
	}
	$("#terminal").val('<?=$terminal;?>');
	
}

//when click modify
function doModify () {
	$('#action').val("modify");
	loadNaviButton();
	loadDisabledField();

	//store current value
	$('#operator_ori').val($('#operator').val());
	$('#kumpulan_ori').val($('#kumpulan').val());
	$('#terminal_ori').val($('#terminal').val());

	//readonly fields
	$('#operator_name').attr("readonly", true);
	$('#kumpulan_desc').attr("readonly", true);
	$('#tunai').attr("readonly", true);
	$('#cek').attr("readonly", true);
	$('#kirimanwang').attr("readonly", true);
	$('#kadkredit').attr("readonly", true);
	$('#eft').attr("readonly", true);
	$('#slipbank').attr("readonly", true);
	$('#bankdraft').attr("readonly", true);
	$('#jumlah').attr("readonly", true);
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	//$('#operator').focus();
}

//when click delete
function doDelete () {
	if (confirm('Adakah anda pasti untuk hapuskan rekod ini?')) {
		var operator = $('#operator').val();
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		$.post("kawalanjuruwang_delete.php", {
			operator: operator, 
			kumpulan: kumpulan, 
			terminal: terminal 
			}, function(data) {
				if (data.total > 0) {
					alert('<?=$strRecordLock?>');
				} else {
					$('#action').val("");
					$('#currentdata').val("1");
					
					loadNaviButton();
					loadDisabledField();
					resetAllField();

					$('#btnOk').attr("disabled", true);
					$('#btnCancel').attr("disabled", true);
					$('#btnAdd').attr("disabled", false);
					$('#btnModify').attr("disabled", true);
					$('#btnDelete').attr("disabled", true);
					$('#btnSearch').attr("disabled", false);
				}
		}, "json");
	} else {
	}	
}

//when click search
function search () {
	$('#action').val("search");
	$('#currentdata').val("1");
	loadNaviButton();
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnAdd').attr("disabled", true);
	$('#btnModify').attr("disabled", true);
	$('#btnDelete').attr("disabled", true);
	$('#btnSearch').attr("disabled", true);

	resetAllField();

	$('#operator').focus();
}

//js number format
Number.prototype.formatMoney = function(c, d, t) {
	var n = this, c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
	   return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
	 };

//load data to page
function loaddata () {
	var currentdata = $('#currentdata').val();
	var strwhere = $('#strwhere').val();
	$.post("kawalanjuruwang_search.php?getdata=1&currentdata=" + currentdata + "&strwhere=" + strwhere, {
		}, function(data) {
			var operator = data.operator;
			var operator_name = data.operator_name;
			var kumpulan = data.kumpulan;
			var kumpulan_desc = data.kumpulan_desc;
			var terminal = data.terminal;
			var wangruncit = parseFloat(data.wangruncit);
			var hadtunai = parseFloat(data.hadtunai);
			var hadresit = parseFloat(data.hadresit);
			var tunai = parseFloat(data.tunai);
			var cek = parseFloat(data.cek);
			var kirimanwang = parseFloat(data.kirimanwang);
			var kadkredit = parseFloat(data.kadkredit);
			var eft = parseFloat(data.eft);
			var slipbank = parseFloat(data.slipbank);
			var bankdraft = parseFloat(data.bankdraft);
			var jumlah = parseFloat(data.jumlah);
			var createdate = data.createdate;
			var modifydate = data.modifydate;
			var mod_operator = data.mod_operator;
			var mod_operatorname = data.mod_operatorname;

			$('#operator').val(operator);
			$('#operator_name').val(operator_name);
			$('#kumpulan').val(kumpulan);
			$('#kumpulan_desc').val(kumpulan_desc);
			$('#terminal').val(terminal);
			$('#wangruncit').val(wangruncit.formatMoney(2,'.',','));
			$('#hadtunai').val(hadtunai.formatMoney(2,'.',','));
			$('#hadresit').val(hadresit.formatMoney(2,'.',','));
			$('#tunai').val(tunai.formatMoney(2,'.',','));
			$('#cek').val(cek.formatMoney(2,'.',','));
			$('#kirimanwang').val(kirimanwang.formatMoney(2,'.',','));
			$('#kadkredit').val(kadkredit.formatMoney(2,'.',','));
			$('#eft').val(eft.formatMoney(2,'.',','));
			$('#slipbank').val(slipbank.formatMoney(2,'.',','));
			$('#bankdraft').val(bankdraft.formatMoney(2,'.',','));
			$('#jumlah').val(jumlah.formatMoney(2,'.',','));
			$('#createdate').val(createdate);
			$('#modifydate').val(modifydate);
			$('#modoperator').val(mod_operator);
			$('#modoperatorname').val(mod_operatorname);
		}, "json");
}

//when click next navigation
function datanavinext () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev navigation
function datanaviprev () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 1;
		$('#currentdata').val(currentdata);
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click next 10 navigation
function datanavinext10 () {
	if ($('#currentdata').val() == $('#totaldata').val()) {
		alert('<?=$strLastRecord?>');
		var currentdata = 1;
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) + 10;
		if (currentdata > $('#totaldata').val()) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click prev 10 navigation
function datanaviprev10 () {
	if ($('#currentdata').val() == 1) {
		var currentdata = $('#totaldata').val();
		$('#currentdata').val(currentdata);
	} else {
		var currentdata = parseInt($('#currentdata').val()) - 10;
		if (currentdata < 1) {
			currentdata = 1;
			$('#currentdata').val(currentdata);
		} else {
			$('#currentdata').val(currentdata);
		}
	}
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click last navigation
function datanavilast () {
	var currentdata = $('#totaldata').val();
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

//when click first navigation
function datanavifirst () {
	var currentdata = 1;
	$('#currentdata').val(currentdata);
	loaddata();
	$('#divTotal').val(currentdata + ' dari ' + $('#totaldata').val());
}

function resetAllField () {
	//reset all field
	$('#operator').val("");
	$('#operator_name').val("");
	$('#kumpulan').val("");
	$('#kumpulan_desc').val("");
	$('#terminal').val("");
	$('#wangruncit').val("");
	$('#hadtunai').val("");
	$('#hadresit').val("");
	$('#tunai').val("");
	$('#cek').val("");
	$('#kirimanwang').val("");
	$('#kadkredit').val("");
	$('#eft').val("");
	$('#slipbank').val("");
	$('#bankdraft').val("");
	$('#jumlah').val("");
	$('#createdate').val("");
	$('#modifydate').val("");
	$('#modoperator').val("");
	$('#modoperatorname').val("");
}

function doFormat (a) {
	if ($('#action').val()=="modify" || $('#action').val()=="add") {
		a.value=parseFloat(a.value.replace(/[^0-9\.]+/g,"")).formatMoney(2,'.',',');
	}
}

function calculate () {
	var f1 = parseFloat($('#tunai').val().replace(/[^0-9\.]+/g,""));
	var f2 = parseFloat($('#cek').val().replace(/[^0-9\.]+/g,""));
	var f3 = parseFloat($('#kirimanwang').val().replace(/[^0-9\.]+/g,""));
	var f4 = parseFloat($('#kadkredit').val().replace(/[^0-9\.]+/g,""));
	var f5 = parseFloat($('#eft').val().replace(/[^0-9\.]+/g,""));
	var f6 = parseFloat($('#slipbank').val().replace(/[^0-9\.]+/g,""));
	var f7 = parseFloat($('#bankdraft').val().replace(/[^0-9\.]+/g,""));

	var total = 0;
	if (f1) {total += f1}; 
	if (f2) {total += f2}; 
	if (f3) {total += f3}; 
	if (f4) {total += f4}; 
	if (f5) {total += f5}; 
	if (f6) {total += f6}; 
	if (f7) {total += f7}; 

	$('#jumlah').val(total.formatMoney(2,'.',','));
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulan.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: 'Pusat Kutipan', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchOperator () {
	try {

		var url = 'lookup_operator.php';
		
		$("#divSearchOperator").load(url);
		$("#divSearchOperator").dialog({ width: 400, height: 400, modal: true, title: 'Juruwang', 
			buttons: {
					'Pilih': function() {
						addSearchOperator();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh operator
function refreshOperator () {
	try {
		$.post("refresh_operator.php", {
			operator: $("#operator").val() 
			}, function(data) {
				$("#operator_name").val(data);
		});
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		$.post("refresh_kumpulan.php", {
			kumpulan: $("#kumpulan").val() 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
		$("#terminal").select();
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function validateOperator () {
	var operator = $("#operator").val();
	var action = $("#action").val();
	if (action == "add" || action == "modify") {
		$.post("validate_operator.php", {
			operator: operator 
			}, function(data) {
				if (data == 0){
					alert("Juruwang tidak wujud.");
					$("#operator").select();
					return false;
				} else {
					refreshOperator();
					$("#kumpulan").select();
					return true;
				} 
		});
	} else {
		return true; 
	}
}

function validate () {
	var kod = $("#kumpulan").val();
	var action = $("#action").val();
	if (action == "add" || action == "modify") {
		$.post("validate_pusatkutipan.php", {
			kod: kod 
			}, function(data) {
				if (data == 0){
					alert("Pusat Kutipan tidak wujud.");
					$("#kumpulan").select();
					return false;
				} else {
					refreshKumpulan();
					$("#terminal").focus();
					return true;
				} 
		});
	} else {
		return true; 
	}
}

function doList () {
	location.href='kawalanjuruwang_list.php';
}

</script>
<br>
<input type="hidden"
	id="action" value="">
<input type="hidden" id="currentdata" value="1">
<input type="hidden"
	id="totaldata" value="0">
<input type="hidden"
	id="strwhere" value="0">
<input type="hidden" id="operator_ori" value="">
<input type="hidden" id="kumpulan_ori" value="">
<input type="hidden" id="terminal_ori" value="">

<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strCashierControl?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_all.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_navi.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td nowrap="nowrap"><?=$strCashierNo?></td>
				<td><input type="text" id="operator" name="operator" size="10" /><img
					id="btnSearchOperator" src="image/search.gif"
					onclick="loadSearchOperator();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="operator_name" name="operator_name" size="50" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strDepGrp?></td>
				<td><input type="text" id="kumpulan" name="kumpulan" size="10"
					style="text-transform: uppercase" /><img id="btnSearchKumpulan"
					src="image/search.gif" onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kumpulan_desc" name="kumpulan_desc" size="50" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strTerminalNo?></td>
				<td><select id="terminal" name="terminal" class="font-std">
				<?=$strOptionTerminal?>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strPettyCash?></td>
				<td>RM <input type="text" id="wangruncit" name="wangruncit"
					size="20" style="text-align: right;"
					onblur="doFormat(this);calculate();" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strCashLimit?></td>
				<td>RM <input type="text" id="hadtunai" name="hadtunai" size="20"
					style="text-align: right;" onblur="doFormat(this);" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strRcpLimit?></td>
				<td>RM <input type="text" id="hadresit" name="hadresit" size="20"
					style="text-align: right;" onblur="doFormat(this);" /></td>
			</tr>
			<tr>
				<td></td>
				<td></td>
			</tr>
			<tr>
				<td colspan="2"><b><?=$strReceivedAmount?></b></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strCash?></td>
				<td>RM <input type="text" id="tunai" name="tunai" size="20"
					style="text-align: right;" onblur="doFormat(this);calculate();" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strChequeValue?></td>
				<td>RM <input type="text" id="cek" name="cek" size="20"
					style="text-align: right;" onblur="doFormat(this);calculate();"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strCreditCard?></td>
				<td>RM <input type="text" id="kadkredit" name="kadkredit" size="20"
					style="text-align: right;" onblur="doFormat(this);calculate();"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strMoneyOrder?></td>
				<td>RM <input type="text" id="kirimanwang" name="kirimanwang"
					size="20" style="text-align: right;"
					onblur="doFormat(this);calculate();" disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strEFT?></td>
				<td>RM <input type="text" id="eft" name="eft" size="20"
					style="text-align: right;" onblur="doFormat(this);calculate();"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strBankDraft?></td>
				<td>RM <input type="text" id="bankdraft" name="bankdraft" size="20"
					style="text-align: right;" onblur="doFormat(this);calculate();"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strBankSlip?></td>
				<td>RM <input type="text" id="slipbank" name="slipbank" size="20"
					style="text-align: right;" onblur="doFormat(this);calculate();"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strGrandTotal?></td>
				<td>RM <input type="text" id="jumlah" name="jumlah" size="20"
					style="text-align: right;" disabled="disabled" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>&nbsp;</td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_createdby.php';?></td>
		<td></td>
	</tr>
</table>
<div id="divSearchKumpulan"
	title=""></div>
<div id="divSearchOperator"
	title=""></div>
				<?php include_once 'footer.php';?>