<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$arrResitBatal = array();
$a = 0;
$sql = "SELECT b.pay_typ,SUM(a.rcp_amt) amt,COUNT(a.rcp_num) totrcp
FROM 
aurerecp a, aurepymt b
WHERE
a.rcp_num=b.rcp_num AND
a.dep_grp=b.dep_grp AND
a.tty_num=b.tty_num AND
a.rcp_dte=b.rcp_dte
$strWhere
GROUP BY b.pay_typ";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$pay_typ = $row ['pay_typ'];
	$totrcp = $row ['totrcp'];
	$amt = $row ['amt'];
	$arrResult [++$a]['pay_typ'] = $pay_typ;
	$arrResult [$a]['totrcp'] = $totrcp;
	$arrResult [$a]['amt'] = $amt;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs12 = strtoupper($strCs12);
$strKumpulan = strtoupper($kumpulan);
$strKumpulanDesc = strtoupper(re_getDepGrpDesc($kumpulan));
$strFontSize = 9;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('P','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-12", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs12", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan ($strKumpulanDesc)", 0, 0, 'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER     : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI : $tarikhdari          TARIKH HINGGA : $tarikhkepada", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"CARA BAYARAN          JUMLAH BAYARAN          TRANSAKSI", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,2,"-------------------------------------------------------", 0, 0, 'L');


$bil = 0;
foreach ($arrResult as $curResult) {
	$amt = $curResult['amt'];
	$totrcp = $curResult['totrcp'];
	$pay_typ = $curResult['pay_typ'];
	$totAmt += $amt;
	$totTotrcp += $totrcp;
	++$bil;

	switch ($pay_typ) {
		case 1 :
			$pay_typ = "TUNAI";
			break;
		case 2 :
			$pay_typ = "CEK";
			break;
		case 3 :
			$pay_typ = "KAD KREDIT";
			break;
		case 4 :
			$pay_typ = "WANG POS";
			break;
		case 5 :
			$pay_typ = "EFT";
			break;
		case 6 :
			$pay_typ = "BANK DERAF";
			break;
		case 7 :
			$pay_typ = "BANK SLIP";
			break;
	}

	$strCaraBayaran = str_pad($pay_typ, 10, " ", STR_PAD_RIGHT);
	$strAmt = str_pad(number_format($amt,2), 25, " ", STR_PAD_LEFT);
	$strTotRcp = str_pad($totrcp, 18, " ", STR_PAD_LEFT);

	$pdf->Ln();
	$pdf->Cell(0,3,"$strCaraBayaran $strAmt $strTotRcp", 0, 0, 'L');
}

$strTotAmt = str_pad(number_format($totAmt,2), 29, " ", STR_PAD_LEFT);
$strTotTotRcp = str_pad($totTotrcp, 18, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"JUMLAH $strTotAmt $strTotTotRcp", 0, 0, 'L');

$pdf->Output("CS12_$today_pdf.pdf","D");

?>
