<?php

include_once 'header.php';

$today = date ( 'd/m/Y' );

$strLookupMduRef = getLookupMduRef();

?>
<title><?=$sys_name?> - <?=$strCs10;?></title>
<script>

$(document).ready(function() {
	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnReport').attr("disabled", false);

	loadDisabledField();
});

//make enter key behave like tab key
$('input').live('keydown', function(e) {
	if (e.keyCode == 13) {
		var id = this.id;
		if ( id == "kumpulan" ) {
			$("#terminal").select();
		} else if ( id == "terminal" ) {
			$("#desmdu").select();
		} else if ( id == "desmdu" ) {
			$("#kodhasildari").select();
		} else if ( id == "kodhasildari" ) {
			$("#kodhasilke").select();
		} else if ( id == "kodhasilke" ) {
			$("#tarikhdari").select();
		} else if ( id == "tarikhdari" ) {
			$("#tarikhkepada").select();
		} else if ( id == "tarikhkepada" ) {
			$("#kumpulan").select();
		}
	}
});

function loadDisabledField () {
	var action = $('#action').val();

	//enable field for search,add,modify only
	if (action == 'report') {
		$('#kumpulan').attr("readonly", false);
		$('#kumpulan_desc').attr("readonly", true);
		$('#terminal').attr("readonly", false);
		$('#desmdu').attr("readonly", false);
		$('#kodhasildari').attr("readonly", false);
		$('#kodhasilke').attr("readonly", false);
		$('#tarikhdari').attr("readonly", false);
		$("#tarikhdari").datepicker({dateFormat:'dd/mm/yy'});
		$('#tarikhkepada').attr("readonly", false);
		$("#tarikhkepada").datepicker({dateFormat:'dd/mm/yy'});
	} else {
		$('#kumpulan').attr("readonly", true);
		$('#kumpulan_desc').attr("readonly", true);
		$('#terminal').attr("readonly", true);
		$('#desmdu').attr("readonly", true);
		$('#kodhasildari').attr("readonly", true);
		$('#kodhasilke').attr("readonly", true);
		$('#tarikhdari').attr("readonly", true);
		$("#tarikhdari").datepicker('destroy');
		$('#tarikhkepada').attr("readonly", true);
		$("#tarikhkepada").datepicker('destroy');
	}
}

//when click ok
function ok () {
	var action = $('#action').val();

	//do search
	if (action == 'report') {
		var kumpulan = $('#kumpulan').val();
		var terminal = $('#terminal').val();
		var desmdu = $('#desmdu').val();
		var kodhasildari = $('#kodhasildari').val();
		var kodhasilke = $('#kodhasilke').val();
		var tarikhdari = $('#tarikhdari').val();
		var tarikhkepada = $('#tarikhkepada').val();

		var gotErr = 0;
		if (kumpulan == "") {
			alert("Sila masukkan <?=$strDepGrp?>.");
			gotErr = 1;
			$("#kumpulan").focus();
		} else if (terminal == "") {
			alert("Sila masukkan <?=$strTerminalNo?>.");
			gotErr = 1;
			$("#terminal").focus();
		} 
		
		if (gotErr == 0) {
			$.post("cs10_search.php", {
				kumpulan: kumpulan, 
				terminal: terminal, 
				desmdu: desmdu, 
				kodhasildari: kodhasildari, 
				kodhasilke: kodhasilke, 
				tarikhdari: tarikhdari, 
				tarikhkepada: tarikhkepada 
				}, function(data) {
					if (data.total > 0) {
						$('#btnOk').attr("disabled", true);
						$('#btnCancel').attr("disabled", true);
						$('#btnReport').attr("disabled", false);
	
						$('#action').val("data");
						loadDisabledField();
	
						//print report pdf
						window.location.href = 'cs10_print.php?kumpulan='+kumpulan+'&terminal='+terminal+'&desmdu='+desmdu+'&tarikhdari='+tarikhdari+'&tarikhkepada='+tarikhkepada+'&kodhasildari='+kodhasildari+'&kodhasilke='+kodhasilke;
					} else {
						$('#btnOk').attr("disabled", true);
						$('#btnCancel').attr("disabled", true);
						$('#btnReport').attr("disabled", false);
	
						$('#action').val("");
						loadDisabledField();
						alert("Tiada data untuk diproses. Klik OK untuk seterusnya.");
					}
			}, "json");
		}
	}
	
}

//when click cancel
function doCancel () {
	$('#action').val("");
	loadDisabledField();

	$('#btnOk').attr("disabled", true);
	$('#btnCancel').attr("disabled", true);
	$('#btnReport').attr("disabled", false);

	resetAllField();
}

//when click search
function doReport () {
	$('#action').val("report");
	loadDisabledField();
	
	$('#btnOk').attr("disabled", false);
	$('#btnCancel').attr("disabled", false);
	$('#btnReport').attr("disabled", true);

	resetAllField();

	//default value
	$('#tarikh').val('<?=$today;?>');

	$('#kumpulan').focus();
}

function resetAllField () {
	$('#kumpulan').val("");
	$('#kumpulan_desc').val("");
	$('#terminal').val("");
	$('#desmdu').val("");
	$('#kodhasildari').val("");
	$('#kodhasilke').val("");
	$('#tarikhdari').val("");
	$('#tarikhkepada').val("");
}

function loadSearchKumpulan () {
	try {

		var url = 'lookup_kumpulan.php';
		
		$("#divSearchKumpulan").load(url);
		$("#divSearchKumpulan").dialog({ width: 400, height: 400, modal: true, title: '<?=$strDepGrp?>', 
			buttons: {
					'Pilih': function() {
						addSearchKumpulan();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

//refresh kumpulan
function refreshKumpulan () {
	try {
		var kumpulan = $("#kumpulan").val();
		$.post("refresh_kumpulan.php", {
			kumpulan: kumpulan 
			}, function(data) {
				$("#kumpulan_desc").val(data);
		});
		if (kumpulan) {
			$("#terminal").select();
		}
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchKodHasilDari () {
	try {

		var url = 'lookup_kodhasildari.php';
		
		$("#divSearchKodHasilDari").load(url);
		$("#divSearchKodHasilDari").dialog({ width: 400, height: 400, modal: true, title: '<?=$strRcpTypFrom?>', 
			buttons: {
					'Pilih': function() {
						addSearchKodHasilDari();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}

function loadSearchKodHasilKe () {
	try {

		var url = 'lookup_kodhasilke.php';
		
		$("#divSearchKodHasilKe").load(url);
		$("#divSearchKodHasilKe").dialog({ width: 400, height: 400, modal: true, title: '<?=$strRcpTypTo?>', 
			buttons: {
					'Pilih': function() {
						addSearchKodHasilTo();
					},
					'Batal': function () {
						$(this).dialog('close');
					}
				},
			close: function() {
			}
		});
	
	} catch(e) {
		alert("JS error: " + e.message); 
	}
}
</script>
<br>
<input type="hidden"
	id="action" value="">
<table width="80%" border="0" cellpadding="2" cellspacing="1"
	align="center" class="font-std">
	<tr>
		<td class="font-std-big"><?=$strCs10;?></td>
		<td></td>
	</tr>
	<tr>
		<td><?php include_once 'include_button_report.php';?></td>
		<td></td>
	</tr>
	<tr>
		<td width="80%">
		<fieldset>
		<table width="100%" border="0" cellpadding="2" cellspacing="1"
			align="left" class="font-std">
			<tr>
				<td width="10%" nowrap="nowrap"><?=$strDepGrp;?></td>
				<td><input type="text" id="kumpulan" name="kumpulan" size="10"
					onblur="refreshKumpulan();" style="text-transform: uppercase" /><img
					id="btnSearchKumpulan" src="image/search.gif"
					onclick="loadSearchKumpulan();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kumpulan_desc" name="kumpulan_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strTerminalNo;?></td>
				<td><select id="terminal" name="terminal">
				<?=$strOptionTerminal?>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strMduRef;?></td>
				<td><select id="desmdu" name="desmdu">
				<?=$strLookupMduRef?>
				</select></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strRcpTypFrom;?></td>
				<td><input type="text" id="kodhasildari" name="kodhasildari"
					size="10" /><img id="btnSearchKumpulan" src="image/search.gif"
					onclick="loadSearchKodHasilDari();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kodhasildari_desc" name="kodhasildari_desc"
					size="50" disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strRcpTypTo;?></td>
				<td><input type="text" id="kodhasilke" name="kodhasilke" size="10" /><img
					id="btnSearchKumpulan" src="image/search.gif"
					onclick="loadSearchKodHasilKe();"
					onmouseover="this.style.cursor='pointer';"
					style="padding-bottom: 4px; vertical-align: middle;"> <input
					type="text" id="kodhasilke_desc" name="kodhasilke_desc" size="50"
					disabled="disabled" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiptDateFrom;?></td>
				<td><input type="text" id="tarikhdari" name="tarikhdari" size="10" /></td>
			</tr>
			<tr>
				<td nowrap="nowrap"><?=$strReceiptDateTo?></td>
				<td><input type="text" id="tarikhkepada" name="tarikhkepada"
					size="10" /></td>
			</tr>
		</table>
		</fieldset>
		</td>
		<td></td>
	</tr>
</table>
<div id="divSearchKumpulan" title=""></div>
<div id="divSearchKodHasilDari" title=""></div>
<div id="divSearchKodHasilKe" title=""></div>
				<?php include_once 'footer.php';?>