<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$kodhasildari = $_GET ['kodhasildari'];
$kodhasilke = $_GET ['kodhasilke'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

if ($kodhasildari && $kodhasilke) {
	$strWhere .= " AND b.RCP_TYP BETWEEN '$kodhasildari' AND '$kodhasilke'";
}

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$a = 0;
$sql = "SELECT b.rcp_typ,c.rcp_nme,SUM(b.rcp_amt) + SUM(b.tax_amt) amt
FROM 
(aurerecp a, aureline b,auretype c) 
WHERE 
a.rcp_num=b.rcp_num AND
a.dep_grp=b.dep_grp AND
a.tty_num=b.tty_num AND
a.rcp_dte=b.rcp_dte AND
c.rcp_typ=b.rcp_typ
$strWhere
GROUP BY b.rcp_typ
ORDER BY a.rcp_num,b.rcp_typ";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$rcp_typ = $row ['rcp_typ'];
	$rcp_nme = $row ['rcp_nme'];
	$amt = $row ['amt'];
	$arrResult [$a]['rcp_typ'] = $rcp_typ;
	$arrResult [$a]['rcp_nme'] = $rcp_nme;
	$arrResult [$a]['amt'] = $amt;
	$a++;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs09 = strtoupper($strCs09);
$strKumpulan = strtoupper($kumpulan);
$strFontSize = 10;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('P','A4');
$pdf->SetFont('Courier','',10);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-09", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs09", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan", 0, 0, 'C');

$strSpace1 = str_pad("", 20 - strlen($kodhasildari), " ",STR_PAD_LEFT);
$strSpace2 = str_pad("", 20 - strlen($tarikhdari), " ",STR_PAD_LEFT);

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER        : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"KOD HASIL DARI : $kodhasildari $strSpace1 KOD HASIL HINGGA : $kodhasilke", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI    : $tarikhdari $strSpace2 TARIKH HINGGA    : $tarikhkepada", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KOD HASIL KETERANGAN                                JENIS                AMAUN", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"----------------------------------------------------------------------------------", 0, 0, 'L');

foreach ($arrResult as $curResult) {
	$rcp_typ = $curResult ['rcp_typ'];
	$rcp_nme = $curResult ['rcp_nme'];
	$amt = $curResult ['amt'];
	$totAmt += $amt;

	$strRcpTyp = str_pad($rcp_typ, 9, " ", STR_PAD_RIGHT);
	$strRcpNme = str_pad(substr($rcp_nme,0,45), 45, " ", STR_PAD_RIGHT);
	$strJenis = str_pad($jenis, 5, " ", STR_PAD_LEFT);
	$strAmt = str_pad(number_format($amt,2), 19, " ", STR_PAD_LEFT);

	$pdf->Ln();
	$pdf->Cell(0,4,"$strRcpTyp $strRcpNme  $strJenis $strAmt", 0, 0, 'L');
}

$strTotAmt = str_pad(number_format($totAmt,2), 74, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,4,"JUMLAH  $strTotAmt", 0, 0, 'L');

$pdf->Output("CS09_$today_pdf.pdf","D");
?>
