<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$kodhasildari = $_GET ['kodhasildari'];
$kodhasilke = $_GET ['kodhasilke'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

if ($kodhasildari && $kodhasilke) {
	$strWhere .= " AND b.RCP_TYP BETWEEN '$kodhasildari' AND '$kodhasilke'";
}

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

//return total records found
$a = 0;
$sql = "SELECT b.rcp_typ,b.srl_no,f.rcp_nme,a.rcp_num,d.las_nme,a.vod_stu,c.pay_typ,e.bnk_brn bank,DATE_FORMAT( c.cre_dte_tme, '%d/%m/%Y' ) pymt_date,DATE_FORMAT( c.cre_dte_tme, '%H:%i:%s' ) pymt_time,SUM(b.rcp_amt) + SUM(b.tax_amt) amt
FROM 
(aurerecp a, aureline b, aurepymt c,aumnoper d,auretype f) 
LEFT JOIN aualbsbn e ON c.bnk_bsb=e.bnk_bsb
WHERE 
a.rcp_num=b.rcp_num AND a.rcp_num=c.rcp_num
AND a.dep_grp=b.dep_grp AND a.dep_grp=c.dep_grp
AND a.tty_num=b.tty_num AND a.tty_num=c.tty_num
AND a.rcp_dte=b.rcp_dte AND a.rcp_dte=c.rcp_dte
AND a.opr_num=d.opr_num
AND f.rcp_typ=b.rcp_typ
$strWhere
GROUP BY a.RCP_NUM
ORDER BY a.rcp_num, b.rcp_typ ";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$rcp_typ = $row ['rcp_typ'];
	$rcp_nme = $row ['rcp_nme'];
	$rcp_num = $row ['rcp_num'];
	$srl_no = $row ['srl_no'];
	$las_nme = $row ['las_nme'];
	$vod_stu = $row ['vod_stu'];
	$pay_typ = $row ['pay_typ'];
	$bank = $row ['bank'];
	$pymt_date = $row ['pymt_date'];
	$pymt_time = $row ['pymt_time'];
	$amt = $row ['amt'];
	$arrRcpNme [$rcp_typ] = $rcp_nme;
	$arrResult [$rcp_typ][$a]['rcp_num'] = $rcp_num;
	$arrResult [$rcp_typ][$a]['srl_no'] = $srl_no;
	$arrResult [$rcp_typ][$a]['las_nme'] = $las_nme;
	$arrResult [$rcp_typ][$a]['vod_stu'] = $vod_stu;
	$arrResult [$rcp_typ][$a]['pay_typ'] = $pay_typ;
	$arrResult [$rcp_typ][$a]['bank'] = $bank;
	$arrResult [$rcp_typ][$a]['pymt_date'] = $pymt_date;
	$arrResult [$rcp_typ][$a]['pymt_time'] = $pymt_time;
	$arrResult [$rcp_typ][$a]['amt'] = $amt;
	$a++;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs08 = strtoupper($strCs08);
$strKumpulan = strtoupper($kumpulan);
$strFontSize = 10;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('L','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-08", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs08", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan", 0, 0, 'C');

$strSpace1 = str_pad("", 20 - strlen($kodhasildari), " ",STR_PAD_LEFT);
$strSpace2 = str_pad("", 20 - strlen($tarikhdari), " ",STR_PAD_LEFT);

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"KAUNTER        : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"KOD HASIL DARI : $kodhasildari $strSpace1 KOD HASIL HINGGA : $kodhasilke", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI    : $tarikhdari $strSpace2 TARIKH HINGGA    : $tarikhkepada", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"BIL  TARIKH       BATAL    NO RESIT    JENIS LESEN    CARA BAYARAN                      JENIS             AMAUN", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"     MASA                              NO RESIT AM    JENIS BANK", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"     PENGGUNA", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,1,"---------------------------------------------------------------------------------------------------------------", 0, 0, 'L');

foreach ($arrResult as $rcp_typ => $curResult) {
	$bil = 0;
	$rcp_nme = $arrRcpNme [$rcp_typ];

	$pdf->SetFont('Courier','',$strFontSize);
	$pdf->Ln();
	$pdf->Cell(0,4,"KOD HASIL     $rcp_typ     $rcp_nme", 0, 0, 'L');

	$totAmt = 0;
	foreach ($curResult as $curItem){
		$rcp_nme = $curItem['rcp_nme'];
		$date = $curItem['pymt_date'];
		$time = $curItem['pymt_time'];
		$user = $curItem['las_nme'];
		$batal = ($curItem['vod_stu'] == 'V') ? "BATAL" : "N";
		$rcp_num = $curItem['rcp_num'];
		$noResitAm = $curItem['srl_no'];
		$pay_typ = $curItem['pay_typ'];
		$bank = $curItem['bank'];
		$amt = $curItem['amt'];
		$totAmt += $amt;
		$grandTotAmt += $amt;

		switch ($pay_typ) {
			case 1 :
				$caraBayaran = "TUNAI";
				break;
			case 2 :
				$caraBayaran = "CEK";
				break;
			case 3 :
				$caraBayaran = "KAD KREDIT";
				break;
			case 4 :
				$caraBayaran = "WANG POS";
				break;
			case 5 :
				$caraBayaran = "EFT";
				break;
			case 6 :
				$caraBayaran = "BANK DERAF";
				break;
			case 7 :
				$caraBayaran = "BANK SLIP";
				break;
		}

		$bil++;

		$strBil = str_pad($bil, 3, " ", STR_PAD_RIGHT);
		$strBatal = str_pad($batal, 5, " ", STR_PAD_RIGHT);
		$strRcpNum = str_pad($rcp_num, 8, " ", STR_PAD_RIGHT);
		$strJenisLesen = str_pad($jenisLesen, 11, " ", STR_PAD_RIGHT);
		$strNoResitAm = str_pad($noResitAm, 11, " ", STR_PAD_RIGHT);
		$strCaraBayaran = str_pad($caraBayaran, 12, " ", STR_PAD_RIGHT);
		$strBank = str_pad($bank, 12, " ", STR_PAD_RIGHT);
		$strJenis = str_pad($jenis, 5, " ", STR_PAD_RIGHT);
		$strAmt = str_pad(number_format($amt,2), 16, " ", STR_PAD_LEFT);

		$pdf->Ln();
		$pdf->Cell(0,3,"$strBil  $date   $strBatal    $strRcpNum    $strJenisLesen    $strCaraBayaran                       $strJenis $strAmt", 0, 0, 'L');
		$pdf->Ln();
		$pdf->Cell(0,3,"     $time                          $strNoResitAm    $strBank", 0, 0, 'L');
		$pdf->Ln();
		$pdf->Cell(0,3,"     $user", 0, 0, 'L');
		$pdf->Ln();
		$pdf->Cell(0,1,"", 0, 0, 'L');
	}

	$strTotAmt = str_pad(number_format($totAmt,2), 104, " ", STR_PAD_LEFT);

	$pdf->SetFont('Courier','B',$strFontSize);
	$pdf->Ln();
	$pdf->Cell(0,4,"JUMLAH $strTotAmt", 0, 0, 'L');
}

$strGrandTotAmt = str_pad(number_format($grandTotAmt,2), 98, " ", STR_PAD_LEFT);

$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Ln();
$pdf->Cell(0,4,"JUMLAH BESAR $strGrandTotAmt", 0, 0, 'L');

$pdf->Output("CS08_$today_pdf.pdf","D");
?>
