<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$terminal = $_GET ['terminal'];
$tarikh = $_GET ['tarikh'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= ($terminal) ? " AND a.TTY_NUM='$terminal'" : "";
$strWhere .= " AND (a.VOD_STU!='V' AND a.VOD_STU!='O')";

//return total records found
$sql = "SELECT rcp_typ, rcp_nme, SUM(amt_today) amt_today, SUM(totrcp_today) totrcp_today, SUM(amt_month) amt_month, SUM(totrcp_month) totrcp_month, SUM(amt_year) amt_year, SUM(totrcp_year) totrcp_year
FROM (
SELECT c.rcp_typ,d.rcp_nme,
	SUM(c.rcp_amt) + SUM(c.tax_amt) amt_today,COUNT(DISTINCT(a.rcp_num)) totrcp_today,
	0 amt_month,0 totrcp_month,
	0 amt_year,0 totrcp_year  
	FROM aurerecp a, aureline c, auretype d
	WHERE 
	a.rcp_num=c.rcp_num AND a.dep_grp=c.dep_grp AND a.tty_num=c.tty_num AND a.rcp_dte=c.rcp_dte AND a.opr_num=c.mod_opr
	AND c.rcp_typ=d.rcp_typ
	AND a.rcp_dte = STR_TO_DATE( '$tarikh', '%d/%m/%Y' ) 
	$strWhere
	GROUP BY rcp_typ
UNION
	SELECT c.rcp_typ,d.rcp_nme,
	0 amt_today,0 totrcp_today,
	SUM(c.rcp_amt) + SUM(c.tax_amt) amt_month,COUNT(DISTINCT(a.rcp_num)) totrcp_month,
	0 amt_year,0 totrcp_year  
	FROM aurerecp a, aureline c, auretype d
	WHERE 
	a.rcp_num=c.rcp_num AND a.dep_grp=c.dep_grp AND a.tty_num=c.tty_num AND a.rcp_dte=c.rcp_dte AND a.opr_num=c.mod_opr
	AND c.rcp_typ=d.rcp_typ
	AND YEAR(a.rcp_dte) = YEAR(STR_TO_DATE( '$tarikh', '%d/%m/%Y' ) ) 
	AND MONTH(a.rcp_dte) = MONTH(STR_TO_DATE( '$tarikh', '%d/%m/%Y' ) )
	AND a.rcp_dte <= STR_TO_DATE( '$tarikh', '%d/%m/%Y' )
$strWhere
	GROUP BY rcp_typ
UNION
	SELECT c.rcp_typ,d.rcp_nme,
	0 amt_today,0 totrcp_today,
	0 amt_month,0 totrcp_month,
	SUM(c.rcp_amt) + SUM(c.tax_amt) amt_year,COUNT(DISTINCT(a.rcp_num)) totrcp_year  
	FROM aurerecp a, aureline c, auretype d
	WHERE 
	a.rcp_num=c.rcp_num AND a.dep_grp=c.dep_grp AND a.tty_num=c.tty_num AND a.rcp_dte=c.rcp_dte AND a.opr_num=c.mod_opr
	AND c.rcp_typ=d.rcp_typ
	AND YEAR(a.rcp_dte) = YEAR(STR_TO_DATE( '$tarikh', '%d/%m/%Y' ) ) 
	AND a.rcp_dte <= STR_TO_DATE( '$tarikh', '%d/%m/%Y' )
$strWhere
	GROUP BY rcp_typ
) temp
GROUP BY rcp_typ";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$rcp_typ = $row ['rcp_typ'];
	$rcp_nme = $row ['rcp_nme'];
	$amt_today = $row ['amt_today'];
	$totrcp_today = $row ['totrcp_today'];
	$amt_month = $row ['amt_month'];
	$totrcp_month = $row ['totrcp_month'];
	$amt_year = $row ['amt_year'];
	$totrcp_year = $row ['totrcp_year'];
	$arrResult [$rcp_typ]['rcp_nme'] = $rcp_nme;
	$arrResult [$rcp_typ]['amt_today'] = $amt_today;
	$arrResult [$rcp_typ]['totrcp_today'] = $totrcp_today;
	$arrResult [$rcp_typ]['amt_month'] = $amt_month;
	$arrResult [$rcp_typ]['totrcp_month'] = $totrcp_month;
	$arrResult [$rcp_typ]['amt_year'] = $amt_year;
	$arrResult [$rcp_typ]['totrcp_year'] = $totrcp_year;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs06 = strtoupper($strCs06);
$strKumpulan = strtoupper($kumpulan);
$strFontSize = 10;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('P','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-06", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs06", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan", 0, 0, 'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"KAUNTER : $terminal", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(1,3,"TARIKH  : $tarikh", 0, 0, 'L');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"JENIS BAYARAN                   PUNGUTAN HARI INI     BULANAN TERKINI   TAHUNAN TERKINI", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"                               RESIT        AMAUN  RESIT        AMAUN  RESIT        AMAUN", 0, 0, 'L');
$pdf->Ln();
$pdf->Cell(0,3,"-----------------------------------------------------------------------------------------", 0, 0, 'L');

foreach ($arrResult as $curResult) {
	$rcp_nme = $curResult['rcp_nme'];
	$amt_today = $curResult['amt_today'];
	$totrcp_today = $curResult['totrcp_today'];
	$amt_month = $curResult['amt_month'];
	$totrcp_month = $curResult['totrcp_month'];
	$amt_year = $curResult['amt_year'];
	$totrcp_year = $curResult['totrcp_year'];

	$grandTotAmtToday += $amt_today;
	$grandTotRcpToday += $totrcp_today;
	$grandTotAmtMonth += $amt_month;
	$grandTotRcpMonth += $totrcp_month;
	$grandTotAmtYear += $amt_year;
	$grandTotRcpYear += $totrcp_year;

	$strRcpNme = str_pad(substr($rcp_nme, 0,30), 30, " ", STR_PAD_RIGHT);
	$strTotRcpToday = str_pad($totrcp_today, 5, " ", STR_PAD_LEFT);
	$strTotRcpMonth = str_pad($totrcp_month, 5, " ", STR_PAD_LEFT);
	$strTotRcpYear = str_pad($totrcp_year, 5, " ", STR_PAD_LEFT);
	$strAmtToday = str_pad(number_format($amt_today,2), 12, " ", STR_PAD_LEFT);
	$strAmtMonth = str_pad(number_format($amt_month,2), 12, " ", STR_PAD_LEFT);
	$strAmtYear = str_pad(number_format($amt_year,2), 12, " ", STR_PAD_LEFT);

	$pdf->Ln();
	$pdf->Cell(0,4,"$strRcpNme $strTotRcpToday $strAmtToday  $strTotRcpMonth $strAmtMonth  $strTotRcpYear $strAmtYear", 0, 0, 'L');
}

$strJumlah = str_pad("JUMLAH", 30, " ", STR_PAD_RIGHT);
$strGrandTotRcpToday = str_pad($grandTotRcpToday, 5, " ", STR_PAD_LEFT);
$strGrandTotRcpMonth = str_pad($grandTotRcpMonth, 5, " ", STR_PAD_LEFT);
$strGrandTotRcpYear = str_pad($grandTotRcpYear, 5, " ", STR_PAD_LEFT);
$strGrandTotAmtToday = str_pad(number_format($grandTotAmtToday,2), 12, " ", STR_PAD_LEFT);
$strGrandTotAmtMonth = str_pad(number_format($grandTotAmtMonth,2), 12, " ", STR_PAD_LEFT);
$strGrandTotAmtYear = str_pad(number_format($grandTotAmtYear,2), 12, " ", STR_PAD_LEFT);

$pdf->Ln();
$pdf->Ln();
$pdf->SetFont('Courier','B',$strFontSize);
$pdf->Cell(0,4,"$strJumlah $strGrandTotRcpToday $strGrandTotAmtToday  $strGrandTotRcpMonth $strGrandTotAmtMonth  $strGrandTotRcpYear $strGrandTotAmtYear", 0, 0, 'L');

$pdf->Output("CS06_$today_pdf.pdf","D");
?>
