<?php

include_once 'lib/db.php';
require_once ("scripts/fpdf17/fpdf.php");

$kumpulan = $_GET ['kumpulan'];
$tarikhdari = $_GET ['tarikhdari'];
$tarikhkepada = $_GET ['tarikhkepada'];
$paytypedari = $_POST ['paytypedari'];
$paytypeke = $_POST ['paytypeke'];

$strWhere = ($kumpulan) ? " AND a.DEP_GRP='$kumpulan'" : "";
$strWhere .= " AND (b.VOD_STU!='V' AND b.VOD_STU!='O')";

if ($tarikhdari && $tarikhkepada) {
	$strWhere .= " AND a.RCP_DTE BETWEEN STR_TO_DATE( '$tarikhdari', '%d/%m/%Y' )
AND STR_TO_DATE( '$tarikhkepada', '%d/%m/%Y' )";
}

if ($paytypedari && $paytypeke) {
	$strWhere .= " AND c.PAY_TYP BETWEEN '$paytypedari' AND '$paytypeke'";
}

$sql = "SELECT a.RCP_TYP,a.TTY_NUM,a.RCP_NUM,SUM(a.RCP_AMT) + SUM(a.TAX_AMT) AMT,d.RCP_NME,c.PAY_TYP,COUNT(DISTINCT(a.RCP_NUM)) TOTRCP
FROM aureline a, aurerecp b, aurepymt c, auretype d
WHERE 1
$strWhere
AND a.DEP_GRP=b.DEP_GRP
AND a.TTY_NUM=b.TTY_NUM
AND a.RCP_DTE=b.RCP_DTE
AND a.RCP_NUM=b.RCP_NUM
AND a.MOD_OPR=b.OPR_NUM
AND a.DEP_GRP=c.DEP_GRP
AND a.TTY_NUM=c.TTY_NUM
AND a.RCP_DTE=c.RCP_DTE
AND a.RCP_NUM=c.RCP_NUM
AND a.MOD_OPR=c.MOD_OPR
AND a.RCP_TYP=d.RCP_TYP
GROUP BY c.PAY_TYP,a.RCP_TYP";
$s = ($online == "1") ? db_query_server($sql) : db_query($sql);
while ( $row = db_fetch_array ( $s ) ) {
	$pay_typ = $row ['PAY_TYP'];
	$rcp_typ = $row ['RCP_TYP'];
	$rcp_nme = $row ['RCP_NME'];
	$amt = $row ['AMT'];
	$totrcp = $row ['TOTRCP'];
	$arrResult [$pay_typ][$rcp_typ]['rcp_nme'] = $rcp_nme;
	$arrResult [$pay_typ][$rcp_typ]['amt'] = $amt;
	$arrResult [$pay_typ][$rcp_typ]['totrcp'] = $totrcp;
}

$today = date ( 'd/m/Y' );
$today_pdf = date ( 'Ymd' );
$time = date ( 'H:i:s' );

$strCs05 = strtoupper($strCs05);
$strKumpulan = strtoupper($kumpulan);
$strFontSize = 10;

//pdf output
$pdf = new FPDF();
$pdf->AddPage('P','A4');
$pdf->SetFont('Courier','',$strFontSize);
$pdf->Ln();
$pdf->Ln();
$pdf->Ln();
$pdf->Cell(1,3,"REPORT NAME : CS-05", 0, 0, 'L');
$pdf->Cell(0,3,"$client_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT DATE : $today", 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$sys_name", 0, 0, 'C');
$pdf->Cell(0,3,"PRINT TIME : ".str_pad($time, 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"$strCs05", 0, 0, 'C');
$pdf->Cell(0,3,"PAGE : ".str_pad($pdf->PageNo(), 10, " ",STR_PAD_LEFT), 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(1,3,"", 0, 0, 'L');
$pdf->Cell(0,3,"BAGI PUSAT $strKumpulan", 0, 0, 'C');

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,3,"TARIKH DARI : $tarikhdari          TARIKH HINGGA : $tarikhkepada", 0, 0, 'L');

foreach ($arrResult as $pay_typ => $curResult) {
	$subTotAmt = $subTotRcp = 0;

	switch ($pay_typ) {
		case 1 :
			$jenis = "TUNAI";
			break;
		case 2 :
			$jenis = "CEK";
			break;
		case 3 :
			$jenis = "KAD KREDIT";
			break;
		case 4 :
			$jenis = "WANG POS";
			break;
		case 5 :
			$jenis = "EFT";
			break;
		case 6 :
			$jenis = "BANK DERAF";
			break;
		case 7 :
			$jenis = "BANK SLIP";
			break;
	}

	$pdf->Ln();
	$pdf->Ln();
	$pdf->SetFont('Courier','B',$strFontSize);
	$pdf->Cell(0,4,"JENIS BAYARAN : $jenis", 0, 0, 'L');

	$pdf->SetFont('Courier','',$strFontSize);
	$pdf->Ln();
	$pdf->Cell(0,4," SISTEM                                                                      AMAUN  RESIT", 0, 0, 'L');
	$pdf->Ln();
	$pdf->Cell(0,1," ----------------------------------------------------------------------------------------", 0, 0, 'L');

	foreach ($curResult as $curPay){
		$rcp_nme = $curPay['rcp_nme'];
		$amt = $curPay['amt'];
		$totrcp = $curPay['totrcp'];

		//$strAmt = str_pad(number_format($amt,2), 72 - strlen($rcp_nme), " ",STR_PAD_LEFT);
		$strRcpNme = str_pad(substr($rcp_nme, 0,68), 68, " ",STR_PAD_RIGHT);
		$strAmt = str_pad(number_format($amt,2), 12, " ",STR_PAD_LEFT);
		$strTotRcp = str_pad($totrcp, 6, " ",STR_PAD_LEFT);

		$pdf->Ln();
		$pdf->Cell(0,4," $strRcpNme $strAmt $strTotRcp", 0, 0, 'L');

		$subTotAmt += $amt;
		$grandTotAmt += $amt;
		$subTotRcp += $totrcp;
		$grandTotRcp += $totrcp;
	}

	$strSubTotAmt = str_pad(number_format($subTotAmt,2), 75, " ",STR_PAD_LEFT);
	$strSubTotRcp = str_pad($subTotRcp, 6, " ",STR_PAD_LEFT);

	$pdf->SetFont('Courier','B',$strFontSize);
	$pdf->Ln();
	$pdf->Cell(0,4,"JUMLAH $strSubTotAmt $strSubTotRcp", 0, 0, 'L');
}

$strGrandTotAmt = str_pad(number_format($grandTotAmt,2), 69, " ",STR_PAD_LEFT);
$strGrandTotRcp = str_pad($grandTotRcp, 6, " ",STR_PAD_LEFT);

$pdf->Ln();
$pdf->Ln();
$pdf->Cell(0,4,"JUMLAH BESAR $strGrandTotAmt $strGrandTotRcp", 0, 0, 'L');

$pdf->Output("CS05_$today_pdf.pdf","D");
?>
