<?php

Class Aualunit {

	protected $sqlTable = 'AUALUNIT';

	public $oprnum;  //OPR_NUM int(10)
	public $depgrp;  //DEP_GRP varchar(10)
	public $ttynum;  //TTY_NUM int(5)
	public $rcpdte;  //RCP_DTE date
	public $rcpgrp;  //RCP_GRP varchar(10)
	public $rm100;  //RM_100 int(10)
	public $rm50;  //RM_50 int(10)
	public $rm20;  //RM_20 int(10)
	public $rm2;  //RM_2 int(10)
	public $rm10;  //RM_10 int(10)
	public $rm5;  //RM_5 int(10)
	public $rm1;  //RM_1 int(10)
	public $sen50;  //SEN_50 int(10)
	public $sen20;  //SEN_20 int(10)
	public $sen10;  //SEN_10 int(10)
	public $sen5;  //SEN_5 int(10)
	public $sen1;  //SEN_1 int(10)
	public $qtyrm;  //QTY_RM int(10)
	public $qtysen;  //QTY_SEN int(10)
	public $totcsh;  //TOT_CSH double(16,2)
	public $totrcp;  //TOT_RCP double(16,2)
	public $credtetme;  //CRE_DTE_TME datetime
	public $moddtetme;  //MOD_DTE_TME datetime
	public $modopr;  //MOD_OPR int(10)

	public function insert($insertServer = 0) {

		global $online;

		if ( strlen ( $this->oprnum ) > 0 ) { $insertCols .= "OPR_NUM, "; $insertVals .= "'$this->oprnum', "; }
		if ( strlen ( $this->depgrp ) > 0 ) { $insertCols .= "DEP_GRP, "; $insertVals .= "'$this->depgrp', "; }
		if ( strlen ( $this->ttynum ) > 0 ) { $insertCols .= "TTY_NUM, "; $insertVals .= "'$this->ttynum', "; }
		if ( strlen ( $this->rcpdte ) > 0 ) { $insertCols .= "RCP_DTE, "; $insertVals .= "STR_TO_DATE('$this->rcpdte','%d/%m/%Y'), "; }
		if ( strlen ( $this->rcpgrp ) > 0 ) { $insertCols .= "RCP_GRP, "; $insertVals .= "'$this->rcpgrp', "; }
		if ( strlen ( $this->rm100 ) > 0 ) { $insertCols .= "RM_100, "; $insertVals .= "'$this->rm100', "; }
		if ( strlen ( $this->rm50 ) > 0 ) { $insertCols .= "RM_50, "; $insertVals .= "'$this->rm50', "; }
		if ( strlen ( $this->rm20 ) > 0 ) { $insertCols .= "RM_20, "; $insertVals .= "'$this->rm20', "; }
		if ( strlen ( $this->rm2 ) > 0 ) { $insertCols .= "RM_2, "; $insertVals .= "'$this->rm2', "; }
		if ( strlen ( $this->rm10 ) > 0 ) { $insertCols .= "RM_10, "; $insertVals .= "'$this->rm10', "; }
		if ( strlen ( $this->rm5 ) > 0 ) { $insertCols .= "RM_5, "; $insertVals .= "'$this->rm5', "; }
		if ( strlen ( $this->rm1 ) > 0 ) { $insertCols .= "RM_1, "; $insertVals .= "'$this->rm1', "; }
		if ( strlen ( $this->sen50 ) > 0 ) { $insertCols .= "SEN_50, "; $insertVals .= "'$this->sen50', "; }
		if ( strlen ( $this->sen20 ) > 0 ) { $insertCols .= "SEN_20, "; $insertVals .= "'$this->sen20', "; }
		if ( strlen ( $this->sen10 ) > 0 ) { $insertCols .= "SEN_10, "; $insertVals .= "'$this->sen10', "; }
		if ( strlen ( $this->sen5 ) > 0 ) { $insertCols .= "SEN_5, "; $insertVals .= "'$this->sen5', "; }
		if ( strlen ( $this->sen1 ) > 0 ) { $insertCols .= "SEN_1, "; $insertVals .= "'$this->sen1', "; }
		if ( strlen ( $this->qtyrm ) > 0 ) { $insertCols .= "QTY_RM, "; $insertVals .= "'$this->qtyrm', "; }
		if ( strlen ( $this->qtysen ) > 0 ) { $insertCols .= "QTY_SEN, "; $insertVals .= "'$this->qtysen', "; }
		if ( strlen ( $this->totcsh ) > 0 ) { $insertCols .= "TOT_CSH, "; $insertVals .= "'$this->totcsh', "; }
		if ( strlen ( $this->totrcp ) > 0 ) { $insertCols .= "TOT_RCP, "; $insertVals .= "'$this->totrcp', "; }
		$insertCols .= "CRE_DTE_TME, "; $insertVals .= "NOW(), ";
		if ( strlen ( $this->moddtetme ) > 0 ) { $insertCols .= "MOD_DTE_TME, "; $insertVals .= "STR_TO_DATE('$this->moddtetme','%d/%m/%Y'), "; }
		if ( strlen ( $this->modopr ) > 0 ) { $insertCols .= "MOD_OPR, "; $insertVals .= "'$this->modopr', "; }

		$insertCols = eregi_replace(", $", "", $insertCols);
		$insertVals = eregi_replace(", $", "", $insertVals);

		$sql = "INSERT INTO $this->sqlTable ($insertCols)";
		$sql .= " VALUES ($insertVals)";

		db_query ( $sql );
		$s = ($online == "1" && $insertServer == "1") ? db_query_server($sql) : "";
	}

	public function update($insertServer = 0) {

		global $online;

		$sql = "UPDATE $this->sqlTable SET ";

		if ( strlen ( $this->oprnum ) > 0 ) { $sql .= "OPR_NUM = '$this->oprnum', "; }
		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "DEP_GRP = '$this->depgrp', "; }
		if ( strlen ( $this->ttynum ) > 0 ) { $sql .= "TTY_NUM = '$this->ttynum', "; }
		if ( strlen ( $this->rcpdte ) > 0 ) { $sql .= "RCP_DTE = STR_TO_DATE('$this->rcpdte','%d/%m/%Y'), "; }
		if ( strlen ( $this->rcpgrp ) > 0 ) { $sql .= "RCP_GRP = '$this->rcpgrp', "; }
		if ( strlen ( $this->rm100 ) > 0 ) { $sql .= "RM_100 = '$this->rm100', "; }
		if ( strlen ( $this->rm50 ) > 0 ) { $sql .= "RM_50 = '$this->rm50', "; }
		if ( strlen ( $this->rm20 ) > 0 ) { $sql .= "RM_20 = '$this->rm20', "; }
		if ( strlen ( $this->rm2 ) > 0 ) { $sql .= "RM_2 = '$this->rm2', "; }
		if ( strlen ( $this->rm10 ) > 0 ) { $sql .= "RM_10 = '$this->rm10', "; }
		if ( strlen ( $this->rm5 ) > 0 ) { $sql .= "RM_5 = '$this->rm5', "; }
		if ( strlen ( $this->rm1 ) > 0 ) { $sql .= "RM_1 = '$this->rm1', "; }
		if ( strlen ( $this->sen50 ) > 0 ) { $sql .= "SEN_50 = '$this->sen50', "; }
		if ( strlen ( $this->sen20 ) > 0 ) { $sql .= "SEN_20 = '$this->sen20', "; }
		if ( strlen ( $this->sen10 ) > 0 ) { $sql .= "SEN_10 = '$this->sen10', "; }
		if ( strlen ( $this->sen5 ) > 0 ) { $sql .= "SEN_5 = '$this->sen5', "; }
		if ( strlen ( $this->sen1 ) > 0 ) { $sql .= "SEN_1 = '$this->sen1', "; }
		if ( strlen ( $this->qtyrm ) > 0 ) { $sql .= "QTY_RM = '$this->qtyrm', "; }
		if ( strlen ( $this->qtysen ) > 0 ) { $sql .= "QTY_SEN = '$this->qtysen', "; }
		if ( strlen ( $this->totcsh ) > 0 ) { $sql .= "TOT_CSH = '$this->totcsh', "; }
		if ( strlen ( $this->totrcp ) > 0 ) { $sql .= "TOT_RCP = '$this->totrcp', "; }
		$sql .= "MOD_DTE_TME = NOW(), ";
		if ( strlen ( $this->modopr ) > 0 ) { $sql .= "MOD_OPR = '$this->modopr', "; }

		$sql = eregi_replace ( ', $', '', $sql);

		$sql .= " WHERE 1=1 ";

		if ( strlen ( $this->oprnumori ) > 0 ) { $sql .= "AND OPR_NUM = '$this->oprnumori' "; }
		if ( strlen ( $this->depgrpori ) > 0 ) { $sql .= "AND DEP_GRP = '$this->depgrpori' "; }
		if ( strlen ( $this->ttynumori ) > 0 ) { $sql .= "AND TTY_NUM = '$this->ttynumori' "; }
		if ( strlen ( $this->rcpgrpori ) > 0 ) { $sql .= "AND RCP_GRP = '$this->rcpgrpori' "; }
		if ( strlen ( $this->rcpdteori ) > 0 ) { $sql .= "AND RCP_DTE = STR_TO_DATE('$this->rcpdteori','%d/%m/%Y') "; }

		db_query ( $sql );
		$s = ($online == "1" && $insertServer == "1") ? db_query_server($sql) : "";
	}

	public function select() {

		$sql = "SELECT *
		, DATE_FORMAT(RCP_DTE,'%d/%m/%Y') RCP_DTE
		, DATE_FORMAT(CRE_DTE_TME,'%d/%m/%Y %H:%i:%s') CRE_DTE_TME
		, DATE_FORMAT(MOD_DTE_TME,'%d/%m/%Y %H:%i:%s') MOD_DTE_TME
		FROM $this->sqlTable WHERE 1=1 ";

		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$this->oprnum = $row ['OPR_NUM'];
			$this->depgrp = $row ['DEP_GRP'];
			$this->ttynum = $row ['TTY_NUM'];
			$this->rcpdte = $row ['RCP_DTE'];
			$this->rcpgrp = $row ['RCP_GRP'];
			$this->rm100 = $row ['RM_100'];
			$this->rm50 = $row ['RM_50'];
			$this->rm20 = $row ['RM_20'];
			$this->rm2 = $row ['RM_2'];
			$this->rm10 = $row ['RM_10'];
			$this->rm5 = $row ['RM_5'];
			$this->rm1 = $row ['RM_1'];
			$this->sen50 = $row ['SEN_50'];
			$this->sen20 = $row ['SEN_20'];
			$this->sen10 = $row ['SEN_10'];
			$this->sen5 = $row ['SEN_5'];
			$this->sen1 = $row ['SEN_1'];
			$this->qtyrm = $row ['QTY_RM'];
			$this->qtysen = $row ['QTY_SEN'];
			$this->totcsh = $row ['TOT_CSH'];
			$this->totrcp = $row ['TOT_RCP'];
			$this->credtetme = $row ['CRE_DTE_TME'];
			$this->moddtetme = $row ['MOD_DTE_TME'];
			$this->modopr = $row ['MOD_OPR'];
		}

	}

	public function count () {

		$total = 0;
		$sql = "SELECT COUNT(*) TOTAL FROM $this->sqlTable WHERE 1=1 ";

		if ( strlen ( $this->oprnum ) > 0 ) { $sql .= "AND OPR_NUM = '$this->oprnum' "; }
		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "AND DEP_GRP = '$this->depgrp' "; }
		if ( strlen ( $this->ttynum ) > 0 ) { $sql .= "AND TTY_NUM = '$this->ttynum' "; }
		if ( strlen ( $this->rcpgrp ) > 0 ) { $sql .= "AND RCP_GRP = '$this->rcpgrp' "; }
		if ( strlen ( $this->rcpdte ) > 0 ) { $sql .= "AND RCP_DTE = STR_TO_DATE('$this->rcpdte','%d/%m/%Y') "; }

		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$total = $row ['TOTAL'];
		}
		return $total;

	}

	public function delete ($insertServer = 0) {

		global $online;

		$sql = "DELETE FROM $this->sqlTable WHERE 1=1 ";

		if ( strlen ( $this->oprnum ) > 0 ) { $sql .= "AND OPR_NUM = '$this->oprnum' "; }
		if ( strlen ( $this->depgrp ) > 0 ) { $sql .= "AND DEP_GRP = '$this->depgrp' "; }
		if ( strlen ( $this->ttynum ) > 0 ) { $sql .= "AND TTY_NUM = '$this->ttynum' "; }
		if ( strlen ( $this->rcpgrp ) > 0 ) { $sql .= "AND RCP_GRP = '$this->rcpgrp' "; }
		if ( strlen ( $this->rcpdte ) > 0 ) { $sql .= "AND RCP_DTE = STR_TO_DATE('$this->rcpdte','%d/%m/%Y') "; }

		$sql .= " LIMIT 1";

		db_query ( $sql );
		$s = ($online == "1" && $insertServer == "1") ? db_query_server($sql) : "";

	}

}

?>