<?php

Class Aualexln {

	protected $sqlTable = 'AUALEXLN';

	public $mduref;  //MDU_REF varchar(2)
	public $refacc;  //REF_ACC varchar(32)
	public $refdsc;  //REF_DSC varchar(50)
	public $lgracc;  //LGR_ACC varchar(21)
	public $desmdu;  //DES_MDU varchar(2)
	public $desacc;  //DES_ACC varchar(21)
	public $opndte;  //OPN_DTE date
	public $clodte;  //CLO_DTE date
	public $stucde;  //STU_CDE int(5)
	public $cdeno1;  //CDE_NO1 int(5)
	public $cdeno2;  //CDE_NO2 int(5)
	public $cdeno3;  //CDE_NO3 int(10)
	public $cdeno4;  //CDE_NO4 int(10)
	public $cdeno5;  //CDE_NO5 double(12,2)
	public $cdeno6;  //CDE_NO6 double(12,2)
	public $cdeno7;  //CDE_NO7 double(12,6)
	public $cdeno8;  //CDE_NO8 double(12,6)
	public $cdeno9;  //CDE_NO9 varchar(30)
	public $cdeno10;  //CDE_NO10 varchar(30)
	public $credtetme;  //CRE_DTE_TME datetime
	public $moddtetme;  //MOD_DTE_TME datetime
	public $modopr;  //MOD_OPR int(10)

	public function insert() {

		if ( strlen ( $this->mduref ) > 0 ) { $insertCols .= "MDU_REF, "; $insertVals .= "'$this->mduref', "; }
		if ( strlen ( $this->refacc ) > 0 ) { $insertCols .= "REF_ACC, "; $insertVals .= "'$this->refacc', "; }
		if ( strlen ( $this->refdsc ) > 0 ) { $insertCols .= "REF_DSC, "; $insertVals .= "'$this->refdsc', "; }
		if ( strlen ( $this->lgracc ) > 0 ) { $insertCols .= "LGR_ACC, "; $insertVals .= "'$this->lgracc', "; }
		if ( strlen ( $this->desmdu ) > 0 ) { $insertCols .= "DES_MDU, "; $insertVals .= "'$this->desmdu', "; }
		if ( strlen ( $this->desacc ) > 0 ) { $insertCols .= "DES_ACC, "; $insertVals .= "'$this->desacc', "; }
		if ( strlen ( $this->opndte ) > 0 ) { $insertCols .= "OPN_DTE, "; $insertVals .= "STR_TO_DATE('$this->opndte','%d/%m/%Y'), "; }
		if ( strlen ( $this->clodte ) > 0 ) { $insertCols .= "CLO_DTE, "; $insertVals .= "STR_TO_DATE('$this->clodte','%d/%m/%Y'), "; }
		if ( strlen ( $this->stucde ) > 0 ) { $insertCols .= "STU_CDE, "; $insertVals .= "'$this->stucde', "; }
		if ( strlen ( $this->cdeno1 ) > 0 ) { $insertCols .= "CDE_NO1, "; $insertVals .= "'$this->cdeno1', "; }
		if ( strlen ( $this->cdeno2 ) > 0 ) { $insertCols .= "CDE_NO2, "; $insertVals .= "'$this->cdeno2', "; }
		if ( strlen ( $this->cdeno3 ) > 0 ) { $insertCols .= "CDE_NO3, "; $insertVals .= "'$this->cdeno3', "; }
		if ( strlen ( $this->cdeno4 ) > 0 ) { $insertCols .= "CDE_NO4, "; $insertVals .= "'$this->cdeno4', "; }
		if ( strlen ( $this->cdeno5 ) > 0 ) { $insertCols .= "CDE_NO5, "; $insertVals .= "'$this->cdeno5', "; }
		if ( strlen ( $this->cdeno6 ) > 0 ) { $insertCols .= "CDE_NO6, "; $insertVals .= "'$this->cdeno6', "; }
		if ( strlen ( $this->cdeno7 ) > 0 ) { $insertCols .= "CDE_NO7, "; $insertVals .= "'$this->cdeno7', "; }
		if ( strlen ( $this->cdeno8 ) > 0 ) { $insertCols .= "CDE_NO8, "; $insertVals .= "'$this->cdeno8', "; }
		if ( strlen ( $this->cdeno9 ) > 0 ) { $insertCols .= "CDE_NO9, "; $insertVals .= "'$this->cdeno9', "; }
		if ( strlen ( $this->cdeno10 ) > 0 ) { $insertCols .= "CDE_NO10, "; $insertVals .= "'$this->cdeno10', "; }
		if ( strlen ( $this->credtetme ) > 0 ) { $insertCols .= "CRE_DTE_TME, "; $insertVals .= "STR_TO_DATE('$this->credtetme','%d/%m/%Y'), "; }
		if ( strlen ( $this->moddtetme ) > 0 ) { $insertCols .= "MOD_DTE_TME, "; $insertVals .= "STR_TO_DATE('$this->moddtetme','%d/%m/%Y'), "; }
		if ( strlen ( $this->modopr ) > 0 ) { $insertCols .= "MOD_OPR, "; $insertVals .= "'$this->modopr', "; }

		$insertCols = eregi_replace(", $", "", $insertCols);
		$insertVals = eregi_replace(", $", "", $insertVals);

		$sql = "INSERT INTO $this->sqlTable ($insertCols)";
		$sql .= " VALUES ($insertVals)";

		db_query ( $sql );
	}

	public function update() {

		$sql = "UPDATE $this->sqlTable SET ";

		if ( strlen ( $this->mduref ) > 0 ) { $sql .= "MDU_REF = '$this->mduref', "; }
		if ( strlen ( $this->refacc ) > 0 ) { $sql .= "REF_ACC = '$this->refacc', "; }
		if ( strlen ( $this->refdsc ) > 0 ) { $sql .= "REF_DSC = '$this->refdsc', "; }
		if ( strlen ( $this->lgracc ) > 0 ) { $sql .= "LGR_ACC = '$this->lgracc', "; }
		if ( strlen ( $this->desmdu ) > 0 ) { $sql .= "DES_MDU = '$this->desmdu', "; }
		if ( strlen ( $this->desacc ) > 0 ) { $sql .= "DES_ACC = '$this->desacc', "; }
		if ( strlen ( $this->opndte ) > 0 ) { $sql .= "OPN_DTE = STR_TO_DATE('$this->opndte','%d/%m/%Y'), "; }
		if ( strlen ( $this->clodte ) > 0 ) { $sql .= "CLO_DTE = STR_TO_DATE('$this->clodte','%d/%m/%Y'), "; }
		if ( strlen ( $this->stucde ) > 0 ) { $sql .= "STU_CDE = '$this->stucde', "; }
		if ( strlen ( $this->cdeno1 ) > 0 ) { $sql .= "CDE_NO1 = '$this->cdeno1', "; }
		if ( strlen ( $this->cdeno2 ) > 0 ) { $sql .= "CDE_NO2 = '$this->cdeno2', "; }
		if ( strlen ( $this->cdeno3 ) > 0 ) { $sql .= "CDE_NO3 = '$this->cdeno3', "; }
		if ( strlen ( $this->cdeno4 ) > 0 ) { $sql .= "CDE_NO4 = '$this->cdeno4', "; }
		if ( strlen ( $this->cdeno5 ) > 0 ) { $sql .= "CDE_NO5 = '$this->cdeno5', "; }
		if ( strlen ( $this->cdeno6 ) > 0 ) { $sql .= "CDE_NO6 = '$this->cdeno6', "; }
		if ( strlen ( $this->cdeno7 ) > 0 ) { $sql .= "CDE_NO7 = '$this->cdeno7', "; }
		if ( strlen ( $this->cdeno8 ) > 0 ) { $sql .= "CDE_NO8 = '$this->cdeno8', "; }
		if ( strlen ( $this->cdeno9 ) > 0 ) { $sql .= "CDE_NO9 = '$this->cdeno9', "; }
		if ( strlen ( $this->cdeno10 ) > 0 ) { $sql .= "CDE_NO10 = '$this->cdeno10', "; }
		if ( strlen ( $this->credtetme ) > 0 ) { $sql .= "CRE_DTE_TME = STR_TO_DATE('$this->credtetme','%d/%m/%Y'), "; }
		if ( strlen ( $this->moddtetme ) > 0 ) { $sql .= "MOD_DTE_TME = STR_TO_DATE('$this->moddtetme','%d/%m/%Y'), "; }
		if ( strlen ( $this->modopr ) > 0 ) { $sql .= "MOD_OPR = '$this->modopr', "; }

		$sql = eregi_replace ( ', $', '', $sql);

		$sql .= " WHERE 1=1 ";


		db_query ( $sql );
	}

	public function select() {

		$sql = "SELECT *
		, DATE_FORMAT(OPN_DTE,'%d/%m/%Y') OPN_DTE
		, DATE_FORMAT(CLO_DTE,'%d/%m/%Y') CLO_DTE
		, DATE_FORMAT(CRE_DTE_TME,'%d/%m/%Y %H:%i:%s') CRE_DTE_TME
		, DATE_FORMAT(MOD_DTE_TME,'%d/%m/%Y %H:%i:%s') MOD_DTE_TME
		FROM $this->sqlTable WHERE 1=1 ";

		if ( strlen ( $this->mduref ) > 0 ) { $sql .= "AND MDU_REF = '$this->mduref' "; }
		if ( strlen ( $this->lgracc ) > 0 ) { $sql .= "AND LGR_ACC = '$this->lgracc' "; }

		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$this->mduref = $row ['MDU_REF'];
			$this->refacc = $row ['REF_ACC'];
			$this->refdsc = $row ['REF_DSC'];
			$this->lgracc = $row ['LGR_ACC'];
			$this->desmdu = $row ['DES_MDU'];
			$this->desacc = $row ['DES_ACC'];
			$this->opndte = $row ['OPN_DTE'];
			$this->clodte = $row ['CLO_DTE'];
			$this->stucde = $row ['STU_CDE'];
			$this->cdeno1 = $row ['CDE_NO1'];
			$this->cdeno2 = $row ['CDE_NO2'];
			$this->cdeno3 = $row ['CDE_NO3'];
			$this->cdeno4 = $row ['CDE_NO4'];
			$this->cdeno5 = $row ['CDE_NO5'];
			$this->cdeno6 = $row ['CDE_NO6'];
			$this->cdeno7 = $row ['CDE_NO7'];
			$this->cdeno8 = $row ['CDE_NO8'];
			$this->cdeno9 = $row ['CDE_NO9'];
			$this->cdeno10 = $row ['CDE_NO10'];
			$this->credtetme = $row ['CRE_DTE_TME'];
			$this->moddtetme = $row ['MOD_DTE_TME'];
			$this->modopr = $row ['MOD_OPR'];
		}

	}

	public function count () {

		$total = 0;
		$sql = "SELECT COUNT(*) TOTAL FROM $this->sqlTable WHERE 1=1 ";


		$s = db_query ( $sql );
		while ( $row = db_fetch_array ( $s ) ) {
			$total = $row ['TOTAL'];
		}
		return $total;

	}

	public function delete () {

		$sql = "DELETE FROM $this->sqlTable WHERE 1=1";


		db_query ( $sql );

	}

}

?>